package org.hoyi.util;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;


public abstract class SessionUtils
{

	/**
	 * 获取登录之后的用户.先验证Session,再验证Uid和TokenId.
	 * 
	 * @param request
	 * @return value
	 */
	public static String get_Logined_USERID(HttpServletRequest request)
	{
		return (String) request.getSession().getAttribute(Constant.CURRENT_HOYI_USER_ID);
	}

	public static void LogOut(HttpServletRequest request)
	{
		request.getSession().setAttribute(Constant.CURRENT_HOYI_USER_ID, null);
		request.getSession().setAttribute(Constant.CURRENT_HOYI_USER_NAME, null);
		request.getSession().setAttribute("HOYI_USER_TYPE", null);
	}

	/**
	 * 登录， 设置用户.
	 * @param request
	 * @param _userid
	 * @param _username
	 */
	public static void SetLoginedUserID(HttpServletRequest request, String _userid, String _username)
	{
		HttpSession httpSession = request.getSession(true);
		httpSession.setAttribute(Constant.CURRENT_HOYI_USER_ID, _userid);
		httpSession.setAttribute(Constant.CURRENT_HOYI_USER_NAME, _username);
	}
	/**
	 * 设置SESSION.
	 * @param request
	 * @param key
	 * @param values
	 */
	public static void SetSessionKey(HttpServletRequest request, String key, String values) {
		HttpSession httpSession = request.getSession(true);
		httpSession.setAttribute(key, values);
	}
	
	/**
	 * 从SESSION内读取值.
	 * @param request
	 * @param key
	 * @return value
	 */
	public static String GetSessinValue(HttpServletRequest request, String key) {
		Object usid = request.getSession().getAttribute(key);
		if (usid == null) {
			return null;
		}
		return usid.toString();
	}
	
	public static void SetLoginedUsertype(HttpServletRequest request, String ustype){
		HttpSession httpSession = request.getSession(true);
		httpSession.setAttribute("HOYI_USER_TYPE", ustype);
	}
	
	public static String getLoginedUsertype(HttpServletRequest request){
		Object usid = request.getSession().getAttribute("HOYI_USER_TYPE");
		if (usid == null) {
			return null;
		}
		return usid.toString();
	}
	
	public static boolean IsLogined(HttpServletRequest request)
	{
		return request.getSession().getAttribute(Constant.CURRENT_HOYI_USER_ID) != null;
	}
	
	public static String getLoginedUserID(HttpServletRequest request)
	{
		Object usid = request.getSession().getAttribute(Constant.CURRENT_HOYI_USER_ID);
		if (usid == null) {
			return null;
		}
		return usid.toString();
	}
	
	public static String getLoginedUserName(HttpServletRequest request)
	{
		Object usid = request.getSession().getAttribute(Constant.CURRENT_HOYI_USER_NAME);
		if (usid == null) {
			return null;
		}
		return usid.toString();
	}

}