/*
 * Decompiled with CFR 0.152.
 */
package org.hoyi.staticcache;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PackageClassUtil {
    public static void main(String[] args) throws Exception {
    }

    public static List<Class<?>> getClassName(String packageName) {
        return PackageClassUtil.getClassName(packageName, true);
    }

    public static List<Class<?>> getClassName(String packageName, boolean childPackage) {
        String packagePath;
        List<Class<?>> fileNames = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL url = loader.getResource(packagePath = packageName.replace(".", "/"));
        if (url != null) {
            String type = url.getProtocol();
            if (type.equals("file")) {
                fileNames = PackageClassUtil.getClassNameByFile(url.getPath(), null, childPackage);
            } else if (type.equals("jar")) {
                fileNames = PackageClassUtil.getClassNameByJar(url.getPath(), childPackage);
            }
        } else {
            fileNames = PackageClassUtil.getClassNameByJars(((URLClassLoader)loader).getURLs(), packagePath, childPackage);
        }
        return fileNames;
    }

    private static List<Class<?>> getClassNameByFile(String filePath, List<Class<?>> className, boolean childPackage) {
        File[] childFiles;
        ArrayList myClassName = new ArrayList();
        File file = new File(filePath);
        for (File childFile : childFiles = file.listFiles()) {
            if (childFile.isDirectory()) {
                if (!childPackage) continue;
                myClassName.addAll(PackageClassUtil.getClassNameByFile(childFile.getPath(), myClassName, childPackage));
                continue;
            }
            String childFilePath = childFile.getPath();
            if (!childFilePath.endsWith(".class")) continue;
            String os = System.getProperty("os.name");
            if (os.toLowerCase().startsWith("win")) {
                childFilePath = childFilePath.substring(childFilePath.indexOf("\\classes") + 9, childFilePath.lastIndexOf("."));
                childFilePath = childFilePath.replace("\\", ".");
            } else {
                childFilePath = childFilePath.substring(childFilePath.indexOf("/classes") + 9, childFilePath.lastIndexOf("."));
                childFilePath = childFilePath.replace("/", ".");
            }
            try {
                Class<?> disp = Thread.currentThread().getContextClassLoader().loadClass(childFilePath);
                myClassName.add(disp);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return myClassName;
    }

    private static List<Class<?>> getClassNameByJar(String jarPath, boolean childPackage) {
        ArrayList myClassName = new ArrayList();
        String[] jarInfo = jarPath.split("!");
        String jarFilePath = jarInfo[0].substring(jarInfo[0].indexOf("/"));
        String packagePath = jarInfo[1].substring(1);
        try {
            JarFile jarFile = new JarFile(jarFilePath);
            Enumeration<JarEntry> entrys = jarFile.entries();
            while (entrys.hasMoreElements()) {
                JarEntry jarEntry = entrys.nextElement();
                String entryName = jarEntry.getName();
                if (!entryName.endsWith(".class")) continue;
                if (childPackage) {
                    if (!entryName.startsWith(packagePath)) continue;
                    entryName = entryName.replace("/", ".").substring(0, entryName.lastIndexOf("."));
                    myClassName.add(jarEntry.getClass());
                    continue;
                }
                int index2 = entryName.lastIndexOf("/");
                String myPackagePath = index2 != -1 ? entryName.substring(0, index2) : entryName;
                if (!myPackagePath.equals(packagePath)) continue;
                entryName = entryName.replace("/", ".").substring(0, entryName.lastIndexOf("."));
                myClassName.add(jarEntry.getClass());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return myClassName;
    }

    private static List<Class<?>> getClassNameByJars(URL[] urls, String packagePath, boolean childPackage) {
        ArrayList myClassName = new ArrayList();
        if (urls != null) {
            for (int i = 0; i < urls.length; ++i) {
                URL url = urls[i];
                String urlPath = url.getPath();
                if (urlPath.endsWith("classes/")) continue;
                String jarPath = urlPath + "!/" + packagePath;
                myClassName.addAll(PackageClassUtil.getClassNameByJar(jarPath, childPackage));
            }
        }
        return myClassName;
    }
}

