package org.hoyi.microservice.api.anno;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE, ElementType.METHOD})
public @interface ApiPara {
	/**
	 * 参数的名称.
	 */
	 String Name();
	/**
	 * 参数名的说明，也就是中文名.
	 */
	 String Comment();
		
	 /**
	 * 参数的说明.
	 */
	 String Notes() default "";
	/**
	 * 接口的类型，例如INT,DECIMAL,BOOLEAN,STRING等.
	 */
	 String CHARType()  default "String";
	
	/**
	 * 是否不能为空
	 */
	 boolean Required() default false;
}
