package org.hoyi.microservice.api.anno;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 用于生成API文档的注解.
 * @author sam
 *
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE, ElementType.METHOD})
public @interface Apidoc {
	/**
	 * 模块.
	 */
	 String Module() default "";

	/**
	 * 分类,相当于二级模块分类.
	 */
	 String Cates() default "";

	/**
	 * 相当于当前API的介绍.
	 */
	 String Notes() default "";

	/**
	 * 请求的路径
	 */
	 String ReqURL() default "";

	/**
	 * POST,GET,DELETE??
	 */
	 String ReqType() default "POST";
	
	/**
	 * 返回值，有的返回String ,有的返回void, 有的返回JsonModel.
	 */
	 String retValue() default "void";

	/**
	 * 是否能接受请求
	 */
	 boolean CanReq() default false;

	/**
	 * 接口的所有参数.
	 */
	 ApiPara[] paras() default {};
	 
	 /**
	  * 实体类当作参数.
	  * @return value
	  */
	 ApiEntityPara[] entityparas() default {};
	 
	 /**
	  * 返回字段的说明.
	  * @return value
	  */
	 ApiPara[] response() default{};

}
