package org.hoyi.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.hoyi.DB.ctrl.Console;
import org.hoyi.dishop.Hoyipage;

/**
 * Author:ellen Email:ellen@kuaifish.com CreateDate:2015-05-20
 * ModifyDate:2015-06-20 hoyi entities @ hoyi.org 使用请在项目关于内标注hoyi版权，
 * hoyi版权归hoyi.org所有
 */
public class HttpRequest {
	
	/**
	 *  发送Get请求.
	 * @param url
	 * @param param
	 * @return value
	 */
	public static String sendGet(String url, String param) {
		String result = "";
		BufferedReader in = null;
		try {
			String urlNameString = url + "?" + param;
			URL realUrl = new URL(urlNameString);

			URLConnection connection = realUrl.openConnection();

			connection.setRequestProperty("accept", "*/*");
			connection.setRequestProperty("connection", "Keep-Alive");
			connection.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
			connection.setRequestProperty("Charset", "utf-8");

			connection.connect();

			Map<String, List<String>> map = connection.getHeaderFields();

			for (String key : map.keySet()) {
				System.out.println(key + "--->" + map.get(key));
			}

			in = new BufferedReader(new InputStreamReader(connection.getInputStream(), "utf-8"));
			String line;
			while ((line = in.readLine()) != null) {
				result = result + line;
			}
		} catch (Exception e) {
			System.out.println("发送GET请求出现异常！" + e);
			Console.Error(e);
			try {
				if (in != null)
					in.close();
			} catch (Exception e2) {
			}
		} finally {
			try {
				if (in != null)
					in.close();
			} catch (Exception e2) {
			}
		}
		return result;
	}
	
	/**
	 *  发送Post请求.
	 * @param url
	 * @param param
	 * @return value
	 * @throws UnsupportedEncodingException
	 */
	public static String sendPost(String url, String param) throws UnsupportedEncodingException {
		PrintWriter out = null;
		BufferedReader in = null;
		String result = "";
		try {
			URL realUrl = new URL(url);

			URLConnection conn = realUrl.openConnection();

			conn.setRequestProperty("accept", "*/*");
			conn.setRequestProperty("connection", "Keep-Alive");
			conn.setRequestProperty("user-agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
			conn.setRequestProperty("Charset", "utf-8");

			conn.setDoOutput(true);
			conn.setDoInput(true);

			out = new PrintWriter(conn.getOutputStream());

			out.print(param);

			out.flush();

			in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));
			String line;
			while ((line = in.readLine()) != null) {
				result = result + line;
			}
		} catch (Exception e) {
			System.out.println("发送 POST 请求出现异常！" + e);
			Console.Error(e);
			try {
				if (out != null) {
					out.close();
				}
				if (in != null)
					in.close();
			} catch (IOException ex) {
				ex.printStackTrace();
			}
		} finally {
			try {
				if (out != null) {
					out.close();
				}
				if (in != null)
					in.close();
			} catch (IOException ex) {
			}
		}
		return result;
	}
	/**
	 * 获取Post的QueryString.
	 * @param _page
	 * @return value
	 */
	public String getPostQueryString(Hoyipage _page) {
		return this.getPostQueryString(_page.getRequest());
	}
	/**
	 * 获取Post的QueryString.
	 * 
	 * @param _rHttpServletRequest
	 * @return value
	 */
	public String getPostQueryString(HttpServletRequest _rHttpServletRequest) {
		Map<String, String[]> params = _rHttpServletRequest.getParameterMap();
		String queryString = "";
		for (String key : params.keySet()) {
			String[] values = params.get(key);
			for (int i = 0; i < values.length; i++) {
				String value = values[i];
				queryString += key + "=" + value + "&";
			}
		}
		// 去掉最后一个空格
		queryString = queryString.substring(0, queryString.length() - 1);
		return queryString;
	}
}
