package org.hoyi.util;

import java.util.HashSet;
import java.util.List;

import org.hoyi.DB.Interface.baseExpert;
import org.hoyi.DB.model.DataColumn;
import org.hoyi.DB.model.DataRow;
import org.hoyi.DB.model.DataTable;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonValueProcessor;
import net.sf.json.util.PropertyFilter;

/**
 *
 * @author ljb 84024551@qq.com 2015年11月9日
 *
 */
public class JsonUtil
{
	public static JsonConfig Config;

	static
	{
		Config = createCfg();
	}

	public static JsonConfig createCfg()
	{
		JsonConfig config = new JsonConfig();
		config.setJsonPropertyFilter(new PropertyFilter()
		{
			HashSet<String> set = new HashSet<String>();
			{
				set.add("database");
				set.add("autoCommit");
				set.add("_isPersisted");
				set.add("_tableName");
				set.add("_entityComment");
				set.add("firstfield");
				set.add("secondfield");
				set.add("columns");
				set.add("count");
				set.add("tableName");
			}
			@Override
			public boolean apply(Object source, String name, Object val)
			{
				if (source instanceof baseExpert || source instanceof DataTable)
					return set.contains(name);
				return false;
			}
		});
		config.registerJsonValueProcessor(DataTable.class, new JsonValueProcessor()
		{
			@Override
			public Object processObjectValue(String key, Object val, JsonConfig cfg)
			{
				if (val instanceof DataTable)
				{
					DataTable dt = (DataTable) val;
					JSONArray array = new JSONArray();
					for (int i = 0; i < dt.getRows().size(); i++)
					{
						DataRow row = dt.getRows().get(i);
						List<DataColumn> columns = row.getColumns();

						JSONObject json = new JSONObject();
						for (int j = 0; j < columns.size(); j++)
						{
							if (row.GetData(j) instanceof String)
							{
								String data = row.GetData(j) == null ? "" : row.GetData(j).toString();
								json.element(columns.get(j).ColumnName, data);
							}
							else
								json.element(columns.get(j).ColumnName,  (Object)row.GetData(j), cfg);
						}
						array.add(json);
					}
//					return array.toString();
					return array;
				}
				return val;
			}

			@Override
			public Object processArrayValue(Object val, JsonConfig cfg)
			{
				return null;
			}
		});
		
		config.registerJsonValueProcessor(DataRow.class, new JsonValueProcessor()
		{
			@Override
			public Object processObjectValue(String key, Object val, JsonConfig cfg)
			{
				if (val instanceof DataRow)
				{
					DataRow row = (DataRow) val;
					List<DataColumn> columns = row.getColumns();

					JSONObject json = new JSONObject();
					for (int j = 0; j < columns.size(); j++)
					{
						if (row.GetData(j) instanceof String)
						{
							String data = row.GetData(j) == null ? "" : row.GetData(j).toString();
							json.element(columns.get(j).ColumnName, data);
						}
						else
							json.element(columns.get(j).ColumnName, (Object)row.GetData(j), cfg);
					}
					return json;
				}
				return val;
			}
			
			@Override
			public Object processArrayValue(Object arg0, JsonConfig arg1)
			{
				return null;
			}
		});
		return config;
	}
}
