package org.hoyi.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;

import org.hoyi.DB.ctrl.Console;

/**
 *          Author:ellen
 *          Email:ellen@kuaifish.com
 *          CreateDate:2015-05-20
 *          ModifyDate:2015-06-20
 *          hoyi entities @ hoyi.org
 *          使用请在项目关于内标注hoyi版权，
 *          hoyi版权归hoyi.org所有
 */
public class ReadFromFile
{
  public static void readFileByBytes(String fileName)
  {
    File file = new File(fileName);
    InputStream in = null;
    try {
      System.out.println("以字节为单位读取文件内容，一次读一个字节：");

      in = new FileInputStream(file);
      int tempbyte;
      while ((tempbyte = in.read()) != -1)
      {
       // int tempbyte;
        System.out.write(tempbyte);
      }
      in.close();
    } catch (IOException e) {
    	Console.Error(e);
      return;
    }
    try {
      System.out.println("以字节为单位读取文件内容，一次读多个字节：");

      byte[] tempbytes = new byte[100];
      int byteread = 0;
      in = new FileInputStream(fileName);
      showAvailableBytes(in);

      while ((byteread = in.read(tempbytes)) != -1)
        System.out.write(tempbytes, 0, byteread);
    }
    catch (Exception e1) {
    	Console.Error(e1);

      if (in != null)
        try {
          in.close();
        }
        catch (IOException localIOException1)
        {
        }
    }
    finally
    {
      if (in != null)
        try {
          in.close();
        }
        catch (IOException localIOException2) {
        }
    }
  }

  public static String readFileByChars(String fileName, String encode) {
    File file = new File(fileName);
    Reader reader = null;
    String ss = "";
    try
    {
      reader = new InputStreamReader(new FileInputStream(file), encode);
      int tempchar;
      while ((tempchar = reader.read()) != -1)
      {
        //int tempchar;
        if ((char)tempchar != '\r')
        {
          ss = ss + (char)tempchar;
        }
      }
      reader.close();
    } catch (Exception e) {
    	Console.Error(e);
    }
    return ss;
  }

  public static String readFileByChars(String fileName)
  {
    return readFileByChars(fileName, "UTF-8");
  }

  public static void readFileByLines(String fileName)
  {
    File file = new File(fileName);
    BufferedReader reader = null;
    try {
      System.out.println("以行为单位读取文件内容，一次读一整行：");
      reader = new BufferedReader(new FileReader(file));
      String tempString = null;
      int line = 1;

      while ((tempString = reader.readLine()) != null)
      {
        System.out.println("line " + line + ": " + tempString);
        line++;
      }
      reader.close();
    } catch (IOException e) {
    	Console.Error(e);

      if (reader != null)
        try {
          reader.close();
        }
        catch (IOException localIOException1)
        {
        }
    }
    finally
    {
      if (reader != null)
        try {
          reader.close();
        }
        catch (IOException localIOException2)
        {
        }
    }
  }

  public static void readFileByRandomAccess(String fileName)
  {
    RandomAccessFile randomFile = null;
    try {
      System.out.println("随机读取一段文件内容：");

      randomFile = new RandomAccessFile(fileName, "r");

      long fileLength = randomFile.length();

      int beginIndex = fileLength > 4L ? 4 : 0;

      randomFile.seek(beginIndex);
      byte[] bytes = new byte[10];
      int byteread = 0;

      while ((byteread = randomFile.read(bytes)) != -1)
        System.out.write(bytes, 0, byteread);
    }
    catch (IOException e) {
    	Console.Error(e);

      if (randomFile != null)
        try {
          randomFile.close();
        }
        catch (IOException localIOException1)
        {
        }
    }
    finally
    {
      if (randomFile != null)
        try {
          randomFile.close();
        }
        catch (IOException localIOException2)
        {
        }
    }
  }

  private static void showAvailableBytes(InputStream in)
  {
	    try
	    {
	      System.out.println("当前字节输入流中的字节数为:" + in.available());
	    } catch (IOException e) {
	    	Console.Error(e);
	    }
  }

  public static void main(String[] args) {
    String fileName = "C:/temp/newTemp.txt";
    readFileByBytes(fileName);
    readFileByChars(fileName);
    readFileByLines(fileName);
    readFileByRandomAccess(fileName);
  }
}

