/*
 * Decompiled with CFR 0.152.
 */
package org.hravemzdy.procezor.registry;

import com.github.michaelbull.result.Err;
import com.github.michaelbull.result.Result;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import org.hravemzdy.legalios.interfaces.IBundleProps;
import org.hravemzdy.legalios.interfaces.IPeriod;
import org.hravemzdy.procezor.interfaces.IArticleSpec;
import org.hravemzdy.procezor.interfaces.ITermResult;
import org.hravemzdy.procezor.interfaces.ITermResultError;
import org.hravemzdy.procezor.interfaces.ITermTarget;
import org.hravemzdy.procezor.registry.ITermCalcul;
import org.hravemzdy.procezor.service.errors.TermResultError;
import org.hravemzdy.procezor.service.types.TermSymbol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u00012\u00020\u0002B\u0081\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012h\u0010\u0007\u001ad\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u001e\u0012\u001c\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u0002`\u000f0\u000bj\u0002`\u0010\u0012\u001e\u0012\u001c\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u0002`\u000f0\u000bj\u0002`\u0010\u0018\u00010\bj\u0004\u0018\u0001`\u0011\u00a2\u0006\u0002\u0010\u0012JT\u0010\u0019\u001a\u001c\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u0002`\u000f0\u000bj\u0002`\u00102\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\n2 \u0010\u001c\u001a\u001c\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u0002`\u000f0\u000bj\u0002`\u0010H\u0016Rv\u0010\u0007\u001ad\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u001e\u0012\u001c\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u0002`\u000f0\u000bj\u0002`\u0010\u0012\u001e\u0012\u001c\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u0002`\u000f0\u000bj\u0002`\u0010\u0018\u00010\bj\u0004\u0018\u0001`\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001d"}, d2={"Lorg/hravemzdy/procezor/registry/TermCalcul;", "Lorg/hravemzdy/procezor/service/types/TermSymbol;", "Lorg/hravemzdy/procezor/registry/ITermCalcul;", "target", "Lorg/hravemzdy/procezor/interfaces/ITermTarget;", "spec", "Lorg/hravemzdy/procezor/interfaces/IArticleSpec;", "resultDelegate", "Lkotlin/Function5;", "Lorg/hravemzdy/legalios/interfaces/IPeriod;", "Lorg/hravemzdy/legalios/interfaces/IBundleProps;", "", "Lcom/github/michaelbull/result/Result;", "Lorg/hravemzdy/procezor/interfaces/ITermResult;", "Lorg/hravemzdy/procezor/interfaces/ITermResultError;", "Lorg/hravemzdy/procezor/service/types/BuilderResult;", "Lorg/hravemzdy/procezor/service/types/BuilderResultList;", "Lorg/hravemzdy/procezor/interfaces/ResultFunc;", "(Lorg/hravemzdy/procezor/interfaces/ITermTarget;Lorg/hravemzdy/procezor/interfaces/IArticleSpec;Lkotlin/jvm/functions/Function5;)V", "getResultDelegate", "()Lkotlin/jvm/functions/Function5;", "getSpec", "()Lorg/hravemzdy/procezor/interfaces/IArticleSpec;", "getTarget", "()Lorg/hravemzdy/procezor/interfaces/ITermTarget;", "getResults", "period", "ruleset", "results", "lib"})
public final class TermCalcul
extends TermSymbol
implements ITermCalcul {
    @NotNull
    private final ITermTarget target;
    @Nullable
    private final IArticleSpec spec;
    @Nullable
    private final Function5<ITermTarget, IArticleSpec, IPeriod, IBundleProps, Iterable<? extends Result<? extends ITermResult, ? extends ITermResultError>>, Iterable<Result<ITermResult, ITermResultError>>> resultDelegate;

    public TermCalcul(@NotNull ITermTarget target, @Nullable IArticleSpec spec, @Nullable Function5<? super ITermTarget, ? super IArticleSpec, ? super IPeriod, ? super IBundleProps, ? super Iterable<? extends Result<? extends ITermResult, ? extends ITermResultError>>, ? extends Iterable<? extends Result<? extends ITermResult, ? extends ITermResultError>>> resultDelegate) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        super(target.getMonthCode(), target.getContract(), target.getPosition(), target.getVariant(), target.getArticle());
        this.target = target;
        this.spec = spec;
        this.resultDelegate = resultDelegate;
    }

    @Override
    @NotNull
    public ITermTarget getTarget() {
        return this.target;
    }

    @Override
    @Nullable
    public IArticleSpec getSpec() {
        return this.spec;
    }

    @Override
    @Nullable
    public Function5<ITermTarget, IArticleSpec, IPeriod, IBundleProps, Iterable<? extends Result<? extends ITermResult, ? extends ITermResultError>>, Iterable<Result<ITermResult, ITermResultError>>> getResultDelegate() {
        return this.resultDelegate;
    }

    @Override
    @NotNull
    public Iterable<Result<ITermResult, ITermResultError>> getResults(@NotNull IPeriod period, @NotNull IBundleProps ruleset, @NotNull Iterable<? extends Result<? extends ITermResult, ? extends ITermResultError>> results) {
        Intrinsics.checkNotNullParameter((Object)period, (String)"period");
        Intrinsics.checkNotNullParameter((Object)ruleset, (String)"ruleset");
        Intrinsics.checkNotNullParameter(results, (String)"results");
        if (this.getResultDelegate() == null) {
            TermResultError.NoResultFuncError resultError = new TermResultError.NoResultFuncError(period, this.getTarget());
            return CollectionsKt.listOf((Object)new Err((Object)resultError));
        }
        Function5<ITermTarget, IArticleSpec, IPeriod, IBundleProps, Iterable<? extends Result<? extends ITermResult, ? extends ITermResultError>>, Iterable<Result<ITermResult, ITermResultError>>> function5 = this.getResultDelegate();
        Intrinsics.checkNotNull(function5);
        Iterable resultTarget = (Iterable)function5.invoke((Object)this.getTarget(), (Object)this.getSpec(), (Object)period, (Object)ruleset, results);
        return CollectionsKt.toList((Iterable)resultTarget);
    }
}

