/*
 * Decompiled with CFR 0.152.
 */
package org.hravemzdy.procezor.service.types;

import java.time.LocalDate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.hravemzdy.procezor.interfaces.IContractTerm;
import org.hravemzdy.procezor.registry.constants.TermConstants;
import org.hravemzdy.procezor.service.types.ContractCode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\t\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lorg/hravemzdy/procezor/service/types/ContractTerm;", "Lorg/hravemzdy/procezor/interfaces/IContractTerm;", "contract", "Lorg/hravemzdy/procezor/service/types/ContractCode;", "dateFrom", "Ljava/time/LocalDate;", "dateStop", "termDayFrom", "", "termDayStop", "(Lorg/hravemzdy/procezor/service/types/ContractCode;Ljava/time/LocalDate;Ljava/time/LocalDate;BB)V", "getContract", "()Lorg/hravemzdy/procezor/service/types/ContractCode;", "getDateFrom", "()Ljava/time/LocalDate;", "getDateStop", "getTermDayFrom", "()B", "getTermDayStop", "isActive", "", "lib"})
public final class ContractTerm
implements IContractTerm {
    @NotNull
    private final ContractCode contract;
    @Nullable
    private final LocalDate dateFrom;
    @Nullable
    private final LocalDate dateStop;
    private final byte termDayFrom;
    private final byte termDayStop;

    public ContractTerm(@NotNull ContractCode contract, @Nullable LocalDate dateFrom, @Nullable LocalDate dateStop, byte termDayFrom, byte termDayStop) {
        Intrinsics.checkNotNullParameter((Object)contract, (String)"contract");
        this.contract = contract;
        this.dateFrom = dateFrom;
        this.dateStop = dateStop;
        this.termDayFrom = termDayFrom;
        this.termDayStop = termDayStop;
    }

    @Override
    @NotNull
    public ContractCode getContract() {
        return this.contract;
    }

    @Override
    @Nullable
    public LocalDate getDateFrom() {
        return this.dateFrom;
    }

    @Override
    @Nullable
    public LocalDate getDateStop() {
        return this.dateStop;
    }

    @Override
    public byte getTermDayFrom() {
        return this.termDayFrom;
    }

    @Override
    public byte getTermDayStop() {
        return this.termDayStop;
    }

    @Override
    public boolean isActive() {
        return this.getTermDayFrom() < TermConstants.Companion.getTERM_BEG_FINISHED() && this.getTermDayStop() > TermConstants.Companion.getTERM_END_FINISHED();
    }
}

