/*
 * Decompiled with CFR 0.152.
 */
package org.hravemzdy.procezor.service;

import com.github.michaelbull.result.Result;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.hravemzdy.legalios.interfaces.IBundleProps;
import org.hravemzdy.legalios.interfaces.IPeriod;
import org.hravemzdy.procezor.interfaces.IArticleDefine;
import org.hravemzdy.procezor.interfaces.IArticleSpec;
import org.hravemzdy.procezor.interfaces.IConceptSpec;
import org.hravemzdy.procezor.interfaces.ISpecCode;
import org.hravemzdy.procezor.interfaces.ITermResult;
import org.hravemzdy.procezor.interfaces.ITermResultError;
import org.hravemzdy.procezor.interfaces.ITermTarget;
import org.hravemzdy.procezor.registry.IResultBuilder;
import org.hravemzdy.procezor.registry.ResultBuilder;
import org.hravemzdy.procezor.registry.factories.IArticleSpecFactory;
import org.hravemzdy.procezor.registry.factories.IConceptSpecFactory;
import org.hravemzdy.procezor.service.IServiceProcezor;
import org.hravemzdy.procezor.service.types.ArticleCode;
import org.hravemzdy.procezor.service.types.ArticleTerm;
import org.hravemzdy.procezor.service.types.ConceptCode;
import org.hravemzdy.procezor.service.types.ContractTerm;
import org.hravemzdy.procezor.service.types.PositionTerm;
import org.hravemzdy.procezor.service.types.VersionCode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u001d\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u001c\u001a\u00020\u001dH&J\b\u0010\u001e\u001a\u00020\u001dH&J\b\u0010\u001f\u001a\u00020\u001dH\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u0005H\u0016J\u001a\u0010\"\u001a\u0014\u0012\u0004\u0012\u00020!\u0012\n\u0012\b\u0012\u0004\u0012\u00020$0\u00050#H\u0016J\"\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\"\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010'\u001a\u00020,2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J(\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u00052\u0006\u0010(\u001a\u00020)2\u0010\u0010/\u001a\f\u0012\u0004\u0012\u0002000\u0005j\u0002`1H\u0016J6\u00102\u001a\b\u0012\u0004\u0012\u0002030\u00052\u0006\u0010(\u001a\u00020)2\f\u00104\u001a\b\u0012\u0004\u0012\u00020.0\u00052\u0010\u0010/\u001a\f\u0012\u0004\u0012\u0002000\u0005j\u0002`1H\u0016JD\u00105\u001a\u001c\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020806j\u0002`90\u0005j\u0002`:2\u0006\u0010(\u001a\u00020)2\u0006\u0010;\u001a\u00020<2\u0010\u0010/\u001a\f\u0012\u0004\u0012\u0002000\u0005j\u0002`1H\u0016J\u0010\u0010=\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020)H\u0016R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006>"}, d2={"Lorg/hravemzdy/procezor/service/ServiceProcezor;", "Lorg/hravemzdy/procezor/service/IServiceProcezor;", "_version", "Lorg/hravemzdy/procezor/service/types/VersionCode;", "_calcArticles", "", "Lorg/hravemzdy/procezor/service/types/ArticleCode;", "(Lorg/hravemzdy/procezor/service/types/VersionCode;Ljava/lang/Iterable;)V", "articleFactory", "Lorg/hravemzdy/procezor/registry/factories/IArticleSpecFactory;", "getArticleFactory", "()Lorg/hravemzdy/procezor/registry/factories/IArticleSpecFactory;", "setArticleFactory", "(Lorg/hravemzdy/procezor/registry/factories/IArticleSpecFactory;)V", "builder", "Lorg/hravemzdy/procezor/registry/IResultBuilder;", "calcArticles", "getCalcArticles", "()Ljava/lang/Iterable;", "conceptFactory", "Lorg/hravemzdy/procezor/registry/factories/IConceptSpecFactory;", "getConceptFactory", "()Lorg/hravemzdy/procezor/registry/factories/IConceptSpecFactory;", "setConceptFactory", "(Lorg/hravemzdy/procezor/registry/factories/IConceptSpecFactory;)V", "version", "getVersion", "()Lorg/hravemzdy/procezor/service/types/VersionCode;", "buildArticleFactory", "", "buildConceptFactory", "buildFactories", "builderOrder", "Lorg/hravemzdy/procezor/service/types/ArticleTerm;", "builderPaths", "", "Lorg/hravemzdy/procezor/interfaces/IArticleDefine;", "getArticleSpec", "Lorg/hravemzdy/procezor/interfaces/IArticleSpec;", "code", "period", "Lorg/hravemzdy/legalios/interfaces/IPeriod;", "getConceptSpec", "Lorg/hravemzdy/procezor/interfaces/IConceptSpec;", "Lorg/hravemzdy/procezor/service/types/ConceptCode;", "getContractTerms", "Lorg/hravemzdy/procezor/service/types/ContractTerm;", "targets", "Lorg/hravemzdy/procezor/interfaces/ITermTarget;", "Lorg/hravemzdy/procezor/interfaces/ITermTargetList;", "getPositionTerms", "Lorg/hravemzdy/procezor/service/types/PositionTerm;", "contracts", "getResults", "Lcom/github/michaelbull/result/Result;", "Lorg/hravemzdy/procezor/interfaces/ITermResult;", "Lorg/hravemzdy/procezor/interfaces/ITermResultError;", "Lorg/hravemzdy/procezor/service/types/BuilderResult;", "Lorg/hravemzdy/procezor/service/types/BuilderResultList;", "ruleset", "Lorg/hravemzdy/legalios/interfaces/IBundleProps;", "initWithPeriod", "lib"})
public abstract class ServiceProcezor
implements IServiceProcezor {
    @NotNull
    private final VersionCode version;
    @NotNull
    private final Iterable<ArticleCode> calcArticles;
    @NotNull
    private final IResultBuilder builder;
    @Nullable
    private IArticleSpecFactory articleFactory;
    @Nullable
    private IConceptSpecFactory conceptFactory;

    @Override
    @NotNull
    public final VersionCode getVersion() {
        return this.version;
    }

    @Override
    @NotNull
    public final Iterable<ArticleCode> getCalcArticles() {
        return this.calcArticles;
    }

    @Nullable
    protected final IArticleSpecFactory getArticleFactory() {
        return this.articleFactory;
    }

    protected final void setArticleFactory(@Nullable IArticleSpecFactory iArticleSpecFactory) {
        this.articleFactory = iArticleSpecFactory;
    }

    @Nullable
    protected final IConceptSpecFactory getConceptFactory() {
        return this.conceptFactory;
    }

    protected final void setConceptFactory(@Nullable IConceptSpecFactory iConceptSpecFactory) {
        this.conceptFactory = iConceptSpecFactory;
    }

    public ServiceProcezor(@NotNull VersionCode _version, @NotNull Iterable<ArticleCode> _calcArticles) {
        Intrinsics.checkNotNullParameter((Object)_version, (String)"_version");
        Intrinsics.checkNotNullParameter(_calcArticles, (String)"_calcArticles");
        this.builder = new ResultBuilder();
        this.version = _version;
        this.calcArticles = CollectionsKt.toList(_calcArticles);
    }

    @Override
    @NotNull
    public Iterable<ArticleTerm> builderOrder() {
        return this.builder.getArticleOrder();
    }

    @Override
    @NotNull
    public Map<ArticleTerm, Iterable<IArticleDefine>> builderPaths() {
        return this.builder.getArticlePaths();
    }

    @Override
    @NotNull
    public Iterable<ContractTerm> getContractTerms(@NotNull IPeriod period, @NotNull Iterable<? extends ITermTarget> targets) {
        Intrinsics.checkNotNullParameter((Object)period, (String)"period");
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public Iterable<PositionTerm> getPositionTerms(@NotNull IPeriod period, @NotNull Iterable<ContractTerm> contracts, @NotNull Iterable<? extends ITermTarget> targets) {
        Intrinsics.checkNotNullParameter((Object)period, (String)"period");
        Intrinsics.checkNotNullParameter(contracts, (String)"contracts");
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public Iterable<Result<ITermResult, ITermResultError>> getResults(@NotNull IPeriod period, @NotNull IBundleProps ruleset, @NotNull Iterable<? extends ITermTarget> targets) {
        Intrinsics.checkNotNullParameter((Object)period, (String)"period");
        Intrinsics.checkNotNullParameter((Object)ruleset, (String)"ruleset");
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        Iterable<Result<ITermResult, ITermResultError>> results = CollectionsKt.emptyList();
        boolean success = this.initWithPeriod(period);
        if (!success) {
            return results;
        }
        Iterable<ContractTerm> contractTerms = this.getContractTerms(period, targets);
        Iterable<PositionTerm> positionTerms = this.getPositionTerms(period, contractTerms, targets);
        if (this.builder != null) {
            results = this.builder.getResults(ruleset, contractTerms, positionTerms, targets, this.calcArticles);
        }
        return results;
    }

    @Override
    public boolean initWithPeriod(@NotNull IPeriod period) {
        Intrinsics.checkNotNullParameter((Object)period, (String)"period");
        boolean initResult = false;
        if (this.builder != null) {
            initResult = true;
        }
        boolean initBuilder = false;
        if (this.builder != null) {
            boolean bl = initBuilder = !Intrinsics.areEqual((Object)this.builder.getPeriodInit(), (Object)period);
        }
        if (initBuilder && this.articleFactory != null && this.conceptFactory != null) {
            IArticleSpecFactory iArticleSpecFactory = this.articleFactory;
            Intrinsics.checkNotNull((Object)iArticleSpecFactory);
            IConceptSpecFactory iConceptSpecFactory = this.conceptFactory;
            Intrinsics.checkNotNull((Object)iConceptSpecFactory);
            initResult = this.builder.initWithPeriod(this.version, period, iArticleSpecFactory, iConceptSpecFactory);
        }
        if (!initResult) {
            String string = "Period: " + period.getCode() + ", init with period failed";
            boolean bl = false;
            System.out.println((Object)string);
        }
        return initResult;
    }

    @Override
    public boolean buildFactories() {
        boolean articleFactorySuccess = this.buildArticleFactory();
        boolean conceptFactorySuccess = this.buildConceptFactory();
        if (!articleFactorySuccess || !conceptFactorySuccess) {
            String string = "ServiceProcezor::BuildFactories(): Version: " + this.version + ", build factories failed";
            boolean bl = false;
            System.out.println((Object)string);
        }
        return articleFactorySuccess && conceptFactorySuccess;
    }

    @Override
    @Nullable
    public IArticleSpec getArticleSpec(@NotNull ArticleCode code, @NotNull IPeriod period, @NotNull VersionCode version) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)period, (String)"period");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        if (this.articleFactory == null) {
            return null;
        }
        IArticleSpecFactory iArticleSpecFactory = this.articleFactory;
        Intrinsics.checkNotNull((Object)iArticleSpecFactory);
        return (IArticleSpec)iArticleSpecFactory.getSpec((ISpecCode)code, period, version);
    }

    @Override
    @Nullable
    public IConceptSpec getConceptSpec(@NotNull ConceptCode code, @NotNull IPeriod period, @NotNull VersionCode version) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)period, (String)"period");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        if (this.conceptFactory == null) {
            return null;
        }
        IConceptSpecFactory iConceptSpecFactory = this.conceptFactory;
        Intrinsics.checkNotNull((Object)iConceptSpecFactory);
        return (IConceptSpec)iConceptSpecFactory.getSpec((ISpecCode)code, period, version);
    }

    public abstract boolean buildArticleFactory();

    public abstract boolean buildConceptFactory();
}

