/*
 * Decompiled with CFR 0.152.
 */
package org.hravemzdy.procezor.service.errors;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.hravemzdy.legalios.interfaces.IPeriod;
import org.hravemzdy.procezor.interfaces.ICodeValue;
import org.hravemzdy.procezor.interfaces.ITermResultError;
import org.hravemzdy.procezor.interfaces.ITermTarget;
import org.hravemzdy.procezor.service.types.ArticleCode;
import org.hravemzdy.procezor.service.types.ConceptCode;
import org.hravemzdy.procezor.service.types.ContractCode;
import org.hravemzdy.procezor.service.types.PositionCode;
import org.hravemzdy.procezor.service.types.VariantCode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000  2\u00020\u0001:\n !\"#$%&'()B!\b\u0014\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u001d\u001a\u00020\u0007H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u001e\u001a\u00020\u0007H\u0016J\b\u0010\u001f\u001a\u00020\u0007H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u0082\u0001\t*+,-./012\u00a8\u00063"}, d2={"Lorg/hravemzdy/procezor/service/errors/TermResultError;", "Lorg/hravemzdy/procezor/interfaces/ITermResultError;", "period", "Lorg/hravemzdy/legalios/interfaces/IPeriod;", "target", "Lorg/hravemzdy/procezor/interfaces/ITermTarget;", "message", "", "(Lorg/hravemzdy/legalios/interfaces/IPeriod;Lorg/hravemzdy/procezor/interfaces/ITermTarget;Ljava/lang/String;)V", "article", "Lorg/hravemzdy/procezor/service/types/ArticleCode;", "getArticle", "()Lorg/hravemzdy/procezor/service/types/ArticleCode;", "concept", "Lorg/hravemzdy/procezor/service/types/ConceptCode;", "getConcept", "()Lorg/hravemzdy/procezor/service/types/ConceptCode;", "contract", "Lorg/hravemzdy/procezor/service/types/ContractCode;", "getContract", "()Lorg/hravemzdy/procezor/service/types/ContractCode;", "position", "Lorg/hravemzdy/procezor/service/types/PositionCode;", "getPosition", "()Lorg/hravemzdy/procezor/service/types/PositionCode;", "variant", "Lorg/hravemzdy/procezor/service/types/VariantCode;", "getVariant", "()Lorg/hravemzdy/procezor/service/types/VariantCode;", "articleDescr", "conceptDescr", "description", "Companion", "EvalResultError", "ExtractResultError", "InvalidResultError", "InvalidRulesetError", "InvalidTargetError", "NoImplementationError", "NoResultFoundError", "NoResultFuncError", "NullResultFoundError", "Lorg/hravemzdy/procezor/service/errors/TermResultError$EvalResultError;", "Lorg/hravemzdy/procezor/service/errors/TermResultError$ExtractResultError;", "Lorg/hravemzdy/procezor/service/errors/TermResultError$NoImplementationError;", "Lorg/hravemzdy/procezor/service/errors/TermResultError$NoResultFuncError;", "Lorg/hravemzdy/procezor/service/errors/TermResultError$InvalidResultError;", "Lorg/hravemzdy/procezor/service/errors/TermResultError$InvalidRulesetError;", "Lorg/hravemzdy/procezor/service/errors/TermResultError$InvalidTargetError;", "Lorg/hravemzdy/procezor/service/errors/TermResultError$NoResultFoundError;", "Lorg/hravemzdy/procezor/service/errors/TermResultError$NullResultFoundError;", "lib"})
public abstract class TermResultError
implements ITermResultError {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IPeriod period;
    @Nullable
    private final ITermTarget target;
    @NotNull
    private final String message;
    @NotNull
    private final ContractCode contract;
    @NotNull
    private final PositionCode position;
    @NotNull
    private final ArticleCode article;
    @NotNull
    private final ConceptCode concept;
    @NotNull
    private final VariantCode variant;

    @Override
    @NotNull
    public ContractCode getContract() {
        return this.contract;
    }

    @Override
    @NotNull
    public PositionCode getPosition() {
        return this.position;
    }

    @Override
    @NotNull
    public ArticleCode getArticle() {
        return this.article;
    }

    @Override
    @NotNull
    public ConceptCode getConcept() {
        return this.concept;
    }

    @Override
    @NotNull
    public VariantCode getVariant() {
        return this.variant;
    }

    private TermResultError(IPeriod period, ITermTarget target, String message) {
        this.period = period;
        this.target = target;
        this.message = message;
        ITermTarget iTermTarget = target;
        ICodeValue<Integer> iCodeValue = iTermTarget == null ? null : iTermTarget.getContract();
        this.contract = iCodeValue == null ? ContractCode.Companion.new() : iCodeValue;
        iTermTarget = target;
        iCodeValue = iTermTarget == null ? null : iTermTarget.getPosition();
        this.position = iCodeValue == null ? PositionCode.Companion.new() : iCodeValue;
        iTermTarget = target;
        iCodeValue = iTermTarget == null ? null : iTermTarget.getArticle();
        this.article = iCodeValue == null ? ArticleCode.Companion.new() : iCodeValue;
        iTermTarget = target;
        iCodeValue = iTermTarget == null ? null : iTermTarget.getConcept();
        this.concept = iCodeValue == null ? ConceptCode.Companion.new() : iCodeValue;
        iTermTarget = target;
        iCodeValue = iTermTarget == null ? null : iTermTarget.getVariant();
        this.variant = iCodeValue == null ? VariantCode.Companion.new() : iCodeValue;
    }

    @Override
    @NotNull
    public String description() {
        return this.message;
    }

    @Override
    @NotNull
    public ArticleCode article() {
        ITermTarget iTermTarget = this.target;
        ArticleCode articleCode = iTermTarget == null ? null : iTermTarget.getArticle();
        return articleCode == null ? ArticleCode.Companion.new() : articleCode;
    }

    @Override
    @NotNull
    public ConceptCode concept() {
        ITermTarget iTermTarget = this.target;
        ConceptCode conceptCode = iTermTarget == null ? null : iTermTarget.getConcept();
        return conceptCode == null ? ConceptCode.Companion.new() : conceptCode;
    }

    @Override
    @NotNull
    public String articleDescr() {
        ITermTarget iTermTarget = this.target;
        String string = iTermTarget == null ? null : iTermTarget.articleDescr();
        return string == null ? Intrinsics.stringPlus((String)"ArticleCode for ", (Object)this.getArticle().getValue()) : string;
    }

    @Override
    @NotNull
    public String conceptDescr() {
        ITermTarget iTermTarget = this.target;
        String string = iTermTarget == null ? null : iTermTarget.conceptDescr();
        return string == null ? Intrinsics.stringPlus((String)"ConceptCode for ", (Object)this.getConcept().getValue()) : string;
    }

    public /* synthetic */ TermResultError(IPeriod period, ITermTarget target, String message, DefaultConstructorMarker $constructor_marker) {
        this(period, target, message);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/hravemzdy/procezor/service/errors/TermResultError$EvalResultError;", "Lorg/hravemzdy/procezor/service/errors/TermResultError;", "period", "Lorg/hravemzdy/legalios/interfaces/IPeriod;", "target", "Lorg/hravemzdy/procezor/interfaces/ITermTarget;", "(Lorg/hravemzdy/legalios/interfaces/IPeriod;Lorg/hravemzdy/procezor/interfaces/ITermTarget;)V", "lib"})
    public static final class EvalResultError
    extends TermResultError {
        public EvalResultError(@NotNull IPeriod period, @Nullable ITermTarget target) {
            Intrinsics.checkNotNullParameter((Object)period, (String)"period");
            super(period, target, "evaluation failed", null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/hravemzdy/procezor/service/errors/TermResultError$ExtractResultError;", "Lorg/hravemzdy/procezor/service/errors/TermResultError;", "period", "Lorg/hravemzdy/legalios/interfaces/IPeriod;", "target", "Lorg/hravemzdy/procezor/interfaces/ITermTarget;", "(Lorg/hravemzdy/legalios/interfaces/IPeriod;Lorg/hravemzdy/procezor/interfaces/ITermTarget;)V", "lib"})
    public static final class ExtractResultError
    extends TermResultError {
        public ExtractResultError(@NotNull IPeriod period, @Nullable ITermTarget target) {
            Intrinsics.checkNotNullParameter((Object)period, (String)"period");
            super(period, target, "extract result failed", null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/hravemzdy/procezor/service/errors/TermResultError$NoImplementationError;", "Lorg/hravemzdy/procezor/service/errors/TermResultError;", "period", "Lorg/hravemzdy/legalios/interfaces/IPeriod;", "target", "Lorg/hravemzdy/procezor/interfaces/ITermTarget;", "(Lorg/hravemzdy/legalios/interfaces/IPeriod;Lorg/hravemzdy/procezor/interfaces/ITermTarget;)V", "lib"})
    public static final class NoImplementationError
    extends TermResultError {
        public NoImplementationError(@NotNull IPeriod period, @Nullable ITermTarget target) {
            Intrinsics.checkNotNullParameter((Object)period, (String)"period");
            super(period, target, "failed with no-implementation", null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/hravemzdy/procezor/service/errors/TermResultError$NoResultFuncError;", "Lorg/hravemzdy/procezor/service/errors/TermResultError;", "period", "Lorg/hravemzdy/legalios/interfaces/IPeriod;", "target", "Lorg/hravemzdy/procezor/interfaces/ITermTarget;", "(Lorg/hravemzdy/legalios/interfaces/IPeriod;Lorg/hravemzdy/procezor/interfaces/ITermTarget;)V", "lib"})
    public static final class NoResultFuncError
    extends TermResultError {
        public NoResultFuncError(@NotNull IPeriod period, @Nullable ITermTarget target) {
            Intrinsics.checkNotNullParameter((Object)period, (String)"period");
            super(period, target, "failed with no-result function", null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/hravemzdy/procezor/service/errors/TermResultError$InvalidResultError;", "Lorg/hravemzdy/procezor/service/errors/TermResultError;", "period", "Lorg/hravemzdy/legalios/interfaces/IPeriod;", "target", "Lorg/hravemzdy/procezor/interfaces/ITermTarget;", "typeDescr", "", "(Lorg/hravemzdy/legalios/interfaces/IPeriod;Lorg/hravemzdy/procezor/interfaces/ITermTarget;Ljava/lang/String;)V", "lib"})
    public static final class InvalidResultError
    extends TermResultError {
        public InvalidResultError(@NotNull IPeriod period, @Nullable ITermTarget target, @NotNull String typeDescr) {
            Intrinsics.checkNotNullParameter((Object)period, (String)"period");
            Intrinsics.checkNotNullParameter((Object)typeDescr, (String)"typeDescr");
            super(period, target, "invalid result type " + typeDescr + " error!", null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/hravemzdy/procezor/service/errors/TermResultError$InvalidRulesetError;", "Lorg/hravemzdy/procezor/service/errors/TermResultError;", "period", "Lorg/hravemzdy/legalios/interfaces/IPeriod;", "target", "Lorg/hravemzdy/procezor/interfaces/ITermTarget;", "typeDescr", "", "(Lorg/hravemzdy/legalios/interfaces/IPeriod;Lorg/hravemzdy/procezor/interfaces/ITermTarget;Ljava/lang/String;)V", "lib"})
    public static final class InvalidRulesetError
    extends TermResultError {
        public InvalidRulesetError(@NotNull IPeriod period, @Nullable ITermTarget target, @NotNull String typeDescr) {
            Intrinsics.checkNotNullParameter((Object)period, (String)"period");
            Intrinsics.checkNotNullParameter((Object)typeDescr, (String)"typeDescr");
            super(period, target, "invalid " + typeDescr + " Ruleset error!", null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lorg/hravemzdy/procezor/service/errors/TermResultError$InvalidTargetError;", "Lorg/hravemzdy/procezor/service/errors/TermResultError;", "period", "Lorg/hravemzdy/legalios/interfaces/IPeriod;", "target", "Lorg/hravemzdy/procezor/interfaces/ITermTarget;", "typeDescr", "", "(Lorg/hravemzdy/legalios/interfaces/IPeriod;Lorg/hravemzdy/procezor/interfaces/ITermTarget;Ljava/lang/String;)V", "lib"})
    public static final class InvalidTargetError
    extends TermResultError {
        public InvalidTargetError(@NotNull IPeriod period, @Nullable ITermTarget target, @NotNull String typeDescr) {
            Intrinsics.checkNotNullParameter((Object)period, (String)"period");
            Intrinsics.checkNotNullParameter((Object)typeDescr, (String)"typeDescr");
            super(period, target, "invalid target type " + typeDescr + " error!", null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lorg/hravemzdy/procezor/service/errors/TermResultError$NoResultFoundError;", "Lorg/hravemzdy/procezor/service/errors/TermResultError;", "period", "Lorg/hravemzdy/legalios/interfaces/IPeriod;", "target", "Lorg/hravemzdy/procezor/interfaces/ITermTarget;", "articleDescr", "", "contract", "Lorg/hravemzdy/procezor/service/types/ContractCode;", "position", "Lorg/hravemzdy/procezor/service/types/PositionCode;", "(Lorg/hravemzdy/legalios/interfaces/IPeriod;Lorg/hravemzdy/procezor/interfaces/ITermTarget;Ljava/lang/String;Lorg/hravemzdy/procezor/service/types/ContractCode;Lorg/hravemzdy/procezor/service/types/PositionCode;)V", "lib"})
    public static final class NoResultFoundError
    extends TermResultError {
        public NoResultFoundError(@NotNull IPeriod period, @Nullable ITermTarget target, @NotNull String articleDescr, @Nullable ContractCode contract, @Nullable PositionCode position) {
            Intrinsics.checkNotNullParameter((Object)period, (String)"period");
            Intrinsics.checkNotNullParameter((Object)articleDescr, (String)"articleDescr");
            super(period, target, "result for " + articleDescr + Companion.messageContractPosition(contract, position) + " Not Found", null);
        }

        public /* synthetic */ NoResultFoundError(IPeriod iPeriod, ITermTarget iTermTarget, String string, ContractCode contractCode, PositionCode positionCode, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                contractCode = null;
            }
            if ((n & 0x10) != 0) {
                positionCode = null;
            }
            this(iPeriod, iTermTarget, string, contractCode, positionCode);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lorg/hravemzdy/procezor/service/errors/TermResultError$NullResultFoundError;", "Lorg/hravemzdy/procezor/service/errors/TermResultError;", "period", "Lorg/hravemzdy/legalios/interfaces/IPeriod;", "target", "Lorg/hravemzdy/procezor/interfaces/ITermTarget;", "articleDescr", "", "contract", "Lorg/hravemzdy/procezor/service/types/ContractCode;", "position", "Lorg/hravemzdy/procezor/service/types/PositionCode;", "(Lorg/hravemzdy/legalios/interfaces/IPeriod;Lorg/hravemzdy/procezor/interfaces/ITermTarget;Ljava/lang/String;Lorg/hravemzdy/procezor/service/types/ContractCode;Lorg/hravemzdy/procezor/service/types/PositionCode;)V", "lib"})
    public static final class NullResultFoundError
    extends TermResultError {
        public NullResultFoundError(@NotNull IPeriod period, @Nullable ITermTarget target, @NotNull String articleDescr, @Nullable ContractCode contract, @Nullable PositionCode position) {
            Intrinsics.checkNotNullParameter((Object)period, (String)"period");
            Intrinsics.checkNotNullParameter((Object)articleDescr, (String)"articleDescr");
            super(period, target, "result found for " + articleDescr + Companion.messageContractPosition(contract, position) + " but Instance is Null!", null);
        }

        public /* synthetic */ NullResultFoundError(IPeriod iPeriod, ITermTarget iTermTarget, String string, ContractCode contractCode, PositionCode positionCode, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                contractCode = null;
            }
            if ((n & 0x10) != 0) {
                positionCode = null;
            }
            this(iPeriod, iTermTarget, string, contractCode, positionCode);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a8\u0006\t"}, d2={"Lorg/hravemzdy/procezor/service/errors/TermResultError$Companion;", "", "()V", "messageContractPosition", "", "contract", "Lorg/hravemzdy/procezor/service/types/ContractCode;", "position", "Lorg/hravemzdy/procezor/service/types/PositionCode;", "lib"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String messageContractPosition(@Nullable ContractCode contract, @Nullable PositionCode position) {
            return contract != null && position != null ? ", contract=" + contract.getValue() + ", position=" + position.getValue() : (contract != null ? Intrinsics.stringPlus((String)", contract=", (Object)contract.getValue()) : "");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

