/*
 * Decompiled with CFR 0.152.
 */
package org.hravemzdy.procezor.service.types;

import java.time.LocalDate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.hravemzdy.procezor.interfaces.IContractTerm;
import org.hravemzdy.procezor.interfaces.IPositionTerm;
import org.hravemzdy.procezor.registry.constants.TermConstants;
import org.hravemzdy.procezor.service.types.ContractCode;
import org.hravemzdy.procezor.service.types.PositionCode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0002R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\n\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\r\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019\u00a8\u0006\u001e"}, d2={"Lorg/hravemzdy/procezor/service/types/PositionTerm;", "Lorg/hravemzdy/procezor/interfaces/IPositionTerm;", "position", "Lorg/hravemzdy/procezor/service/types/PositionCode;", "contract", "Lorg/hravemzdy/procezor/service/types/ContractCode;", "baseTerm", "Lorg/hravemzdy/procezor/interfaces/IContractTerm;", "dateFrom", "Ljava/time/LocalDate;", "dateStop", "termDayFrom", "", "termDayStop", "(Lorg/hravemzdy/procezor/service/types/PositionCode;Lorg/hravemzdy/procezor/service/types/ContractCode;Lorg/hravemzdy/procezor/interfaces/IContractTerm;Ljava/time/LocalDate;Ljava/time/LocalDate;BB)V", "getBaseTerm", "()Lorg/hravemzdy/procezor/interfaces/IContractTerm;", "getContract", "()Lorg/hravemzdy/procezor/service/types/ContractCode;", "getDateFrom", "()Ljava/time/LocalDate;", "getDateStop", "getPosition", "()Lorg/hravemzdy/procezor/service/types/PositionCode;", "getTermDayFrom", "()B", "getTermDayStop", "isActive", "", "isPositionActive", "lib"})
public final class PositionTerm
implements IPositionTerm {
    @NotNull
    private final PositionCode position;
    @NotNull
    private final ContractCode contract;
    @Nullable
    private final IContractTerm baseTerm;
    @Nullable
    private final LocalDate dateFrom;
    @Nullable
    private final LocalDate dateStop;
    private final byte termDayFrom;
    private final byte termDayStop;

    public PositionTerm(@NotNull PositionCode position, @NotNull ContractCode contract, @Nullable IContractTerm baseTerm, @Nullable LocalDate dateFrom, @Nullable LocalDate dateStop, byte termDayFrom, byte termDayStop) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)contract, (String)"contract");
        this.position = position;
        this.contract = contract;
        this.baseTerm = baseTerm;
        this.dateFrom = dateFrom;
        this.dateStop = dateStop;
        this.termDayFrom = termDayFrom;
        this.termDayStop = termDayStop;
    }

    @Override
    @NotNull
    public PositionCode getPosition() {
        return this.position;
    }

    @Override
    @NotNull
    public ContractCode getContract() {
        return this.contract;
    }

    @Override
    @Nullable
    public IContractTerm getBaseTerm() {
        return this.baseTerm;
    }

    @Override
    @Nullable
    public LocalDate getDateFrom() {
        return this.dateFrom;
    }

    @Override
    @Nullable
    public LocalDate getDateStop() {
        return this.dateStop;
    }

    @Override
    public byte getTermDayFrom() {
        return this.termDayFrom;
    }

    @Override
    public byte getTermDayStop() {
        return this.termDayStop;
    }

    private final boolean isPositionActive() {
        return this.getTermDayFrom() < TermConstants.Companion.getTERM_BEG_FINISHED() && this.getTermDayStop() > TermConstants.Companion.getTERM_END_FINISHED();
    }

    @Override
    public boolean isActive() {
        if (this.getBaseTerm() != null) {
            return this.getBaseTerm().isActive() && this.isPositionActive();
        }
        return this.isPositionActive();
    }
}

