/*
 * Decompiled with CFR 0.152.
 */
package org.hravemzdy.procezor.registry;

import java.io.Serializable;
import org.hravemzdy.procezor.interfaces.IArticleDefine;
import org.hravemzdy.procezor.interfaces.IArticleSpec;
import org.hravemzdy.procezor.interfaces.IConceptSpec;
import org.hravemzdy.procezor.registry.ArticleEdge;
import org.hravemzdy.procezor.service.types.ArticleCode;
import org.hravemzdy.procezor.service.types.ArticleDefine;
import org.hravemzdy.procezor.service.types.ArticleTerm;
import org.hravemzdy.procezor.service.types.ArticleTerm$;
import org.hravemzdy.procezor.service.types.ConceptCode;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.MapOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt;

public final class DependencyGraph$ {
    public static final DependencyGraph$ MODULE$ = new DependencyGraph$();

    public Function2<IArticleDefine, IArticleDefine, Object> DefineComparator(ArticleTerm[] topoOrders) {
        ArticleCode[] codeOrders = (ArticleCode[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])topoOrders), (Function1 & Serializable)t -> t.code(), ClassTag$.MODULE$.apply(ArticleCode.class));
        return (Function2 & Serializable)(x, y) -> BoxesRunTime.boxToBoolean((boolean)DependencyGraph$.$anonfun$DefineComparator$2(codeOrders, x, y));
    }

    private ArticleTerm getArticleTerm(ArticleCode article, IArticleSpec[] articlesModel) {
        ArticleTerm articleTerm;
        Option option = ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])articlesModel), (Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)DependencyGraph$.$anonfun$getArticleTerm$1(article, m)));
        if (option instanceof Some) {
            Some some = (Some)option;
            IArticleSpec spec = (IArticleSpec)some.value();
            articleTerm = spec.term();
        } else if (None$.MODULE$.equals(option)) {
            articleTerm = ArticleTerm$.MODULE$.zero();
        } else {
            throw new MatchError((Object)option);
        }
        return articleTerm;
    }

    private IArticleDefine getArticleDefs(ArticleCode article, IArticleSpec[] articlesModel) {
        IArticleDefine iArticleDefine;
        Option option = ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])articlesModel), (Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)DependencyGraph$.$anonfun$getArticleDefs$1(article, m)));
        if (option instanceof Some) {
            Some some = (Some)option;
            IArticleSpec spec = (IArticleSpec)some.value();
            iArticleDefine = spec.defs();
        } else if (None$.MODULE$.equals(option)) {
            iArticleDefine = new ArticleDefine();
        } else {
            throw new MatchError((Object)option);
        }
        return iArticleDefine;
    }

    public Tuple2<ArticleTerm[], Map<ArticleTerm, IArticleDefine[]>> initGraphModel(IArticleSpec[] articlesModel, IConceptSpec[] conceptsModel) {
        ArticleTerm[] vertModel = this.createVertModel(articlesModel);
        ArticleEdge[] edgeModel = this.createEdgeModel(articlesModel, conceptsModel);
        ArticleEdge[] pendModel = this.createPendModel(articlesModel, conceptsModel);
        ArticleTerm[] order = this.createTopoModel(vertModel, edgeModel);
        Map<ArticleTerm, IArticleDefine[]> paths = this.createPathModel(articlesModel, vertModel, pendModel, order);
        return new Tuple2((Object)order, paths);
    }

    private ArticleTerm[] createVertModel(IArticleSpec[] articlesModel) {
        return (ArticleTerm[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])articlesModel), (Function1 & Serializable)a -> a.term(), ClassTag$.MODULE$.apply(ArticleTerm.class))), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
    }

    private ArticleEdge[] createEdgeModel(IArticleSpec[] articlesModel, IConceptSpec[] conceptsModel) {
        ArticleEdge[] init = (ArticleEdge[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ArticleEdge.class));
        return (ArticleEdge[])ArrayOps$.MODULE$.sortWith$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])articlesModel), (Object)init, (Function2 & Serializable)(agr, x) -> MODULE$.mergeEdges(articlesModel, conceptsModel, (ArticleEdge[])agr, (IArticleSpec)x))), (Function2 & Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)DependencyGraph$.$anonfun$createEdgeModel$2(a, b)));
    }

    private ArticleEdge[] createPendModel(IArticleSpec[] articlesModel, IConceptSpec[] conceptsModel) {
        ArticleEdge[] init = (ArticleEdge[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ArticleEdge.class));
        return (ArticleEdge[])ArrayOps$.MODULE$.sortWith$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])articlesModel), (Object)init, (Function2 & Serializable)(agr, x) -> MODULE$.mergePends(articlesModel, conceptsModel, (ArticleEdge[])agr, (IArticleSpec)x))), (Function2 & Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)DependencyGraph$.$anonfun$createPendModel$2(a, b)));
    }

    private Map<ArticleTerm, IArticleDefine[]> createPathModel(IArticleSpec[] articlesModel, ArticleTerm[] vertModel, ArticleEdge[] edgeModel, ArticleTerm[] vertOrder) {
        Tuple2[] mapPairs = (Tuple2[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])vertModel), (Function1 & Serializable)x -> new Tuple2(x, (Object)MODULE$.mergePaths(articlesModel, edgeModel, vertOrder, (ArticleTerm)x)), ClassTag$.MODULE$.apply(Tuple2.class));
        return Predef$.MODULE$.wrapRefArray((Object[])mapPairs).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private ArticleEdge[] mergeEdges(IArticleSpec[] articlesModel, IConceptSpec[] conceptsModel, ArticleEdge[] agr, IArticleSpec article) {
        Set result;
        block0: {
            result = Predef$.MODULE$.wrapRefArray((Object[])agr).toSet();
            Option concept = ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])conceptsModel), (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)DependencyGraph$.$anonfun$mergeEdges$1(article, c)));
            if (!concept.isDefined()) break block0;
            result = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])article.sums()), (Function1 & Serializable)s -> new ArticleEdge(article.term(), MODULE$.getArticleTerm((ArticleCode)s, articlesModel)), ClassTag$.MODULE$.apply(ArticleEdge.class))), (IterableOnce)result, ClassTag$.MODULE$.apply(ArticleEdge.class))).toSet();
            result = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])((IConceptSpec)concept.get()).path()), (Function1 & Serializable)p -> new ArticleEdge(MODULE$.getArticleTerm((ArticleCode)p, articlesModel), article.term()), ClassTag$.MODULE$.apply(ArticleEdge.class))), (IterableOnce)result, ClassTag$.MODULE$.apply(ArticleEdge.class))).toSet();
        }
        return (ArticleEdge[])result.toArray(ClassTag$.MODULE$.apply(ArticleEdge.class));
    }

    private ArticleEdge[] mergePends(IArticleSpec[] articlesModel, IConceptSpec[] conceptsModel, ArticleEdge[] agr, IArticleSpec article) {
        Set result;
        block0: {
            result = Predef$.MODULE$.wrapRefArray((Object[])agr).toSet();
            Option concept = ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])conceptsModel), (Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)DependencyGraph$.$anonfun$mergePends$1(article, c)));
            if (!concept.isDefined()) break block0;
            result = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])((IConceptSpec)concept.get()).path()), (Function1 & Serializable)p -> new ArticleEdge(MODULE$.getArticleTerm((ArticleCode)p, articlesModel), article.term()), ClassTag$.MODULE$.apply(ArticleEdge.class))), (IterableOnce)result, ClassTag$.MODULE$.apply(ArticleEdge.class))).toSet();
        }
        return (ArticleEdge[])result.toArray(ClassTag$.MODULE$.apply(ArticleEdge.class));
    }

    private IArticleDefine[] mergePaths(IArticleSpec[] articlesModel, ArticleEdge[] edgeModel, ArticleTerm[] vertOrder, ArticleTerm article) {
        IArticleDefine[] articleInit = (IArticleDefine[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])edgeModel), (Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)DependencyGraph$.$anonfun$mergePaths$1(article, e)))), (Function1 & Serializable)e -> MODULE$.getArticleDefs(e.start().code(), articlesModel), ClassTag$.MODULE$.apply(IArticleDefine.class));
        IArticleDefine[] articlePath = (IArticleDefine[])ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])articleInit), (Object)articleInit, (Function2 & Serializable)(agr, x) -> MODULE$.mergeVert(articlesModel, edgeModel, (IArticleDefine[])agr, (IArticleDefine)x));
        return (IArticleDefine[])ArrayOps$.MODULE$.sortWith$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.distinct$extension(Predef$.MODULE$.refArrayOps((Object[])articlePath))), this.DefineComparator((ArticleTerm[])ArrayOps$.MODULE$.toArray$extension(Predef$.MODULE$.refArrayOps((Object[])vertOrder), ClassTag$.MODULE$.apply(ArticleTerm.class))));
    }

    private IArticleDefine[] mergeVert(IArticleSpec[] articlesModel, ArticleEdge[] edgeModel, IArticleDefine[] resultVert, IArticleDefine defs) {
        IArticleDefine[] resultInit = (IArticleDefine[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])edgeModel), (Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)DependencyGraph$.$anonfun$mergeVert$1(defs, e)))), (Function1 & Serializable)e -> MODULE$.getArticleDefs(e.start().code(), articlesModel), ClassTag$.MODULE$.apply(IArticleDefine.class));
        IArticleDefine[] resultList = (IArticleDefine[])ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])resultInit), (Object)resultInit, (Function2 & Serializable)(agr, x) -> MODULE$.mergeVert(articlesModel, edgeModel, (IArticleDefine[])agr, (IArticleDefine)x));
        return (IArticleDefine[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps((Object[])resultVert), (Object)resultList, ClassTag$.MODULE$.apply(IArticleDefine.class))), (Object)defs, ClassTag$.MODULE$.apply(IArticleDefine.class));
    }

    /*
     * WARNING - void declaration
     */
    private ArticleTerm[] createTopoModel(ArticleTerm[] vertModel, ArticleEdge[] edgeModel) {
        void var3_3;
        ArticleTerm[] articlesOrder = (ArticleTerm[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ArticleTerm.class));
        ObjectRef degrees = ObjectRef.create((Object)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])vertModel), (Function1 & Serializable)x -> new Tuple2(x, (Object)BoxesRunTime.boxToInteger((int)ArrayOps$.MODULE$.count$extension(Predef$.MODULE$.refArrayOps((Object[])edgeModel), (Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)DependencyGraph$.$anonfun$createTopoModel$2(x, e))))), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        Queue queues = (Queue)Queue$.MODULE$.apply((Seq)Nil$.MODULE$);
        queues.addAll((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.sorted$extension(Predef$.MODULE$.refArrayOps((Object[])((MapOps)((Map)degrees.elem).filter((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)DependencyGraph$.$anonfun$createTopoModel$3(x)))).keys().toArray(ClassTag$.MODULE$.apply(ArticleTerm.class))), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))));
        int index = 0;
        while (queues.nonEmpty()) {
            ++index;
            ArticleTerm article = (ArticleTerm)queues.dequeue();
            articlesOrder = (ArticleTerm[])ArrayOps$.MODULE$.$colon$plus$extension(Predef$.MODULE$.refArrayOps((Object[])articlesOrder), (Object)article, ClassTag$.MODULE$.apply(ArticleTerm.class));
            ArticleTerm[] paths = (ArticleTerm[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])edgeModel), (Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)DependencyGraph$.$anonfun$createTopoModel$4(article, x)))), (Function1 & Serializable)x -> x.stops(), ClassTag$.MODULE$.apply(ArticleTerm.class));
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])paths), (Function1 & Serializable)p -> {
                degrees$1.elem = (Map)((Map)degrees$1.elem).updatedWith(p, (Function1 & Serializable)x -> {
                    None$ none$;
                    Option option = x;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        int value = BoxesRunTime.unboxToInt((Object)some.value());
                        none$ = new Some((Object)BoxesRunTime.boxToInteger((int)(value - 1)));
                    } else if (None$.MODULE$.equals(option)) {
                        none$ = None$.MODULE$;
                    } else {
                        throw new MatchError((Object)option);
                    }
                    return none$;
                });
                Option current = ((Map)degrees$1.elem).get(p);
                return current.isDefined() && BoxesRunTime.unboxToInt((Object)current.get()) == 0 ? queues.enqueue(p) : BoxedUnit.UNIT;
            });
        }
        int modelLength = vertModel.length;
        if (index != modelLength) {
            Predef$.MODULE$.println((Object)new StringBuilder(39).append("CreateTopoModel, build graph failed: ").append(index).append("<>").append(modelLength).toString());
            return (ArticleTerm[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ArticleTerm.class));
        }
        return var3_3;
    }

    public static final /* synthetic */ boolean $anonfun$DefineComparator$2(ArticleCode[] codeOrders$1, IArticleDefine x, IArticleDefine y) {
        Object qual$1 = Predef$.MODULE$.refArrayOps((Object[])codeOrders$1);
        ArticleCode x$1 = (ArticleCode)x.code();
        int x$2 = ArrayOps$.MODULE$.indexOf$default$2$extension(qual$1);
        int xIndex = ArrayOps$.MODULE$.indexOf$extension(qual$1, (Object)x$1, x$2);
        Object qual$2 = Predef$.MODULE$.refArrayOps((Object[])codeOrders$1);
        ArticleCode x$3 = (ArticleCode)y.code();
        int x$4 = ArrayOps$.MODULE$.indexOf$default$2$extension(qual$2);
        int yIndex = ArrayOps$.MODULE$.indexOf$extension(qual$2, (Object)x$3, x$4);
        boolean result = false;
        if (xIndex == -1 && yIndex == -1) {
            result = false;
        }
        if (xIndex == -1 && yIndex != -1) {
            result = true;
        }
        if (xIndex != -1 && yIndex == -1) {
            result = false;
        }
        result = new RichInt(Predef$.MODULE$.intWrapper(xIndex)).compare((Object)BoxesRunTime.boxToInteger((int)yIndex)) < 0;
        return result;
    }

    public static final /* synthetic */ boolean $anonfun$getArticleTerm$1(ArticleCode article$1, IArticleSpec m) {
        Object t = m.code();
        ArticleCode articleCode = article$1;
        return !(t != null ? !t.equals(articleCode) : articleCode != null);
    }

    public static final /* synthetic */ boolean $anonfun$getArticleDefs$1(ArticleCode article$2, IArticleSpec m) {
        Object t = m.code();
        ArticleCode articleCode = article$2;
        return !(t != null ? !t.equals(articleCode) : articleCode != null);
    }

    public static final /* synthetic */ boolean $anonfun$createEdgeModel$2(ArticleEdge a, ArticleEdge b) {
        ArticleTerm articleTerm = a.start();
        ArticleTerm articleTerm2 = b.start();
        return !(articleTerm != null ? !((Object)articleTerm).equals(articleTerm2) : articleTerm2 != null) ? a.stops().$less(b.stops()) : a.start().$less(b.start());
    }

    public static final /* synthetic */ boolean $anonfun$createPendModel$2(ArticleEdge a, ArticleEdge b) {
        ArticleTerm articleTerm = a.start();
        ArticleTerm articleTerm2 = b.start();
        return !(articleTerm != null ? !((Object)articleTerm).equals(articleTerm2) : articleTerm2 != null) ? a.stops().$less(b.stops()) : a.start().$less(b.start());
    }

    public static final /* synthetic */ boolean $anonfun$mergeEdges$1(IArticleSpec article$3, IConceptSpec c) {
        Object t = c.code();
        ConceptCode conceptCode = article$3.role();
        return !(t != null ? !t.equals(conceptCode) : conceptCode != null);
    }

    public static final /* synthetic */ boolean $anonfun$mergePends$1(IArticleSpec article$4, IConceptSpec c) {
        Object t = c.code();
        ConceptCode conceptCode = article$4.role();
        return !(t != null ? !t.equals(conceptCode) : conceptCode != null);
    }

    public static final /* synthetic */ boolean $anonfun$mergePaths$1(ArticleTerm article$5, ArticleEdge e) {
        ArticleTerm articleTerm = e.stops();
        ArticleTerm articleTerm2 = article$5;
        return !(articleTerm != null ? !((Object)articleTerm).equals(articleTerm2) : articleTerm2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$mergeVert$1(IArticleDefine defs$1, ArticleEdge e) {
        ArticleTerm articleTerm = e.stops();
        ArticleTerm articleTerm2 = defs$1.term();
        return !(articleTerm != null ? !((Object)articleTerm).equals(articleTerm2) : articleTerm2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$createTopoModel$2(ArticleTerm x$1, ArticleEdge e) {
        ArticleTerm articleTerm = e.stops();
        ArticleTerm articleTerm2 = x$1;
        return !(articleTerm != null ? !((Object)articleTerm).equals(articleTerm2) : articleTerm2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$createTopoModel$3(Tuple2 x) {
        return x._2$mcI$sp() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$createTopoModel$4(ArticleTerm article$6, ArticleEdge x) {
        ArticleTerm articleTerm = x.start();
        ArticleTerm articleTerm2 = article$6;
        return !(articleTerm != null ? !((Object)articleTerm).equals(articleTerm2) : articleTerm2 != null);
    }

    private DependencyGraph$() {
    }
}

