/*
 * Decompiled with CFR 0.152.
 */
package org.hrodberaht.directus.config;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.hrodberaht.directus.config.ConfigBase;
import org.hrodberaht.directus.config.ConfigException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigRegister {
    private Strategy customConfigurationStrategy;
    private Map<Class, ConfigBase> providedConfigurations = null;
    private Map<Class, ConfigBase> customConfigurations = null;
    private static ConfigRegister config = null;

    public static void registerConfig(ConfigBase config, String propertyPath, String customPropertyPath) {
        config.setPropertyPath(propertyPath);
        config.setCustomPropertyPath(customPropertyPath);
        if (ConfigRegister.config == null) {
            ConfigRegister.config = new ConfigRegister();
            HashMap<Class, ConfigBase> configurations = new HashMap<Class, ConfigBase>();
            ConfigRegister.config.setProvidedConfigurations(configurations);
            HashMap<Class, ConfigBase> customConfigurations = new HashMap<Class, ConfigBase>();
            ConfigRegister.config.setCustomConfigurations(customConfigurations);
            ConfigRegister.config.setCustomConfigurationStrategy(Strategy.INHERIT);
        }
        ConfigRegister.config.providedConfigurations.put(config.getClass(), config);
        ConfigRegister.config.load();
    }

    public static void registerConfig(ConfigBase config, String property) {
        ConfigRegister.registerConfig(config, property, null);
    }

    protected void load() {
        this.initiate(this.providedConfigurations);
        this.initiate(this.customConfigurations);
    }

    private void initiate(Map<Class, ConfigBase> configuration) {
        if (configuration == null) {
            return;
        }
        for (ConfigBase config : configuration.values()) {
            try {
                config.initiate();
                config.loadProperties();
            }
            catch (IllegalAccessException e) {
                throw new ConfigException(e);
            }
            catch (ParseException e) {
                throw new ConfigException(e);
            }
        }
    }

    public void setProvidedConfigurations(Map<Class, ConfigBase> providedConfigurations) {
        this.providedConfigurations = providedConfigurations;
    }

    public Map<Class, ConfigBase> getCustomConfigurations() {
        return this.customConfigurations;
    }

    public void setCustomConfigurations(Map<Class, ConfigBase> customConfigurations) {
        this.customConfigurations = customConfigurations;
    }

    public Strategy getCustomConfigurationStrategy() {
        return this.customConfigurationStrategy;
    }

    public void setCustomConfigurationStrategy(Strategy customConfigurationStrategy) {
        this.customConfigurationStrategy = customConfigurationStrategy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Strategy {
        INHERIT,
        REPLACE;

    }
}

