/*
 * Decompiled with CFR 0.152.
 */
package org.hrodberaht.directus.logging;

import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLogger {
    private Logger logger = null;

    public SimpleLogger(Class clazz) {
        this.logger = LoggerFactory.getLogger((Class)clazz);
    }

    public static SimpleLogger getInstance(Class clazz) {
        return new SimpleLogger(clazz);
    }

    public void debug(String message) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(message);
        }
    }

    public void debug(String message, Object ... args) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(MessageFormat.format(message, args));
        }
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void info(String message) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(message);
        }
    }

    public void info(String message, Object ... args) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info(MessageFormat.format(message, args));
        }
    }

    public void error(Throwable e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(null, e);
        }
    }

    public void error(String message, Throwable e) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(message, e);
        }
    }

    public void error(String message, Throwable e, Object ... args) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error(MessageFormat.format(message, args), e);
        }
    }
}

