/*
 * Decompiled with CFR 0.152.
 */
package org.hrodberaht.directus.util;

import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.hrodberaht.directus.exception.MessageRuntimeException;

public final class DateUtil {
    private static Locale locale = Locale.getDefault();
    private static String LONG_DATE = null;
    private static int LONG_DATE_LENGTH = -1;
    private static String SHORT_DATE = null;
    private static int SHORT_DATE_LENGTH = -1;
    private static Date systemOverriddenNow = null;

    private DateUtil() {
    }

    public static void setLocale(Locale locale) {
        DateUtil.locale = locale;
        DateUtil.updateFormatPatterns();
    }

    public static boolean isLessOrEqual(Date theDate, Date compare) {
        if (theDate == null || compare == null) {
            throw new IllegalAccessError("Dates can not be null");
        }
        return DateUtil.equals(theDate, compare) || DateUtil.before(theDate, compare);
    }

    public static boolean isMoreOrEqual(Date theDate, Date compare) {
        if (theDate == null || compare == null) {
            throw new IllegalAccessError("Dates can not be null");
        }
        return DateUtil.equals(theDate, compare) || DateUtil.after(theDate, compare);
    }

    public static boolean after(Date theDate, Date compare) {
        return theDate.getTime() > compare.getTime();
    }

    public static boolean before(Date theDate, Date compare) {
        return theDate.getTime() < compare.getTime();
    }

    public static Date parseDate(String date, String pattern) {
        Format format = DateUtil.cacheSimpleDateFormat(pattern);
        try {
            return DateUtil.parseDate(date, format);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean formattedDateEquals(Date date1, Date date2, String pattern) {
        Format format = DateUtil.cacheSimpleDateFormat(pattern);
        try {
            Date formattedDate1 = DateUtil.parseDate(format.format(date1), format);
            Date formattedDate2 = DateUtil.parseDate(format.format(date2), format);
            return formattedDate1.equals(formattedDate2);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean equals(Date date1, Date date2) {
        return date1.getTime() == date2.getTime();
    }

    public static Date parseSimpleDate(String date) {
        String pattern;
        int lenght = date.length();
        if (lenght == 0) {
            return null;
        }
        if (lenght >= LONG_DATE_LENGTH) {
            pattern = LONG_DATE;
        } else if (lenght >= SHORT_DATE_LENGTH) {
            pattern = SHORT_DATE;
        } else {
            throw new MessageRuntimeException("Unknown format for {0} ", date);
        }
        Format format = DateUtil.cacheSimpleDateFormat(pattern);
        try {
            return DateUtil.parseDate(date, format);
        }
        catch (ParseException e) {
            throw new MessageRuntimeException("Could not parse {0}", (Throwable)e, date);
        }
    }

    public static String formatTimeZone(Date theDate) {
        TimeZone timezone = DateFormat.getDateInstance(3, locale).getTimeZone();
        SimpleDateFormat format = new SimpleDateFormat("Z", locale);
        format.setTimeZone(timezone);
        return format.format(theDate);
    }

    public static String formatDate(Date date) {
        return DateUtil.formatDate(date, SHORT_DATE);
    }

    public static String formatDateTime(Date date) {
        return DateUtil.formatDate(date, LONG_DATE);
    }

    public static String formatDate(Date date, String pattern) {
        Format format = DateUtil.cacheSimpleDateFormat(pattern);
        return format.format(date);
    }

    public static Date rollDays(Date date, int days) {
        Calendar calendar = Calendar.getInstance(locale);
        calendar.setTime(date);
        calendar.add(6, days);
        return calendar.getTime();
    }

    public static Date rollMonth(Date date, int months) {
        Calendar calendar = Calendar.getInstance(locale);
        calendar.setTime(date);
        calendar.add(2, months);
        return calendar.getTime();
    }

    public static Date rollHours(Date date, int hours) {
        Calendar calendar = Calendar.getInstance(locale);
        calendar.setTime(date);
        calendar.add(11, hours);
        return calendar.getTime();
    }

    public static Date setTimeToActualMinimum(Date date) {
        Calendar calendar = Calendar.getInstance(locale);
        calendar.setTime(date);
        DateUtil.setTimeToActualMinimum(calendar);
        return calendar.getTime();
    }

    public static Date setTimeToActualMaximum(Date date) {
        Calendar calendar = Calendar.getInstance(locale);
        calendar.setTime(date);
        DateUtil.setTimeToActualMaximum(calendar);
        return calendar.getTime();
    }

    public static Date getNow() {
        if (systemOverriddenNow == null) {
            return new Date();
        }
        return systemOverriddenNow;
    }

    public static boolean isFirstInThisMonth(Date date) {
        Calendar now = Calendar.getInstance(locale);
        now.setTime(DateUtil.getNow());
        Calendar calendar = Calendar.getInstance(locale);
        calendar.setTime(date);
        boolean isFirstDayInMonth = calendar.getActualMinimum(5) == calendar.get(5);
        return isFirstDayInMonth && calendar.get(2) == now.get(2);
    }

    public static boolean isFirstInMonth(Date date) {
        Calendar calendar = Calendar.getInstance(locale);
        calendar.setTime(date);
        return calendar.getActualMinimum(5) == calendar.get(5);
    }

    public static boolean isLastInMonth(Date date) {
        Calendar calendar = Calendar.getInstance(locale);
        calendar.setTime(date);
        return calendar.getActualMaximum(5) == calendar.get(5);
    }

    public static boolean isBetween(Date theDate, Date fromDate, Date toDate) {
        if (theDate == null || fromDate == null) {
            return false;
        }
        if (theDate.compareTo(fromDate) == 0) {
            return true;
        }
        if (theDate.compareTo(toDate) == 0) {
            return true;
        }
        if (theDate.after(fromDate) && toDate == null) {
            return true;
        }
        return theDate.after(fromDate) && theDate.before(toDate);
    }

    private static void setTimeToActualMinimum(Calendar calendar) {
        calendar.set(11, calendar.getActualMinimum(11));
        calendar.set(12, calendar.getActualMinimum(12));
        calendar.set(13, calendar.getActualMinimum(13));
        calendar.set(14, calendar.getActualMinimum(14));
    }

    private static void setTimeToActualMaximum(Calendar calendar) {
        calendar.set(11, calendar.getActualMaximum(11));
        calendar.set(12, calendar.getActualMaximum(12));
        calendar.set(13, calendar.getActualMaximum(13));
        calendar.set(14, calendar.getActualMaximum(14));
    }

    private static Format cacheSimpleDateFormat(String pattern) {
        return new SimpleDateFormat(pattern);
    }

    private static Date parseDate(String date, Format format) throws ParseException {
        return (Date)format.parseObject(date);
    }

    private static void updateFormatPatterns() {
        SimpleDateFormat dateFormat = (SimpleDateFormat)DateFormat.getDateInstance(3, locale);
        SHORT_DATE = dateFormat.toLocalizedPattern();
        SHORT_DATE_LENGTH = SHORT_DATE.length();
        SimpleDateFormat dateTimeFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 2, locale);
        LONG_DATE = dateTimeFormat.toLocalizedPattern();
        LONG_DATE_LENGTH = LONG_DATE.length();
    }

    static {
        DateUtil.updateFormatPatterns();
    }
}

