/*
 * Decompiled with CFR 0.152.
 */
package test.org.hrodberaht.directus.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.hrodberaht.directus.exception.MessageRuntimeException;
import org.hrodberaht.directus.tdd.TestUtilDateUtil;
import org.hrodberaht.directus.util.DateUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestDateUtil {
    @BeforeClass
    public static void initStatic() {
        TestDateUtil.setTestLocale();
    }

    @Before
    public void init() {
        DateUtil.setLocale((Locale)TestDateUtil.getTestLocale());
    }

    private static Locale getTestLocale() {
        return new Locale("sv", "SE");
    }

    private static void setTestLocale() {
        System.setProperty("localeprovide.locale", "sv_SE");
    }

    @Test
    public void testDateEquals() {
        Date aDate = this.testDate("2010-01-01");
        Timestamp aTimestamp = new Timestamp(aDate.getTime());
        junit.framework.Assert.assertTrue((boolean)DateUtil.equals((Date)aDate, (Date)aTimestamp));
    }

    @Test
    public void testDateEquals_False() {
        Timestamp aTimestamp;
        Date aDate = this.testDate("2010-01-01");
        junit.framework.Assert.assertTrue((!DateUtil.equals((Date)aDate, (Date)(aTimestamp = new Timestamp(aDate.getTime() + 1L))) ? 1 : 0) != 0);
    }

    @Test
    public void testDateParseSimple() {
        Date aDate = DateUtil.parseSimpleDate((String)"2010-01-01");
        Assert.assertEquals((Object)this.testDate("2010-01-01"), (Object)aDate);
    }

    @Test
    public void testDateParseSimple_PatternFail() {
        try {
            DateUtil.parseSimpleDate((String)"10-01-01");
            Assert.assertEquals((Object)"Dont get here", null);
        }
        catch (MessageRuntimeException e) {
            Assert.assertEquals((Object)"Unknown format for 10-01-01 ", (Object)e.getMessage());
        }
    }

    @Test
    public void testDateFormatDefault() {
        DateUtil.setLocale((Locale)new Locale("en", "US"));
        Date aDate = DateUtil.parseSimpleDate((String)"01/01/2010");
        Assert.assertEquals((Object)this.testDate("2010-01-01"), (Object)aDate);
    }

    @Test(expected=MessageRuntimeException.class)
    public void testDateFormatDefaultFail() {
        DateUtil.setLocale((Locale)new Locale("en", "US"));
        Date aDate = DateUtil.parseSimpleDate((String)"2010-01-01");
        Assert.assertEquals((Object)this.testDate("2010-01-01"), (Object)aDate);
    }

    @Test(expected=RuntimeException.class)
    public void testParseDateError() {
        DateUtil.setLocale((Locale)new Locale("en", "US"));
        DateUtil.parseDate((String)"01/01/2010", (String)"yyyy-mmm.dd");
    }

    @Test
    public void testDateRollDays() {
        Date aDate = DateUtil.rollDays((Date)this.testDate("2010-01-01"), (int)1);
        Assert.assertEquals((Object)this.testDate("2010-01-02"), (Object)aDate);
    }

    @Test
    public void testDateRollMonth() {
        Date aDate = DateUtil.rollMonth((Date)this.testDate("2010-01-01"), (int)1);
        Assert.assertEquals((Object)this.testDate("2010-02-01"), (Object)aDate);
    }

    @Test
    public void testDateRollHours() {
        Date aDate = DateUtil.rollHours((Date)this.testDateTime("2010-01-01 14:00:00"), (int)1);
        Assert.assertEquals((Object)this.testDateTime("2010-01-01 15:00:00"), (Object)aDate);
    }

    @Test
    public void testDateParseDateWithPattern() {
        Date aDate = DateUtil.parseDate((String)"2010-01-01", (String)"yyyy-MM-dd");
        Assert.assertEquals((Object)this.testDate("2010-01-01"), (Object)aDate);
    }

    @Test
    public void testDateFormat() {
        String aDate = DateUtil.formatDate((Date)this.testDate("2010-01-01"));
        Assert.assertEquals((Object)"2010-01-01", (Object)aDate);
    }

    @Test
    public void testDateFormatCustom() {
        String aDate = DateUtil.formatDate((Date)this.testDate("2010-01-01"), (String)"yy-MM-dd");
        Assert.assertEquals((Object)"10-01-01", (Object)aDate);
    }

    @Test
    public void testDateTimeFormat() {
        String aDate = DateUtil.formatDateTime((Date)this.testDateTime("2010-01-01 12:00:00"));
        Assert.assertEquals((Object)"2010-01-01 12:00:00", (Object)aDate);
    }

    @Test
    public void testDateFormatTimeZone() {
        String vinterTime = DateUtil.formatTimeZone((Date)this.testDateTime("2010-01-01 12:00:00"));
        Assert.assertEquals((Object)"+0100", (Object)vinterTime);
        String summerTime = DateUtil.formatTimeZone((Date)this.testDateTime("2010-06-01 12:00:00"));
        Assert.assertEquals((Object)"+0200", (Object)summerTime);
    }

    @Test
    public void testDateFormattedDateEquals() {
        Date date1 = this.testDateTime("2010-01-01 12:00:00");
        Date date2 = this.testDateTime("2010-01-01 13:00:00");
        junit.framework.Assert.assertTrue((boolean)DateUtil.formattedDateEquals((Date)date1, (Date)date2, (String)"yyyy-MM-dd"));
    }

    @Test
    public void testDateIsBetween() {
        Date compareDate = this.testDateTime("2010-01-01 13:00:00");
        Date date1 = this.testDateTime("2010-01-01 12:00:00");
        Date date2 = this.testDateTime("2010-01-01 14:00:00");
        junit.framework.Assert.assertTrue((boolean)DateUtil.isBetween((Date)compareDate, (Date)date1, (Date)date2));
    }

    @Test
    public void testDateIsBetween_SameAsStart() {
        Date compareDate = this.testDateTime("2010-01-01 12:00:00");
        Date date1 = this.testDateTime("2010-01-01 12:00:00");
        Date date2 = this.testDateTime("2010-01-01 14:00:00");
        junit.framework.Assert.assertTrue((boolean)DateUtil.isBetween((Date)compareDate, (Date)date1, (Date)date2));
    }

    @Test
    public void testDateIsBetween_SameAsEnd() {
        Date compareDate = this.testDateTime("2010-01-01 14:00:00");
        Date date1 = this.testDateTime("2010-01-01 12:00:00");
        Date date2 = this.testDateTime("2010-01-01 14:00:00");
        junit.framework.Assert.assertTrue((boolean)DateUtil.isBetween((Date)compareDate, (Date)date1, (Date)date2));
    }

    @Test
    public void testDateIsLessOrEqual_Less() {
        Date date1 = this.testDateTime("2010-01-01 12:00:00");
        Date date2 = this.testDateTime("2010-01-01 13:00:00");
        junit.framework.Assert.assertTrue((boolean)DateUtil.isLessOrEqual((Date)date1, (Date)date2));
    }

    @Test
    public void testDateIsLessOrEqual_Equals() {
        Date date1 = this.testDateTime("2010-01-01 12:00:00");
        Date date2 = this.testDateTime("2010-01-01 12:00:00");
        junit.framework.Assert.assertTrue((boolean)DateUtil.isLessOrEqual((Date)date1, (Date)date2));
    }

    @Test
    public void testDateIsLessOrEqual_More() {
        Date date2;
        Date date1 = this.testDateTime("2010-01-01 13:00:00");
        junit.framework.Assert.assertTrue((!DateUtil.isLessOrEqual((Date)date1, (Date)(date2 = this.testDateTime("2010-01-01 12:00:00"))) ? 1 : 0) != 0);
    }

    @Test
    public void testDateIsLessOrEqual_Null() {
        try {
            Date date1 = this.testDateTime("2010-01-01 13:00:00");
            DateUtil.isLessOrEqual((Date)date1, null);
        }
        catch (IllegalAccessError e) {
            Assert.assertEquals((Object)"Dates can not be null", (Object)e.getMessage());
        }
    }

    @Test
    public void testDateIsMoreOrEqual_More() {
        Date date1 = this.testDateTime("2010-01-01 13:00:00");
        Date date2 = this.testDateTime("2010-01-01 12:00:00");
        junit.framework.Assert.assertTrue((boolean)DateUtil.isMoreOrEqual((Date)date1, (Date)date2));
    }

    @Test
    public void testDateIsMoreOrEqual_Equals() {
        Date date1 = this.testDateTime("2010-01-01 12:00:00");
        Date date2 = this.testDateTime("2010-01-01 12:00:00");
        junit.framework.Assert.assertTrue((boolean)DateUtil.isMoreOrEqual((Date)date1, (Date)date2));
    }

    @Test
    public void testDateIsMoreOrEqual_Less() {
        Date date2;
        Date date1 = this.testDateTime("2010-01-01 12:00:00");
        junit.framework.Assert.assertTrue((!DateUtil.isMoreOrEqual((Date)date1, (Date)(date2 = this.testDateTime("2010-01-01 13:00:00"))) ? 1 : 0) != 0);
    }

    @Test
    public void testDateIsMoreOrEqual_Null() {
        try {
            Date date1 = this.testDateTime("2010-01-01 13:00:00");
            DateUtil.isMoreOrEqual((Date)date1, null);
        }
        catch (IllegalAccessError e) {
            Assert.assertEquals((Object)"Dates can not be null", (Object)e.getMessage());
        }
    }

    @Test
    public void testDateUtilNow() {
        Date testNowDate = this.testDateTime("2010-01-01 12:00:00");
        TestUtilDateUtil.setNowDate((Date)testNowDate);
        Assert.assertEquals((Object)testNowDate, (Object)DateUtil.getNow());
        TestUtilDateUtil.clearNowDate();
        junit.framework.Assert.assertTrue((!DateUtil.equals((Date)testNowDate, (Date)DateUtil.getNow()) ? 1 : 0) != 0);
    }

    @Test
    public void testTimeToMinimum() {
        Date aDate = this.testDateTime("2010-01-01 12:00:00");
        aDate = DateUtil.setTimeToActualMinimum((Date)aDate);
        Assert.assertEquals((Object)this.testDateTime("2010-01-01 00:00:00"), (Object)aDate);
    }

    @Test
    public void testTimeToMaximum() {
        Date aDate = this.testDateTime("2010-01-01 12:00:00");
        aDate = DateUtil.setTimeToActualMaximum((Date)aDate);
        Assert.assertEquals((Object)this.testDateTimeMillis("2010-01-01 23:59:59:999"), (Object)aDate);
    }

    @Test
    public void testIsFirstInThisMonth() {
        TestUtilDateUtil.setNowDate((Date)this.testDateTime("2010-01-01 12:00:00"));
        Date aDate = this.testDateTime("2010-01-01 12:00:00");
        junit.framework.Assert.assertTrue((boolean)DateUtil.isFirstInThisMonth((Date)aDate));
        TestUtilDateUtil.clearNowDate();
    }

    @Test
    public void testIsFirstInThisMonth_False() {
        TestUtilDateUtil.setNowDate((Date)this.testDateTime("2010-03-01 12:00:00"));
        Date aDate = this.testDateTime("2010-01-01 12:00:00");
        junit.framework.Assert.assertTrue((!DateUtil.isFirstInThisMonth((Date)aDate) ? 1 : 0) != 0);
        TestUtilDateUtil.clearNowDate();
    }

    @Test
    public void testIsLastInThisMonth() {
        Date aDate = this.testDateTime("2010-01-31 12:00:00");
        junit.framework.Assert.assertTrue((boolean)DateUtil.isLastInMonth((Date)aDate));
    }

    @Test
    public void testIsLastInThisMonth_False() {
        Date aDate = this.testDateTime("2010-01-30 12:00:00");
        junit.framework.Assert.assertTrue((!DateUtil.isLastInMonth((Date)aDate) ? 1 : 0) != 0);
    }

    @Test
    public void testIsFirstMonth() {
        Date aDate = this.testDateTime("2010-01-01 12:00:00");
        junit.framework.Assert.assertTrue((boolean)DateUtil.isFirstInMonth((Date)aDate));
    }

    @Test
    public void testIsFirstMonth_False() {
        Date aDate = this.testDateTime("2010-01-02 12:00:00");
        junit.framework.Assert.assertTrue((!DateUtil.isFirstInMonth((Date)aDate) ? 1 : 0) != 0);
    }

    private Date testDateTimeMillis(String aDate) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS").parse(aDate);
        }
        catch (ParseException e) {
            throw new MessageRuntimeException("Could not format datetime {0}", new Object[]{aDate});
        }
    }

    private Date testDate(String aDate) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd").parse(aDate);
        }
        catch (ParseException e) {
            throw new MessageRuntimeException("Could not format date {0}", new Object[]{aDate});
        }
    }

    private Date testDateTime(String aDate) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(aDate);
        }
        catch (ParseException e) {
            throw new MessageRuntimeException("Could not format datetime {0}", new Object[]{aDate});
        }
    }
}

