/*
 * Decompiled with CFR 0.152.
 */
package org.hrodberaht.directus.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.hrodberaht.directus.config.ConfigItem;
import org.hrodberaht.directus.exception.MessageRuntimeException;
import org.hrodberaht.directus.logging.SimpleLogger;
import org.hrodberaht.directus.util.NumberUtil;
import org.hrodberaht.directus.util.SocketCloser;
import org.hrodberaht.directus.util.StringUtil;

public abstract class ConfigBase {
    private static final long RELOAD_INTERVAL = 15000L;
    private static long TIME_STAMP;
    private static boolean reloadEnabled;
    private static final SimpleLogger LOGGER;
    private String propertyPath = null;
    private String customPropertyPath = null;
    private Map<ConfigItem, ConfigItem> configurations = new HashMap<ConfigItem, ConfigItem>();
    private Properties properties = null;

    protected void loadProperties() throws ParseException {
        long elapsedTime = System.currentTimeMillis() - TIME_STAMP;
        if (this.properties == null) {
            this.reloadProperties();
            this.logProperties();
        } else if (reloadEnabled && (TIME_STAMP == 0L || elapsedTime > 15000L)) {
            this.reloadProperties();
            TIME_STAMP = System.currentTimeMillis();
        }
    }

    private void reloadProperties() throws ParseException {
        Properties origProperties = new Properties();
        Properties customProperties = new Properties();
        this.loadProperties(origProperties, this.propertyPath);
        if (this.customPropertyPath != null) {
            this.loadProperties(customProperties, this.customPropertyPath);
        }
        this.mergeProperties(origProperties, customProperties);
        this.populateConfigurationValues();
    }

    private void populateConfigurationValues() throws ParseException {
        for (ConfigItem config : this.configurations.keySet()) {
            String value = System.getProperty(config.getName());
            if (StringUtil.isBlank(value)) {
                value = this.properties.getProperty(config.getName());
            }
            if (value == null) continue;
            if (config.getType().isAssignableFrom(Boolean.class)) {
                config.setValue(Boolean.parseBoolean(value));
                continue;
            }
            if (config.getType().isAssignableFrom(Integer.class)) {
                config.setValue(NumberUtil.parseInt(value));
                continue;
            }
            if (config.getType().isAssignableFrom(Long.class)) {
                config.setValue(NumberUtil.parseLong(value));
                continue;
            }
            if (config.getType().isAssignableFrom(String[].class)) {
                config.setValue(value.split(","));
                continue;
            }
            if (config.getType().isAssignableFrom(Date.class)) {
                config.setValue(DateUtil.parseSimpleDate(value));
                continue;
            }
            config.setValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties(Properties props, String configPath) {
        InputStream data = null;
        try {
            if (configPath == null) {
                throw new RuntimeException("Property path not defined");
            }
            if (configPath.startsWith("classpath:")) {
                String path = configPath.replaceFirst("classpath:", "");
                data = ConfigBase.class.getResourceAsStream(path);
            } else if (configPath.startsWith("file:")) {
                File file = new File(configPath.replaceFirst("file:", ""));
                data = new FileInputStream(file);
            }
            if (data == null) {
                throw new MessageRuntimeException("Using property path {0} could not find a file", configPath);
            }
            props.load(data);
            SocketCloser.close(data);
        }
        catch (IOException e) {
            LOGGER.error(e);
        }
        finally {
            SocketCloser.close(data);
        }
    }

    private void mergeProperties(Properties origProperties, Properties customProperties) {
        this.properties = origProperties;
        if (customProperties != null) {
            Enumeration<Object> data = customProperties.keys();
            while (data.hasMoreElements()) {
                String key = (String)data.nextElement();
                String value = customProperties.getProperty(key);
                this.properties.remove(key);
                this.properties.put(key, value);
            }
        }
    }

    private void logProperties() {
        LOGGER.info("Loggging properties ...");
        Enumeration<Object> keys = this.properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = System.getProperty(key);
            if (StringUtil.isBlank(value)) {
                value = (String)this.properties.get(key);
            }
            LOGGER.info("Property key: {0}, value: {1}", key, value);
        }
        LOGGER.info("All properties logged");
    }

    public void initiate() throws IllegalAccessException {
        this.configurations.clear();
        this.checkForFields(this.getClass());
        Class[] interfaceses = this.getClass().getDeclaredClasses();
        this.checkInterfaces(interfaceses);
    }

    private void checkInterfaces(Class[] interfaceses) throws IllegalAccessException {
        for (Class ainterface : interfaceses) {
            if (!ainterface.isInterface()) continue;
            this.checkForFields(ainterface);
            Class[] innerinterfaceses = ainterface.getInterfaces();
            this.checkInterfaces(innerinterfaceses);
        }
    }

    private void checkForFields(Class aClass) throws IllegalAccessException {
        Field[] fields;
        for (Field field : fields = aClass.getDeclaredFields()) {
            if (!field.getType().isAssignableFrom(ConfigItem.class)) continue;
            ConfigItem obj = (ConfigItem)field.get(new ConfigItem());
            this.configurations.put(obj, obj);
        }
    }

    public void setPropertyPath(String path) {
        this.propertyPath = path;
    }

    public void setCustomPropertyPath(String path) {
        this.customPropertyPath = path;
    }

    public boolean requiresValidation() {
        return false;
    }

    public boolean validate() {
        return false;
    }

    static {
        reloadEnabled = false;
        LOGGER = SimpleLogger.getInstance(ConfigBase.class);
        String value = System.getProperty("config.reload.enable");
        if ("true".equals(value)) {
            reloadEnabled = true;
        }
    }

    private static class DateUtil {
        private DateUtil() {
        }

        private static Date parseSimpleDate(String value) throws ParseException {
            if (value == null) {
                return null;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            return dateFormat.parse(value);
        }
    }
}

