/*
 * Decompiled with CFR 0.152.
 */
package org.hrodberaht.i18n.formatter;

import java.util.Date;
import java.util.Locale;
import org.hrodberaht.i18n.formatter.BooleanFormatter;
import org.hrodberaht.i18n.formatter.CurrencyFormatter;
import org.hrodberaht.i18n.formatter.DateFormatter;
import org.hrodberaht.i18n.formatter.DecimalFormatter;
import org.hrodberaht.i18n.formatter.IntegerFormatter;
import org.hrodberaht.i18n.formatter.LongFormatter;
import org.hrodberaht.i18n.formatter.PercentageFormatter;
import org.hrodberaht.i18n.formatter.types.CurrencyData;
import org.hrodberaht.i18n.formatter.types.PercentData;
import org.hrodberaht.i18n.locale.LocaleProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Formatter<T> {
    protected Locale locale = LocaleProvider.getProfile().getLocale();

    public static <T> Formatter<T> getFormatter(Class<T> aType) {
        return Formatter.getFormatter(aType, null);
    }

    public static <T> Formatter<T> getFormatter(Class<T> aType, DateFormatter.DateConvert dateConvert) {
        if (String.class.isAssignableFrom(aType)) {
            return new Formatter<T>();
        }
        if (CurrencyData.class.isAssignableFrom(aType)) {
            return new CurrencyFormatter();
        }
        if (PercentData.class.isAssignableFrom(aType)) {
            return new PercentageFormatter();
        }
        if (Date.class.isAssignableFrom(aType)) {
            return dateConvert != null ? new DateFormatter(dateConvert) : new DateFormatter();
        }
        if (Integer.class.isAssignableFrom(aType)) {
            return new IntegerFormatter();
        }
        if (Integer.TYPE.isAssignableFrom(aType)) {
            return new IntegerFormatter();
        }
        if (Long.class.isAssignableFrom(aType)) {
            return new LongFormatter();
        }
        if (Long.TYPE.isAssignableFrom(aType)) {
            return new LongFormatter();
        }
        if (Boolean.class.isAssignableFrom(aType)) {
            return new BooleanFormatter();
        }
        if (Boolean.TYPE.isAssignableFrom(aType)) {
            return new BooleanFormatter();
        }
        if (Double.class.isAssignableFrom(aType)) {
            return new DecimalFormatter();
        }
        return null;
    }

    public static boolean isSupportedType(Class type) {
        return Formatter.getFormatter(type) != null;
    }

    public String convertToString(T value) {
        return value.toString();
    }

    public T convertToObject(String string) {
        return (T)(string == null ? null : string.trim());
    }
}

