/*
 * Decompiled with CFR 0.152.
 */
package org.hrodberaht.i18n.formatter;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.hrodberaht.directus.exception.MessageRuntimeException;
import org.hrodberaht.i18n.formatter.FormatException;
import org.hrodberaht.i18n.formatter.NumberFormatter;
import org.hrodberaht.i18n.formatter.types.PercentData;

public class PercentageFormatter
extends NumberFormatter {
    public static final int PERCENTAGE_SCALE = 2;

    public Object convertToObject(String target) {
        try {
            NumberFormat formatter = DecimalFormat.getPercentInstance(this.locale);
            if (target.indexOf("%") == -1) {
                target = target + "%";
            }
            Number parsedNumber = this.parseNumber(target, formatter);
            return new PercentData(parsedNumber.doubleValue());
        }
        catch (NumberFormatException e) {
            throw new MessageRuntimeException((Throwable)e);
        }
    }

    public String convertToString(Object value) {
        if (value == null) {
            return "";
        }
        try {
            BigDecimal bigDecValue = this.getBigDecimal(value);
            NumberFormat format = NumberFormat.getPercentInstance(this.locale);
            format = this.fixCharacterJVMErrorsForDecimalFormat(format);
            return format.format(bigDecValue.doubleValue());
        }
        catch (IllegalArgumentException iae) {
            throw new FormatException("Unable to format {0} as a percentage value", iae, value);
        }
    }

    private BigDecimal getBigDecimal(Object value) {
        BigDecimal bigDecValue = value instanceof Double ? new BigDecimal((Double)value) : (BigDecimal)value;
        bigDecValue = bigDecValue.setScale(2, 4);
        return bigDecValue;
    }
}

