/*
 * Decompiled with CFR 0.152.
 */
package test.org.hrodberaht.i18n.formatter;

import java.util.Arrays;
import java.util.List;
import org.hrodberaht.i18n.formatter.Formatter;
import org.junit.Assert;
import org.junit.Test;

public class TestBooleanFormatter {
    @Test
    public void simpleBooleanParseFormatTrue() {
        String testBoolean = "true";
        Formatter formatter = Formatter.getFormatter(Boolean.class);
        Boolean aBoolean = (Boolean)formatter.convertToObject(testBoolean);
        String aStringBoolean = formatter.convertToString((Object)aBoolean);
        Assert.assertEquals((Object)"Yes", (Object)aStringBoolean);
    }

    @Test
    public void simpleBooleanParseFormatFalse() {
        String testBoolean = "false";
        Formatter formatter = Formatter.getFormatter(Boolean.class);
        Boolean aBoolean = (Boolean)formatter.convertToObject(testBoolean);
        String aStringBoolean = formatter.convertToString((Object)aBoolean);
        Assert.assertEquals((Object)"No", (Object)aStringBoolean);
    }

    @Test
    public void testAllTrueFormats() {
        List<String> TRUE_VALUES = Arrays.asList("yes", "true", "on", "1", "enabled");
        Formatter formatter = Formatter.getFormatter(Boolean.class);
        for (String testBoolean : TRUE_VALUES) {
            Boolean aBoolean = (Boolean)formatter.convertToObject(testBoolean);
            Assert.assertEquals((Object)true, (Object)aBoolean);
        }
    }

    @Test
    public void testAllFalseFormats() {
        List<String> FALSE_VALUES = Arrays.asList("no", "false", "off", "0", "disabled");
        Formatter formatter = Formatter.getFormatter(Boolean.class);
        for (String testBoolean : FALSE_VALUES) {
            Boolean aBoolean = (Boolean)formatter.convertToObject(testBoolean);
            Assert.assertEquals((Object)false, (Object)aBoolean);
        }
    }
}

