/*
 * Decompiled with CFR 0.152.
 */
package test.org.hrodberaht.i18n.formatter;

import org.hrodberaht.directus.exception.MessageRuntimeException;
import org.hrodberaht.i18n.formatter.Formatter;
import org.hrodberaht.i18n.formatter.types.CurrencyData;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestCurrencyFormatter {
    @Before
    public void init() {
        System.setProperty("localeprovide.locale", "sv_SE");
    }

    @After
    public void destroy() {
        System.clearProperty("localeprovide.locale");
    }

    @Test
    public void simpleDecimalParseFormat() {
        String testDouble = "12 314 kr";
        Assert.assertEquals((Object)"12 314,00 kr", (Object)this.testFormatAndParse(testDouble));
    }

    @Test
    public void simpleDecimalParseFormatNoCharacter() {
        String testDouble = "12 314";
        Formatter formatter = Formatter.getFormatter(CurrencyData.class);
        CurrencyData aDouble = (CurrencyData)formatter.convertToObject(testDouble);
        String aStringDouble = formatter.convertToString((Object)aDouble);
        Assert.assertEquals((Object)(testDouble + ",00 kr"), (Object)aStringDouble);
    }

    @Test(expected=MessageRuntimeException.class)
    public void simpleDecimalParseFormatEmptyCharacters() {
        String testDouble = "12 314,43 kr ";
        this.testFormatAndParse(testDouble);
    }

    @Test(expected=MessageRuntimeException.class)
    public void simpleDecimalParseFormatDuplicateDecimalCharacters() {
        String testDouble = "12 314,43, kr";
        this.testFormatAndParse(testDouble);
    }

    @Test(expected=MessageRuntimeException.class)
    public void simpleDecimalParseFormatBadPlacedGroupingSeparator() {
        String testDouble = "1 12 314 kr";
        Assert.assertEquals((Object)"112 314,00 kr", (Object)this.testFormatAndParse(testDouble));
    }

    @Test
    public void simpleDecimalParseFormatSeveralGroupingSeparator() {
        String testDouble = "11 123 314 kr";
        Assert.assertEquals((Object)"11 123 314,00 kr", (Object)this.testFormatAndParse(testDouble));
    }

    @Test
    public void simpleDecimalOtherLocale() {
        System.setProperty("localeprovide.locale", "en_US");
        String testDouble = "$11,123,314";
        Assert.assertEquals((Object)"$11,123,314.00", (Object)this.testFormatAndParse(testDouble));
    }

    @Test
    public void simpleDecimalOtherNegativeLocale() {
        System.setProperty("localeprovide.locale", "en_US");
        String testDouble = "($11,123,314)";
        Assert.assertEquals((Object)"($11,123,314.00)", (Object)this.testFormatAndParse(testDouble));
    }

    private String testFormatAndParse(String testDouble) {
        Formatter formatter = Formatter.getFormatter(CurrencyData.class);
        CurrencyData aDouble = (CurrencyData)formatter.convertToObject(testDouble);
        return formatter.convertToString((Object)aDouble);
    }
}

