/*
 * Decompiled with CFR 0.152.
 */
package test.org.hrodberaht.i18n.formatter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.hrodberaht.directus.exception.MessageRuntimeException;
import org.hrodberaht.i18n.formatter.DateFormatter;
import org.hrodberaht.i18n.formatter.FormatException;
import org.hrodberaht.i18n.formatter.Formatter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDateFormatter {
    @Before
    public void init() {
        System.setProperty("localeprovide.locale", "sv_SE");
    }

    @After
    public void destroy() {
        System.clearProperty("localeprovide.locale");
    }

    @Test
    public void simpleDateParseFormat() {
        String testDate = "2010-01-01";
        Formatter formatter = Formatter.getFormatter(Date.class);
        Date aDate = (Date)formatter.convertToObject(testDate);
        String aStringDate = formatter.convertToString((Object)aDate);
        Assert.assertEquals((Object)testDate, (Object)aStringDate);
    }

    @Test(expected=FormatException.class)
    public void simpleBadDateParseFormat() {
        String testDate = "2010-01-01&";
        Formatter formatter = Formatter.getFormatter(Date.class);
        Date aDate = (Date)formatter.convertToObject(testDate);
        String aStringDate = formatter.convertToString((Object)aDate);
        Assert.assertEquals((Object)testDate, (Object)aStringDate);
    }

    @Test
    public void simpleDateTimeParse() {
        String testDate = "2010-01-01 00:00";
        Formatter formatter = Formatter.getFormatter(Date.class);
        Date aDate = (Date)formatter.convertToObject(testDate);
        Assert.assertEquals((Object)this.testDateTime("2010-01-01 00:00"), (Object)aDate);
    }

    @Test
    public void simpleDateTimeFormat() {
        String testDate = "2010-01-01 00:00";
        Formatter formatter = Formatter.getFormatter(Date.class, (DateFormatter.DateConvert)DateFormatter.DateConvert.DateTime);
        String aDate = formatter.convertToString((Object)this.testDateTime("2010-01-01 00:00"));
        Assert.assertEquals((Object)testDate, (Object)aDate);
    }

    private Date testDate(String aDate) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd").parse(aDate);
        }
        catch (ParseException e) {
            throw new MessageRuntimeException("Could not format date {0}", new Object[]{aDate});
        }
    }

    private Date testDateTime(String aDate) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd hh:mm").parse(aDate);
        }
        catch (ParseException e) {
            throw new MessageRuntimeException("Could not format datetime {0}", new Object[]{aDate});
        }
    }
}

