/*
 * Decompiled with CFR 0.152.
 */
package test.org.hrodberaht.i18n.formatter;

import java.text.NumberFormat;
import java.util.Locale;
import org.hrodberaht.directus.exception.MessageRuntimeException;
import org.hrodberaht.i18n.formatter.Formatter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDecimalFormatter {
    @Before
    public void init() {
        System.setProperty("localeprovide.locale", "sv_SE");
    }

    @After
    public void destroy() {
        System.clearProperty("localeprovide.locale");
    }

    @Test
    public void simpleDecimalParseFormat() {
        String testDouble = "12 314,43";
        Formatter formatter = Formatter.getFormatter(Double.class);
        Double aDouble = (Double)formatter.convertToObject(testDouble);
        String aStringDouble = formatter.convertToString((Object)aDouble);
        Assert.assertEquals((Object)testDouble, (Object)aStringDouble);
    }

    @Test(expected=MessageRuntimeException.class)
    public void simpleDecimalParseFormatEmptyCharacters() {
        String testDouble = "12 314,43 ";
        Formatter formatter = Formatter.getFormatter(Double.class);
        Double aDouble = (Double)formatter.convertToObject(testDouble);
        String aStringDouble = formatter.convertToString((Object)aDouble);
        Assert.assertEquals((Object)testDouble, (Object)aStringDouble);
    }

    @Test(expected=MessageRuntimeException.class)
    public void simpleDecimalParseFormatDuplicateDecimalCharacters() {
        String testDouble = "12 314,43,";
        Formatter formatter = Formatter.getFormatter(Double.class);
        Double aDouble = (Double)formatter.convertToObject(testDouble);
        String aStringDouble = formatter.convertToString((Object)aDouble);
        Assert.assertEquals((Object)testDouble, (Object)aStringDouble);
    }

    @Test(expected=MessageRuntimeException.class)
    public void simpleDecimalParseFormatBadPlacedGroupingSeparator() {
        String testDouble = "1 12 314,43";
        Formatter formatter = Formatter.getFormatter(Double.class);
        Double aDouble = (Double)formatter.convertToObject(testDouble);
        String aStringDouble = formatter.convertToString((Object)aDouble);
        Assert.assertEquals((Object)testDouble, (Object)aStringDouble);
    }

    @Test
    public void simpleDecimalParseFormatSeveralGroupingSeparator() {
        String testDouble = "11 123 314,43";
        Formatter formatter = Formatter.getFormatter(Double.class);
        Double aDouble = (Double)formatter.convertToObject(testDouble);
        String aStringDouble = formatter.convertToString((Object)aDouble);
        Assert.assertEquals((Object)testDouble, (Object)aStringDouble);
    }

    @Test
    public void testAllLocalesDecimalParseFormat() {
        Locale[] locales = NumberFormat.getAvailableLocales();
        double myNumber = -1234.56;
        System.clearProperty("localeprovide.locale");
        for (int i = 0; i < locales.length; ++i) {
            Locale.setDefault(locales[i]);
            Formatter formatter = Formatter.getFormatter(Double.class);
            String aStringDouble = formatter.convertToString((Object)myNumber);
            int badchar = 160;
            Assert.assertFalse((String)("Language " + locales[i].getLanguage() + "_" + locales[i].getCountry()), (aStringDouble.indexOf(badchar) != -1 ? 1 : 0) != 0);
        }
    }
}

