/*
 * Decompiled with CFR 0.152.
 */
package test.org.hrodberaht.i18n.formatter;

import org.hrodberaht.directus.exception.MessageRuntimeException;
import org.hrodberaht.i18n.formatter.Formatter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLongFormatter {
    @Before
    public void init() {
        System.setProperty("localeprovide.locale", "sv_SE");
    }

    @After
    public void destroy() {
        System.clearProperty("localeprovide.locale");
    }

    @Test
    public void simpleIntegerParseFormat() {
        String testLong = "14123123123131";
        Formatter formatter = Formatter.getFormatter(Long.class);
        Long aLong = (Long)formatter.convertToObject(testLong);
        String aStringLong = formatter.convertToString((Object)aLong);
        Assert.assertEquals((Object)testLong, (Object)aStringLong);
    }

    @Test(expected=MessageRuntimeException.class)
    public void simpleIntegerParseFormatFail() {
        String testLong = "14123123123131.12";
        Formatter formatter = Formatter.getFormatter(Long.class);
        Long aLong = (Long)formatter.convertToObject(testLong);
        String aStringLong = formatter.convertToString((Object)aLong);
        Assert.assertEquals((Object)testLong, (Object)aStringLong);
    }

    @Test
    public void simpleIntegerParseFormatFailVerifyMessage() {
        try {
            String testLong = "14123123123131.12";
            Formatter formatter = Formatter.getFormatter(Long.class);
            Long aLong = (Long)formatter.convertToObject(testLong);
            Assert.assertTrue((String)"Not allowed to reach this", (boolean)false);
        }
        catch (MessageRuntimeException e) {
            Assert.assertEquals((Object)"Parse failed on character \".\" at position: 14 for 14123123123131.12", (Object)e.getMessage());
        }
    }
}

