/*
 * Decompiled with CFR 0.152.
 */
package test.org.hrodberaht.i18n.formatter;

import org.hrodberaht.directus.exception.MessageRuntimeException;
import org.hrodberaht.i18n.formatter.Formatter;
import org.hrodberaht.i18n.formatter.types.PercentData;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPercentageFormatter {
    @Before
    public void init() {
        System.setProperty("localeprovide.locale", "sv_SE");
    }

    @After
    public void destroy() {
        System.clearProperty("localeprovide.locale");
    }

    @Test
    public void simpleDecimalParseFormat() {
        String testDouble = "12 314%";
        this.testFormatAndParse(testDouble);
    }

    @Test
    public void simpleDecimalParseFormatNoCharacter() {
        String testDouble = "12 314";
        Formatter formatter = Formatter.getFormatter(PercentData.class);
        PercentData aDouble = (PercentData)formatter.convertToObject(testDouble);
        String aStringDouble = formatter.convertToString((Object)aDouble);
        Assert.assertEquals((Object)(testDouble + "%"), (Object)aStringDouble);
    }

    @Test(expected=MessageRuntimeException.class)
    public void simpleDecimalParseFormatEmptyCharacters() {
        String testDouble = "12 314,43% ";
        this.testFormatAndParse(testDouble);
    }

    @Test(expected=MessageRuntimeException.class)
    public void simpleDecimalParseFormatDuplicateDecimalCharacters() {
        String testDouble = "12 314,43,%";
        this.testFormatAndParse(testDouble);
    }

    @Test(expected=MessageRuntimeException.class)
    public void simpleDecimalParseFormatBadPlacedGroupingSeparator() {
        String testDouble = "1 12 314%";
        this.testFormatAndParse(testDouble);
    }

    @Test
    public void simpleDecimalParseFormatSeveralGroupingSeparator() {
        String testDouble = "11 123 314%";
        this.testFormatAndParse(testDouble);
    }

    private void testFormatAndParse(String testDouble) {
        Formatter formatter = Formatter.getFormatter(PercentData.class);
        PercentData aDouble = (PercentData)formatter.convertToObject(testDouble);
        String aStringDouble = formatter.convertToString((Object)aDouble);
        Assert.assertEquals((Object)testDouble, (Object)aStringDouble);
    }
}

