/*
 * Decompiled with CFR 0.152.
 */
package org.hrodberaht.i18n.formatter;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.hrodberaht.directus.exception.MessageRuntimeException;
import org.hrodberaht.i18n.formatter.NumberFormatter;
import org.hrodberaht.i18n.formatter.types.CurrencyData;

public class CurrencyFormatter
extends NumberFormatter {
    public static final int SCALE = 2;

    public Object convertToObject(String target) {
        if (target == null) {
            return null;
        }
        NumberFormat formatter = NumberFormat.getCurrencyInstance(this.locale);
        target = this.interpolateSymbol(target, formatter);
        Number parsedNumber = this.parseNumber(target, formatter);
        BigDecimal value = new BigDecimal(parsedNumber.doubleValue());
        return new CurrencyData(value.doubleValue());
    }

    private String interpolateSymbol(String target, NumberFormat formatter) {
        String symbol;
        DecimalFormat decimalFormat = (DecimalFormat)formatter;
        if (!"".equals(decimalFormat.getPositivePrefix()) && !this.hasSymbol(target, symbol = decimalFormat.getPositivePrefix())) {
            return symbol + target;
        }
        if (!"".equals(decimalFormat.getPositiveSuffix()) && !this.hasSymbol(target, symbol = decimalFormat.getPositiveSuffix())) {
            return target + symbol;
        }
        return target;
    }

    private boolean hasSymbol(String target, String symbol) {
        return target.indexOf(symbol) != -1;
    }

    public String convertToString(Object obj) {
        if (obj == null) {
            return null;
        }
        NumberFormat formatter = NumberFormat.getCurrencyInstance(this.locale);
        try {
            BigDecimal number = (BigDecimal)obj;
            number = number.setScale(2, 4);
            formatter = this.fixCharacterJVMErrorsForDecimalFormat(formatter);
            return formatter.format(number.doubleValue());
        }
        catch (IllegalArgumentException e) {
            throw new MessageRuntimeException((Throwable)e);
        }
    }
}

