/*
 * Decompiled with CFR 0.152.
 */
package org.hrodberaht.i18n.formatter;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.hrodberaht.i18n.formatter.FormatException;
import org.hrodberaht.i18n.formatter.Formatter;

public class DateFormatter
extends Formatter {
    private static HashMap<Locale, String> longPatternCache = new HashMap();
    private DateConvert convertDateStyle = DateConvert.Date;
    private int dateStyle = 3;
    private int timeStyle = 3;

    public DateFormatter(DateConvert dateConvert) {
        this.convertDateStyle = dateConvert;
    }

    public DateFormatter() {
    }

    public Object convertToObject(String target) {
        DateFormat formatter = this.getFormat(target);
        return this.parseAndErrorhandleDate(target, formatter);
    }

    private DateFormat getFormat(String target) {
        if (this.convertDateStyle == DateConvert.DateTime) {
            return DateFormat.getDateTimeInstance(this.dateStyle, this.timeStyle, this.locale);
        }
        String longPattern = this.getCachedLongPattern();
        if (target != null && longPattern.length() <= target.length()) {
            return DateFormat.getDateTimeInstance(this.dateStyle, this.timeStyle, this.locale);
        }
        return DateFormat.getDateInstance(this.dateStyle, this.locale);
    }

    private String getCachedLongPattern() {
        if (longPatternCache.containsKey(this.locale)) {
            return longPatternCache.get(this.locale);
        }
        SimpleDateFormat dateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 3, this.locale);
        String pattern = dateFormat.toLocalizedPattern();
        longPatternCache.put(this.locale, pattern);
        return pattern;
    }

    public String convertToString(Object value) {
        if (value == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        DateFormat formatter = this.getFormat(null);
        buf = formatter.format(value, buf, new FieldPosition(0));
        return buf.toString();
    }

    protected Date parseAndErrorhandleDate(String target, DateFormat formatter) {
        ParsePosition parsePosition = new ParsePosition(0);
        Date parsedDate = formatter.parse(target.trim(), parsePosition);
        this.checkParsePositionForErrors(target, parsePosition);
        return parsedDate;
    }

    private void checkParsePositionForErrors(String target, ParsePosition parsePosition) {
        if (parsePosition.getIndex() != target.length()) {
            throw new FormatException("Parsing stopped for char {0} at position {1} for {2}", Character.valueOf(target.charAt(parsePosition.getIndex())), parsePosition.getIndex(), target);
        }
        if (parsePosition.getErrorIndex() != -1) {
            throw new FormatException("Parsing failed on char {0} at position {1} for {2}", Character.valueOf(target.charAt(parsePosition.getErrorIndex())), parsePosition.getErrorIndex(), target);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DateConvert {
        Date,
        DateTime;

    }
}

