/*
 * Decompiled with CFR 0.152.
 */
package org.hrodberaht.i18n.locale;

import java.util.Locale;
import org.hrodberaht.directus.exception.MessageRuntimeException;
import org.hrodberaht.i18n.locale.LocaleProfile;
import org.hrodberaht.i18n.locale.ProviderInterface;

public class SimpleLocaleProvider
implements ProviderInterface {
    public LocaleProfile getProfile() {
        return new LocaleProfile(this.getSystemLocale());
    }

    public Locale getSystemLocale() {
        return this.createSystemLocale();
    }

    protected Locale createSystemLocale() {
        String locale = System.getProperty("localeprovide.locale");
        if (locale != null) {
            return this.createLocale(locale);
        }
        return Locale.getDefault();
    }

    protected Locale createLocale(String locale) {
        String[] locales = locale.split("_");
        if (locales.length == 1) {
            return new Locale(locales[0]);
        }
        return new Locale(locales[0], locales[1]);
    }

    public ProviderInterface.StatefulProfile statefulProfileSupport() {
        return ProviderInterface.StatefulProfile.NONE;
    }

    public void setStatefulProfile(LocaleProfile localeProfile) {
        throw new MessageRuntimeException("SimpleLocaleProvider does not have Stateful profile support");
    }
}

