/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class DataLoad {
    private static final String STATIC_DATA_PATH = "org/hspconsortium/platform/sample/clinicaldata/dstu2";
    private static String RESOURCE_URI = "http://localhost:8080/hsp-api/data";
    private static String OUTPUT_DIR = "output";
    private static boolean isXML = true;

    public static void main(String[] args) throws Exception {
        Resource[] patientFileResources;
        boolean userProvidedDir = false;
        boolean writeOutput = true;
        boolean canWrite = false;
        block14: for (int i = 0; i < args.length; ++i) {
            switch (args[i]) {
                case "-h": {
                    System.out.println("java -jar hsp-tools.jar org.hspconsortium.DataLoad [options]");
                    System.out.println("   Options:");
                    System.out.println("   -h       print this message");
                    System.out.println("   -url     the url for the hsp api ex: -url http://localhost:8080/hsp-api");
                    System.out.println("   -json    indicates that the input files are JSON, XML is the default");
                    System.out.println("   -out     the output directory for results; default '<current dir>/output'");
                    System.out.println("            unless the current directory is 'target', the output directory will");
                    System.out.println("            be created one directory up from 'target'");
                    System.out.println("            NOTE: the import will fail if results can't be written out");
                    System.out.println("   -no-out  no output for results");
                    return;
                }
                case "-url": {
                    RESOURCE_URI = args[++i];
                    continue block14;
                }
                case "-out": {
                    userProvidedDir = true;
                    OUTPUT_DIR = args[++i];
                    continue block14;
                }
                case "-no-out": {
                    writeOutput = false;
                    continue block14;
                }
                case "-json": {
                    isXML = false;
                }
            }
        }
        if (userProvidedDir || writeOutput) {
            canWrite = DataLoad.checkOutput(OUTPUT_DIR, userProvidedDir);
            System.out.println("can write: " + canWrite);
            if (!canWrite) {
                return;
            }
        }
        PathMatchingResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
        for (Resource patientFile : patientFileResources = resourceResolver.getResources(String.format("classpath:%s/*", STATIC_DATA_PATH))) {
            if (!patientFile.isReadable()) continue;
            byte[] xmlString = IOUtils.toByteArray((InputStream)patientFile.getInputStream());
            HttpResponse response = DataLoad.post(xmlString);
            System.out.println("File: " + patientFile.toString());
            StatusLine sl = response.getStatusLine();
            System.out.println("Status: " + sl.getStatusCode());
            if (sl.getStatusCode() != 200) {
                System.out.println("Cause: " + sl.toString());
                continue;
            }
            if (!canWrite) continue;
            DataLoad.writeOutput(response);
        }
    }

    private static void writeOutput(HttpResponse response) {
        OutputStream outputStream = null;
        try {
            String outputDir = OUTPUT_DIR + "/" + DataLoad.getUinqueID() + ".json";
            System.out.println("Output: " + outputDir);
            outputStream = new FileOutputStream(outputDir);
            IOUtils.copy((InputStream)response.getEntity().getContent(), (OutputStream)outputStream);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    private static boolean checkOutput(String directoryName, boolean userProvidedDir) {
        boolean canWriteFiles = false;
        String workingDir = directoryName;
        if (!userProvidedDir) {
            workingDir = System.getProperty("user.dir");
            if (workingDir.endsWith("/target")) {
                workingDir = workingDir.substring(0, workingDir.lastIndexOf("/target") + 1);
            }
            if (directoryName.equalsIgnoreCase("output")) {
                workingDir = workingDir + directoryName;
            }
        }
        File theDir = new File(workingDir);
        System.out.println("Output Directory: " + workingDir);
        if (!theDir.exists()) {
            System.out.println("creating directory: " + workingDir);
            try {
                theDir.mkdir();
                if (theDir.exists()) {
                    canWriteFiles = true;
                }
            }
            catch (SecurityException se) {
                return false;
            }
            if (canWriteFiles) {
                System.out.println("DIR created");
            }
        } else {
            File testFile = new File(workingDir + "/testfile");
            try {
                testFile.createNewFile();
                if (testFile.exists()) {
                    canWriteFiles = true;
                }
                testFile.deleteOnExit();
            }
            catch (IOException e) {
                return false;
            }
        }
        OUTPUT_DIR = workingDir;
        return canWriteFiles;
    }

    protected static HttpResponse post(byte[] payload) {
        HttpPost postRequest = new HttpPost(RESOURCE_URI);
        DataLoad.setRequestHeaders((HttpRequest)postRequest);
        return DataLoad.sendPayload((HttpEntityEnclosingRequestBase)postRequest, payload);
    }

    protected static HttpResponse sendPayload(HttpEntityEnclosingRequestBase request, byte[] payload) {
        HttpResponse response = null;
        try {
            DefaultHttpClient httpclient = new DefaultHttpClient();
            request.setEntity((HttpEntity)new ByteArrayEntity(payload));
            response = httpclient.execute((HttpUriRequest)request);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error sending HTTP Post/Put Payload", ioe);
        }
        return response;
    }

    protected static void setRequestHeaders(HttpRequest request) {
        request.addHeader("User-Agent", "Java FHIR Client for FHIR");
        if (isXML) {
            request.addHeader("Accept", "application/xml+fhir");
            request.addHeader("Content-Type", "application/xml+fhir;charset=UTF-8");
        } else {
            request.addHeader("Accept", "application/json+fhir");
            request.addHeader("Content-Type", "application/json+fhir;charset=UTF-8");
        }
        request.addHeader("Accept-Charset", "UTF-8");
    }

    private static String getUinqueID() {
        return UUID.randomUUID().toString();
    }
}

