/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.platform.messaging.drools.factory;

import ca.uhn.fhir.model.dstu2.resource.Subscription;
import org.springframework.stereotype.Component;

@Component
public class RuleFromSubscriptionFactory {
    public String create(Subscription subscription) {
        String resource;
        switch (resource = this.getResourceFromCriteria(subscription.getCriteria())) {
            case "Patient": {
                return this.createPatientDroolsRule(subscription);
            }
            case "Observation": {
                return this.createObservationDroolsRule(subscription);
            }
        }
        throw new RuntimeException("Unsupported resource for criteria: " + subscription.getCriteria());
    }

    private String getResourceFromCriteria(String criteria) {
        String[] split = criteria.split("\\?");
        return split[0];
    }

    private String[] getCriteriaOptions(String criteria) {
        String[] split = criteria.split("\\?");
        if (split.length > 1) {
            String options = split[1];
            return options.split("&");
        }
        return null;
    }

    private String createPatientDroolsRule(Subscription subscription) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("package org.hspconsortium.platform.messaging\n");
        stringBuffer.append("dialect \"mvel\"\n");
        stringBuffer.append("import org.hspconsortium.platform.messaging.model.ResourceRoutingContainer\n");
        stringBuffer.append("import org.hspconsortium.platform.messaging.model.PatientRoutingContainer\n");
        stringBuffer.append("rule \"Subscription rule: " + subscription.getId().getIdPart() + "\"\n");
        stringBuffer.append("    when\n");
        stringBuffer.append("        $c: PatientRoutingContainer()");
        stringBuffer.append("    then\n");
        stringBuffer.append("        $c.addDestinationChannel(\"" + subscription.getChannel().getEndpoint() + "\");\n");
        stringBuffer.append("end\n");
        return stringBuffer.toString();
    }

    private String createObservationDroolsRule(Subscription subscription) {
        String codeOption = this.getCriteria("code", this.getCriteriaOptions(subscription.getCriteria()));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("package org.hspconsortium.platform.messaging\n");
        stringBuffer.append("dialect \"mvel\"\n");
        stringBuffer.append("import org.hspconsortium.platform.messaging.model.ResourceRoutingContainer\n");
        stringBuffer.append("import org.hspconsortium.platform.messaging.model.ObservationRoutingContainer\n");
        stringBuffer.append("rule \"Subscription rule: " + subscription.getId().getIdPart() + "\"\n");
        stringBuffer.append("    when\n");
        stringBuffer.append("        $c: ObservationRoutingContainer(\n");
        if (codeOption != null) {
            stringBuffer.append("              getObservation().getCode() != null\n");
            stringBuffer.append("              && getObservation().getCode().getCodingFirstRep() != null\n");
            stringBuffer.append("              && getObservation().getCode().getCodingFirstRep().getCode() == \"" + codeOption + "\"\n");
        }
        stringBuffer.append("            )\n");
        stringBuffer.append("    then\n");
        stringBuffer.append("        $c.addDestinationChannel(\"" + subscription.getChannel().getEndpoint() + "\");\n");
        stringBuffer.append("end\n");
        return stringBuffer.toString();
    }

    private String getCriteria(String name, String[] criteriaOptions) {
        if (criteriaOptions != null) {
            for (String option : criteriaOptions) {
                if (!option.equals(name)) continue;
                return option;
            }
        }
        return null;
    }
}

