/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.platform.messaging.model;

import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.dstu2.resource.Patient;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang3.Validate;
import org.hspconsortium.platform.messaging.model.ResourceRoutingContainer;

public class PatientRoutingContainer
extends ResourceRoutingContainer
implements Serializable {
    private Patient patient;
    private long ageInMillis;

    public PatientRoutingContainer(Patient patient) {
        this.patient = patient;
        Validate.notNull((Object)patient.getBirthDate());
        this.ageInMillis = new Date().getTime() - patient.getBirthDate().getTime();
    }

    public IResource getResource() {
        return this.getPatient();
    }

    public Patient getPatient() {
        return this.patient;
    }

    public long getAgeInMillis() {
        return this.ageInMillis;
    }
}

