/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.platform.messaging.service.ldap;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import javax.naming.Name;
import javax.naming.ldap.LdapName;
import org.hspconsortium.platform.messaging.model.ldap.DirectoryType;
import org.hspconsortium.platform.messaging.model.ldap.User;
import org.hspconsortium.platform.messaging.model.ldap.UserRepo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ldap.core.support.BaseLdapNameAware;
import org.springframework.ldap.query.ContainerCriteria;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;
import org.springframework.ldap.support.LdapNameBuilder;
import org.springframework.ldap.support.LdapUtils;
import org.springframework.stereotype.Component;

@Component
public class UserService
implements BaseLdapNameAware {
    private final UserRepo userRepo;
    private LdapName baseLdapPath;
    private DirectoryType directoryType = DirectoryType.NORMAL;

    @Autowired
    public UserService(UserRepo userRepo) {
        this.userRepo = userRepo;
    }

    public void setDirectoryType(DirectoryType directoryType) {
        this.directoryType = directoryType;
    }

    public void setBaseLdapPath(LdapName baseLdapPath) {
        this.baseLdapPath = baseLdapPath;
    }

    public Iterable<User> findAll(String base) {
        ContainerCriteria ldapQuery = LdapQueryBuilder.query().base(base).where("objectclass").is("pwmUser");
        return this.userRepo.findAll((LdapQuery)ldapQuery);
    }

    public User findUser(String userId) {
        return (User)this.userRepo.findOne((Serializable)LdapUtils.newLdapName((String)userId));
    }

    public User findUser(LdapName userId) {
        return (User)this.userRepo.findOne((Serializable)userId);
    }

    public LdapName toAbsoluteDn(Name relativeName) {
        return LdapNameBuilder.newInstance((Name)this.baseLdapPath).add(relativeName).build();
    }

    public Set<User> findAllMembers(Iterable<Name> absoluteIds) {
        return Sets.newLinkedHashSet((Iterable)this.userRepo.findAll(this.toRelativeIds(absoluteIds)));
    }

    public Iterable<Name> toRelativeIds(Iterable<Name> absoluteIds) {
        return Iterables.transform(absoluteIds, (Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    public User updateUser(String userId, User user) {
        LdapName originalId = LdapUtils.newLdapName((String)userId);
        User existingUser = (User)this.userRepo.findOne((Serializable)originalId);
        existingUser.setFirstName(user.getFirstName());
        existingUser.setLastName(user.getLastName());
        existingUser.setUserPwmId(user.getUserPwmId());
        existingUser.setEmail(user.getEmail());
        existingUser.setPhone(user.getPhone());
        existingUser.setTitle(user.getTitle());
        existingUser.setEmployeeNumber(user.getEmployeeNumber());
        existingUser.setOrganizationName(user.getOrganizationName());
        existingUser.setProfileUri(user.getProfileUri());
        if (this.directoryType == DirectoryType.NORMAL) {
            return (User)this.userRepo.save((Object)existingUser);
        }
        return user;
    }

    public List<User> searchByUserName(String userName) {
        return this.userRepo.findByUserName(userName);
    }

    public LdapName getBaseLdapPath() {
        return this.baseLdapPath;
    }

    static /* synthetic */ LdapName access$000(UserService x0) {
        return x0.baseLdapPath;
    }
}

