/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.platform.messaging;

import ca.uhn.fhir.context.FhirContext;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.UUID;
import javax.inject.Inject;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.validator.UrlValidator;
import org.hspconsortium.client.auth.Scope;
import org.hspconsortium.client.auth.Scopes;
import org.hspconsortium.client.auth.SimpleScope;
import org.hspconsortium.client.auth.access.AccessTokenProvider;
import org.hspconsortium.client.auth.access.JsonAccessTokenProvider;
import org.hspconsortium.client.auth.credentials.ClientSecretCredentials;
import org.hspconsortium.client.auth.credentials.Credentials;
import org.hspconsortium.client.auth.credentials.JWTCredentials;
import org.hspconsortium.client.controller.FhirEndpointsProvider;
import org.hspconsortium.client.session.clientcredentials.ClientCredentialsSessionFactory;
import org.hspconsortium.platform.messaging.drools.service.DroolsSubscriptionManagerService;
import org.hspconsortium.platform.messaging.service.SandboxUserRegistrationService;
import org.hspconsortium.platform.messaging.service.SubscriptionManagerService;
import org.hspconsortium.platform.messaging.service.ldap.UserService;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;

@Configuration
@PropertySource(value={"classpath:application.properties"})
@ImportResource(value={"classpath*:/META-INF/spring/spring-integration-config.xml"})
public class AppConfig {
    @Autowired
    Environment env;

    @Bean
    public SubscriptionManagerService subscriptionManagerService() {
        return new DroolsSubscriptionManagerService();
    }

    @Bean
    public SandboxUserRegistrationService sandboxUserRegistrationService() {
        return new SandboxUserRegistrationService.Impl();
    }

    @Bean
    public KnowledgeBase knowledgeBase() {
        return KnowledgeBaseFactory.newKnowledgeBase();
    }

    @Bean
    public String fhirServicesUrl() {
        return this.env.getProperty("hspc.reference.api.url");
    }

    @Bean
    public String clientId() {
        return this.env.getProperty("hspc.reference.messaging.app.clientId");
    }

    @Bean
    public String scope() {
        return this.env.getProperty("hspc.reference.messaging.app.scopes");
    }

    @Bean
    public String clientSecret() {
        return this.env.getProperty("sandbox.messaging.clientSecret");
    }

    @Bean
    public String jsonWebKeySetLocation() {
        return this.env.getProperty("hspc.reference.messaging.app.jsonWebKeySetLocation");
    }

    @Bean
    public Integer httpConnectionTimeOut() {
        return Integer.parseInt(this.env.getProperty("sandbox.messaging.httpConnectionTimeoutMilliSeconds", "10000"));
    }

    @Bean
    public Integer httpReadTimeOut() {
        return Integer.parseInt(this.env.getProperty("sandbox.messaging.httpReadTimeoutMilliSeconds", "10000"));
    }

    @Bean
    public String proxyPassword() {
        return System.getProperty("http.proxyPassword", System.getProperty("https.proxyPassword"));
    }

    @Bean
    public String proxyUser() {
        return System.getProperty("http.proxyUser", System.getProperty("https.proxyUser"));
    }

    @Bean
    public Integer proxyPort() {
        return Integer.parseInt(System.getProperty("http.proxyPort", System.getProperty("https.proxyPort", "8080")));
    }

    @Bean
    public String proxyHost() {
        return System.getProperty("http.proxyHost", System.getProperty("https.proxyHost"));
    }

    @Bean
    public Integer jsonWebKeySetSizeLimitBytes() {
        return Integer.parseInt(this.env.getProperty("sandbox.messaging.jsonWebKeySetSizeLimitBytes", "10000"));
    }

    @Bean
    public Long jsonTokenDuration() {
        return Long.parseLong(this.env.getProperty("sandbox.messaging.tokenDuration", "900"));
    }

    @Bean
    @Inject
    public ClientSecretCredentials clientSecretCredentials(String clientSecret) {
        return new ClientSecretCredentials(clientSecret);
    }

    @Bean
    public AccessTokenProvider tokenProvider(FhirContext fhirContext) {
        return new JsonAccessTokenProvider(fhirContext);
    }

    @Bean
    public FhirEndpointsProvider fhirEndpointsProvider(FhirContext fhirContext) {
        return new FhirEndpointsProvider.Impl(fhirContext);
    }

    @Bean
    @Inject
    public Credentials credentials(String clientSecret, String jsonWebKeySetLocation) {
        if (clientSecret != null) {
            return this.clientSecretCredentials(clientSecret);
        }
        if (jsonWebKeySetLocation != null) {
            return this.jwtCredentials(this.jwkSet(this.jsonWebKeySetLocation(), this.httpConnectionTimeOut(), this.httpReadTimeOut(), this.jsonWebKeySetSizeLimitBytes()), this.clientId(), null, this.jsonTokenDuration());
        }
        throw new RuntimeException("Credentials not specified");
    }

    @Bean
    public FhirContext fhirContext(Integer httpConnectionTimeOut, Integer httpReadTimeOut, String proxyHost, Integer proxyPort, String proxyUser, String proxyPassword) {
        FhirContext hapiFhirContext = FhirContext.forDstu2();
        hapiFhirContext.getRestfulClientFactory().setConnectTimeout(httpConnectionTimeOut.intValue());
        hapiFhirContext.getRestfulClientFactory().setSocketTimeout(httpReadTimeOut.intValue());
        if (proxyHost != null) {
            hapiFhirContext.getRestfulClientFactory().setProxy(proxyHost, proxyPort);
            hapiFhirContext.getRestfulClientFactory().setProxyCredentials(proxyUser, proxyPassword);
        }
        return hapiFhirContext;
    }

    @Bean
    @Inject
    public ClientCredentialsSessionFactory<? extends Credentials> ehrSessionFactory(FhirContext fhirContext, AccessTokenProvider tokenProvider, FhirEndpointsProvider fhirEndpointsProvider, String fhirServicesUrl, String clientId, Credentials credentials, String scope) {
        Scopes scopes = new Scopes();
        scopes.add((Scope)new SimpleScope(scope));
        return new ClientCredentialsSessionFactory(fhirContext, tokenProvider, fhirEndpointsProvider, fhirServicesUrl, clientId, credentials, scopes);
    }

    private JWKSet jwkSet(String jsonWebKeySetLocation, Integer httpConnectionTimeOut, Integer httpReadTimeOut, Integer jsonWebKeySetSizeLimitBytes) {
        JWKSet jwks;
        block15: {
            jwks = null;
            try {
                if (this.isUrl(jsonWebKeySetLocation)) {
                    URL url = new URL(jsonWebKeySetLocation);
                    jwks = JWKSet.load((URL)url, (int)httpConnectionTimeOut, (int)httpReadTimeOut, (int)jsonWebKeySetSizeLimitBytes);
                    break block15;
                }
                ClassPathResource cpr = new ClassPathResource(jsonWebKeySetLocation);
                File tempFile = File.createTempFile("jwkSet", ".tmp");
                tempFile.deleteOnExit();
                try (FileOutputStream out = new FileOutputStream(tempFile);){
                    IOUtils.copy((InputStream)cpr.getInputStream(), (OutputStream)out);
                }
                jwks = JWKSet.load((File)tempFile);
            }
            catch (IOException | ParseException e) {
                throw new RuntimeException(e);
            }
        }
        return jwks;
    }

    private JWTCredentials jwtCredentials(JWKSet jwkSet, String clientId, String audience, Long jsonTokenDuration) {
        try {
            RSAKey rsaKey = (RSAKey)jwkSet.getKeys().get(0);
            JWTCredentials credentials = new JWTCredentials(rsaKey.toRSAPrivateKey());
            credentials.setIssuer(clientId);
            credentials.setSubject(clientId);
            credentials.setAudience(audience);
            credentials.setTokenReference(UUID.randomUUID().toString());
            credentials.setDuration(jsonTokenDuration);
            return credentials;
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    @Bean
    public UserService ldapUserService() throws NamingException {
        Hashtable<String, String> contextEnv = new Hashtable<String, String>(5);
        contextEnv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        contextEnv.put("java.naming.provider.url", this.env.getProperty("ldap.server"));
        contextEnv.put("java.naming.security.authentication", "simple");
        contextEnv.put("java.naming.security.principal", this.env.getProperty("ldap.userDn"));
        contextEnv.put("java.naming.security.credentials", this.env.getProperty("ldap.password"));
        InitialDirContext ctx = new InitialDirContext(contextEnv);
        UserService userService = new UserService((DirContext)ctx);
        return userService;
    }

    private boolean isUrl(String location) {
        String[] schemes = new String[]{"http", "https"};
        UrlValidator urlValidator = new UrlValidator(schemes);
        return urlValidator.isValid(location);
    }
}

