/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.platform.messaging.converter;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IResource;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;

public class HapiJsonHttpMessageConverter
extends AbstractHttpMessageConverter<Object>
implements GenericHttpMessageConverter<Object> {
    private static final FhirContext FHIR_CONTEXT = FhirContext.forDstu2();
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return this.canRead(clazz, null, mediaType);
    }

    public boolean canRead(Type type, Class<?> contextClass, MediaType mediaType) {
        boolean canRead = true;
        if (mediaType != null) {
            canRead = mediaType.isCompatibleWith(MediaType.APPLICATION_JSON);
        }
        return canRead;
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        boolean canWrite = true;
        if (mediaType != null) {
            canWrite = mediaType.isCompatibleWith(MediaType.APPLICATION_JSON);
        }
        return canWrite;
    }

    public boolean canWrite(Type type, Class<?> aClass, MediaType mediaType) {
        return this.canWrite(aClass, mediaType);
    }

    protected boolean supports(Class<?> clazz) {
        throw new UnsupportedOperationException();
    }

    protected Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        String stringBody = IOUtils.toString((InputStream)inputMessage.getBody(), (Charset)DEFAULT_CHARSET);
        return (IResource)FHIR_CONTEXT.newJsonParser().parseResource(stringBody);
    }

    public Object read(Type type, Class<?> contextClass, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        String stringBody = IOUtils.toString((InputStream)inputMessage.getBody(), (Charset)DEFAULT_CHARSET);
        return (IResource)FHIR_CONTEXT.newJsonParser().parseResource(stringBody);
    }

    public void write(Object o, Type type, MediaType mediaType, HttpOutputMessage httpOutputMessage) throws IOException, HttpMessageNotWritableException {
        this.writeInternal(o, httpOutputMessage);
    }

    protected void writeInternal(Object object, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        if (object != null) {
            try {
                String json = FHIR_CONTEXT.newJsonParser().encodeResourceToString((IBaseResource)object);
                outputMessage.getBody().write(json.getBytes(DEFAULT_CHARSET));
            }
            catch (ClassCastException e) {
                throw new HttpMessageNotWritableException(e.getMessage(), (Throwable)e);
            }
        } else {
            outputMessage.getBody().close();
        }
    }

    protected MediaType getDefaultContentType(Object object) throws IOException {
        return MediaType.APPLICATION_JSON;
    }

    protected Long getContentLength(Object object, MediaType contentType) throws IOException {
        return null;
    }
}

