/*
 * Decompiled with CFR 0.152.
 */
package org.hspconsortium.platform.messaging.service.ldap;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.TimeLimitExceededException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.hspconsortium.platform.messaging.model.ldap.DirectoryType;
import org.hspconsortium.platform.messaging.model.ldap.User;
import org.hspconsortium.platform.messaging.model.ldap.annotations.Attribute;

public class UserService {
    private DirContext ldapContext;
    private DirectoryType directoryType = DirectoryType.NORMAL;

    public UserService(DirContext context) {
        this.ldapContext = context;
    }

    public void setDirectoryType(DirectoryType directoryType) {
        this.directoryType = directoryType;
    }

    public Iterable<User> findAll(String base) {
        ArrayList<User> resultList = new ArrayList<User>();
        SearchControls searchControl = new SearchControls();
        String filter = "(&(objectClass=inetOrgPerson))";
        try {
            NamingEnumeration<SearchResult> resultNamingEnumeration = this.ldapContext.search(base, filter, searchControl);
            while (resultNamingEnumeration.hasMore()) {
                SearchResult entry = resultNamingEnumeration.next();
                resultList.add(this.toUser(entry));
            }
        }
        catch (TimeLimitExceededException te) {
            return resultList;
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        return resultList;
    }

    public User findUser(Attributes matchAttributes, String ldapBase) {
        try {
            NamingEnumeration<SearchResult> answer;
            if (ldapBase == null) {
                ldapBase = "";
            }
            if ((answer = this.ldapContext.search(ldapBase, matchAttributes)) != null && answer.hasMore()) {
                SearchResult entry = answer.next();
                return this.toUser(entry);
            }
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private User toUser(SearchResult entry) {
        User user = new User(entry.getName());
        Field[] fields = user.getClass().getDeclaredFields();
        Attributes attributes = entry.getAttributes();
        for (Field field : fields) {
            String localAttributeName;
            Attribute attribute = field.getAnnotation(Attribute.class);
            if (attribute == null || (localAttributeName = attribute.name()).isEmpty()) continue;
            javax.naming.directory.Attribute ldapAttribute = attributes.get(localAttributeName);
            PropertyDescriptor pd = null;
            if (ldapAttribute == null) continue;
            try {
                pd = new PropertyDescriptor(field.getName(), user.getClass());
                pd.getWriteMethod().invoke((Object)user, ldapAttribute.get());
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException(String.format("%s needs getter/setter (%s) for annotated (attribute=%s) field %s", user.getClass().getCanonicalName(), pd.getWriteMethod().getName(), ldapAttribute.get(), field.getName()));
                }
                catch (NamingException e1) {
                    throw new RuntimeException(e1);
                }
            }
        }
        return user;
    }

    public User updateUser(User user) {
        try {
            Field[] fields;
            ArrayList<ModificationItem> modificationItemList = new ArrayList<ModificationItem>();
            Attributes attributes = this.ldapContext.getAttributes(user.getLdapEntityName());
            for (Field field : fields = user.getClass().getDeclaredFields()) {
                Attribute fieldAttribute = field.getAnnotation(Attribute.class);
                if (fieldAttribute == null) continue;
                javax.naming.directory.Attribute ldapAttribute = attributes.get(fieldAttribute.name());
                PropertyDescriptor pd = null;
                if (ldapAttribute == null) continue;
                try {
                    pd = new PropertyDescriptor(field.getName(), user.getClass());
                    Object fieldValue = pd.getReadMethod().invoke((Object)user, new Object[0]);
                    if (fieldValue.equals(ldapAttribute.get())) continue;
                    modificationItemList.add(new ModificationItem(2, new BasicAttribute(ldapAttribute.getID(), fieldValue)));
                }
                catch (Exception e) {
                    try {
                        throw new RuntimeException(String.format("%s needs getter/setter (%s) for annotated (attribute = %s) field %s", user.getClass().getCanonicalName(), pd.getReadMethod().getName(), ldapAttribute.get(), field.getName()));
                    }
                    catch (NamingException e1) {
                        throw new RuntimeException(e);
                    }
                }
            }
            if (modificationItemList.size() > 0) {
                this.ldapContext.modifyAttributes(user.getLdapEntityName(), modificationItemList.toArray(new ModificationItem[0]));
            }
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        return user;
    }

    public Iterable<User> searchByDistinctName(LdapName dn) {
        BasicAttributes matchAttributes = new BasicAttributes(true);
        ArrayList<User> resultList = new ArrayList<User>();
        try {
            List<Rdn> contextRdns = new LdapName(this.ldapContext.getNameInNamespace()).getRdns();
            if (dn.startsWith(contextRdns)) {
                Object remove = dn.remove(contextRdns.size());
                dn = new LdapName(remove.toString());
            }
            Iterator<Rdn> attIterator = dn.getRdns().iterator();
            while (attIterator.hasNext()) {
                Attributes attributes = attIterator.next().toAttributes();
                NamingEnumeration<String> ids = attributes.getIDs();
                while (ids.hasMore()) {
                    matchAttributes.put(attributes.get(ids.next()));
                }
            }
            NamingEnumeration<SearchResult> resultNamingEnumeration = this.ldapContext.search("", (Attributes)matchAttributes);
            while (resultNamingEnumeration.hasMore()) {
                SearchResult entry = resultNamingEnumeration.next();
                resultList.add(this.toUser(entry));
            }
        }
        catch (TimeLimitExceededException te) {
            return resultList;
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        return resultList;
    }
}

