/*
 * Decompiled with CFR 0.152.
 */
package org.htmlparser.lexerapplications.thumbelina;

import java.awt.Canvas;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.htmlparser.lexerapplications.thumbelina.Picture;
import org.htmlparser.lexerapplications.thumbelina.Tile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TileSet
extends Canvas
implements ActionListener,
MouseListener,
WindowListener {
    protected ArrayList<Tile> mRegions = new ArrayList();
    static final Color[] mColours = new Color[]{Color.blue, Color.cyan, Color.gray, Color.green, Color.orange, Color.pink, Color.red, Color.yellow, Color.lightGray, Color.darkGray};
    Point origin;
    Rectangle last;

    public int getTileCount() {
        return this.mRegions.size();
    }

    public Iterator<Tile> getTiles() {
        return this.mRegions.iterator();
    }

    public void add(Tile tile) {
        Rectangle r;
        ArrayList<Tile> regions = new ArrayList<Tile>();
        HashMap<Object, ArrayList<Tile>> table = new HashMap<Object, ArrayList<Tile>>();
        Rectangle rectangle = tile.getBounds();
        for (Tile rover : this.mRegions) {
            ArrayList<Tile> siblings;
            if (!rover.getValid()) continue;
            r = rover.getBounds();
            if (r.intersects(rectangle)) {
                Rectangle intersection = r.intersection(rectangle);
                if (!intersection.equals(rover)) {
                    ArrayList<Tile> splits = this.split(tile, rover, false);
                    siblings = (ArrayList<Tile>)table.get(rover.getIdentity());
                    if (null == siblings) {
                        siblings = new ArrayList<Tile>();
                        table.put(rover.getIdentity(), siblings);
                    }
                    for (int i = 0; i < splits.size(); ++i) {
                        rover = splits.get(i);
                        regions.add(rover);
                        siblings.add(rover);
                    }
                    continue;
                }
                rover.setValid(false);
                continue;
            }
            regions.add(rover);
            siblings = (ArrayList<Tile>)table.get(rover.getIdentity());
            if (null == siblings) {
                siblings = new ArrayList<Tile>();
                table.put(rover.getIdentity(), siblings);
            }
            siblings.add(rover);
        }
        regions.add(tile);
        for (ArrayList siblings : table.values()) {
            for (int i = 0; i < siblings.size(); ++i) {
                Tile rover = (Tile)siblings.get(i);
                r = rover.getBounds();
                for (int j = i; j < siblings.size(); ++j) {
                    Tile test = (Tile)siblings.get(j);
                    rectangle = test.getBounds();
                    if (r.x == rectangle.x && r.width == rectangle.width) {
                        if (r.y == rectangle.y + rectangle.height) {
                            r.y = rectangle.y;
                            r.height += rectangle.height;
                            regions.remove(test);
                            siblings.remove(test);
                            --j;
                            continue;
                        }
                        if (rectangle.y != r.y + r.height) continue;
                        r.height += rectangle.height;
                        regions.remove(test);
                        siblings.remove(test);
                        --j;
                        continue;
                    }
                    if (r.y != rectangle.y || r.height != rectangle.height) continue;
                    if (r.x == rectangle.x + rectangle.width) {
                        r.x = rectangle.x;
                        r.width += rectangle.width;
                        regions.remove(test);
                        siblings.remove(test);
                        --j;
                        continue;
                    }
                    if (rectangle.x != r.x + r.width) continue;
                    r.width += rectangle.width;
                    regions.remove(test);
                    siblings.remove(test);
                    --j;
                }
                rover.setBounds(r);
            }
        }
        this.mRegions = regions;
    }

    private ArrayList<Tile> split(Tile small, Tile large, boolean keep) {
        Rectangle rs;
        ArrayList<Tile> ret = new ArrayList<Tile>();
        Rectangle rl = large.getBounds();
        if (rl.intersects(rs = small.getBounds())) {
            Rectangle rectangle;
            Tile m;
            Rectangle intersection = rl.intersection(rs);
            if (intersection.y + intersection.height != rl.y + rl.height) {
                m = (Tile)large.clone();
                rectangle = m.getBounds();
                rectangle.y = intersection.y + intersection.height;
                rectangle.height = rl.y + rl.height - rectangle.y;
                m.setBounds(rectangle);
                ret.add(m);
            }
            if (intersection.x != rl.x) {
                m = (Tile)large.clone();
                rectangle = m.getBounds();
                rectangle.y = intersection.y;
                rectangle.width = intersection.x - rl.x;
                rectangle.height = intersection.height;
                m.setBounds(rectangle);
                ret.add(m);
            }
            if (keep) {
                m = (Tile)large.clone();
                rectangle = m.getBounds();
                rectangle.x = intersection.x;
                rectangle.y = intersection.y;
                rectangle.width = intersection.width;
                rectangle.height = intersection.height;
                m.setBounds(rectangle);
                ret.add(m);
            }
            if (intersection.x + intersection.width != rl.x + rl.width) {
                m = (Tile)large.clone();
                rectangle = m.getBounds();
                rectangle.x = intersection.x + intersection.width;
                rectangle.y = intersection.y;
                rectangle.width = rl.x + rl.width - rectangle.x;
                rectangle.height = intersection.height;
                m.setBounds(rectangle);
                ret.add(m);
            }
            if (intersection.y != rl.y) {
                m = (Tile)large.clone();
                rectangle = m.getBounds();
                rectangle.height = intersection.y - rl.y;
                m.setBounds(rectangle);
                ret.add(m);
            }
        }
        return ret;
    }

    public Tile tileAt(int x, int y) {
        Tile ret = null;
        for (Tile m : this.mRegions) {
            if (!m.getBounds().contains(x, y)) continue;
            ret = m;
            break;
        }
        return ret;
    }

    public void bringToTop(Tile tile) {
        Iterator<Tile> iterator = this.mRegions.iterator();
        while (iterator.hasNext()) {
            Tile m = iterator.next();
            if (!tile.getIdentity().equals(m.getIdentity())) continue;
            iterator.remove();
        }
        tile.reset();
        this.add(tile);
    }

    public void setStatus(String text) {
        Container container = this.getParent();
        Component[] children = container.getComponents();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof TextField)) continue;
            ((TextField)children[i]).setText(text);
            break;
        }
    }

    public boolean isVerbose() {
        boolean ret = false;
        Container container = this.getParent();
        Frame frame = (Frame)container;
        MenuBar menubar = frame.getMenuBar();
        Menu menu = menubar.getMenu(0);
        for (int i = 0; i < menu.getItemCount(); ++i) {
            if (!(menu.getItem(i) instanceof CheckboxMenuItem)) continue;
            ret = ((CheckboxMenuItem)menu.getItem(i)).getState();
            break;
        }
        return ret;
    }

    void addTile(Rectangle rectangle) {
        try {
            int count = Integer.parseInt(this.getName());
            Picture m = new Picture(new URL("http://localhost/image#" + count), null, rectangle);
            this.add(m);
            this.repaint();
            this.setStatus("" + this.getTileCount());
            this.setName("" + ++count);
        }
        catch (MalformedURLException murle) {
            murle.printStackTrace();
        }
    }

    void checkOverlap(Graphics graphics) {
        graphics.setColor(Color.magenta);
        for (int i = 0; i < this.mRegions.size(); ++i) {
            Tile m = this.mRegions.get(i);
            Rectangle rectangle = m.getBounds();
            for (int j = i + 1; j < this.mRegions.size(); ++j) {
                Tile _m = this.mRegions.get(j);
                Rectangle r = _m.getBounds();
                if (!rectangle.intersects(r)) continue;
                r = rectangle.intersection(r);
                System.out.println("overlap (" + r.x + "," + r.y + ") (" + (r.x + r.width) + "," + (r.y + r.height) + ")");
                graphics.fillRect(r.x, r.y, r.width + 1, r.height + 1);
            }
        }
    }

    void lift(int x, int y) {
        Tile m = this.tileAt(x, y);
        if (null != m) {
            this.bringToTop(m);
            this.repaint();
            this.setStatus("" + this.getTileCount());
        }
    }

    String getDetails(int x, int y) {
        String ret = null;
        Tile m = this.tileAt(x, y);
        ret = null == m ? "" : m.toString();
        return ret;
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension size = this.getSize();
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, size.width + 1, size.height + 1);
        if (0 == this.mRegions.size()) {
            graphics.setColor(this.getForeground());
            graphics.drawString("Click and drag to create a tile.", 10, 20);
            graphics.drawString("Right click a tile for details.", 10, 40);
            graphics.drawString("Shift right click a tile to bring to top.", 10, 60);
        } else {
            for (Tile tile : this.mRegions) {
                String url = ((URL)tile.getIdentity()).toString();
                int n = url.indexOf(35);
                n = Integer.parseInt(url.substring(n + 1));
                Color colour = mColours[n % mColours.length];
                graphics.setColor(colour);
                Rectangle m = tile.getBounds();
                graphics.fillRect(m.x, m.y, m.width + 1, m.height + 1);
                graphics.setColor(Color.black);
                graphics.drawRect(m.x, m.y, m.width, m.height);
            }
            this.checkOverlap(graphics);
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        System.exit(0);
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        MenuItem item = (MenuItem)event.getSource();
        if (item.getName().equals("repeat")) {
            this.addTile(this.last);
        } else if (item.getName().equals("clear")) {
            this.mRegions = new ArrayList();
            this.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (this.isVerbose()) {
            System.out.println("DrawTarget.mouseClicked " + event);
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (this.isVerbose()) {
            System.out.println("DrawTarget.mouseReleased " + event);
        }
        if (null != this.origin) {
            this.last = new Rectangle(Math.min(this.origin.x, event.getX()), Math.min(this.origin.y, event.getY()), Math.abs(event.getX() - this.origin.x), Math.abs(event.getY() - this.origin.y));
            this.addTile(this.last);
            this.origin = null;
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        if (this.isVerbose()) {
            System.out.println("DrawTarget.mouseEntered " + event);
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
        if (this.isVerbose()) {
            System.out.println("DrawTarget.mouseExited " + event);
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (this.isVerbose()) {
            System.out.println("DrawTarget.mousePressed " + event);
        }
        if (event.isShiftDown() && event.isMetaDown()) {
            this.lift(event.getX(), event.getY());
        } else if (event.isMetaDown()) {
            this.setStatus(this.getDetails(event.getX(), event.getY()));
        } else {
            this.origin = new Point(event.getX(), event.getY());
        }
    }

    public static void main(String[] args) {
        Frame frame = new Frame();
        frame.setSize(400, 400);
        MenuBar menuMain = new MenuBar();
        Menu options = new Menu("Options");
        CheckboxMenuItem verbose = new CheckboxMenuItem("Verbose");
        options.add(verbose);
        MenuItem repeat = new MenuItem("Repeat");
        repeat.setName("repeat");
        options.add(repeat);
        MenuItem clear = new MenuItem("Clear");
        clear.setName("clear");
        options.add(clear);
        menuMain.add(options);
        frame.setMenuBar(menuMain);
        TileSet buffy = new TileSet();
        buffy.setBackground(Color.lightGray.brighter());
        buffy.setVisible(true);
        buffy.setName("0");
        frame.add((Component)buffy, "Center");
        TextField status = new TextField();
        frame.add((Component)status, "South");
        frame.addWindowListener(buffy);
        buffy.addMouseListener(buffy);
        repeat.addActionListener(buffy);
        clear.addActionListener(buffy);
        frame.setVisible(true);
    }
}

