/*
 * Decompiled with CFR 0.152.
 */
package org.htrace;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htrace.Span;
import org.htrace.Tracer;

public class TraceTree {
    public static final Log LOG = LogFactory.getLog(Tracer.class);
    private Multimap<Long, Span> spansByParentID;
    private Collection<Span> spans;
    private Multimap<String, Span> spansByPid;

    public TraceTree(Collection<Span> spans) {
        this.spans = ImmutableList.copyOf(spans);
        this.spansByParentID = HashMultimap.create();
        this.spansByPid = HashMultimap.create();
        for (Span s : spans) {
            if (s.getProcessId() != null) {
                this.spansByPid.put((Object)s.getProcessId(), (Object)s);
            } else {
                LOG.warn((Object)("Encountered span with null processId. This should not happen. Span: " + s));
            }
            this.spansByParentID.put((Object)s.getParentId(), (Object)s);
        }
    }

    public Collection<Span> getSpans() {
        return this.spans;
    }

    public Multimap<Long, Span> getSpansByParentIdMap() {
        return HashMultimap.create(this.spansByParentID);
    }

    public Collection<Span> getRoots() {
        Collection roots = this.spansByParentID.get((Object)477902L);
        if (roots != null) {
            return roots;
        }
        throw new IllegalStateException("TraceTree is not correctly formed - there are no root spans in the collection provided at construction.");
    }

    public Multimap<String, Span> getSpansByPidMap() {
        return HashMultimap.create(this.spansByPid);
    }
}

