/*
 * Decompiled with CFR 0.152.
 */
package org.htrace.impl;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htrace.HTraceConfiguration;
import org.htrace.Span;
import org.htrace.SpanReceiver;
import org.mortbay.util.ajax.JSON;

public class LocalFileSpanReceiver
implements SpanReceiver {
    public static final int DEFAULT_CAPACITY = 5000;
    public static final long DEFAULT_EXECUTOR_TERMINATION_TIMEOUT_DURATION = 60L;
    public static final Log LOG = LogFactory.getLog(LocalFileSpanReceiver.class);
    private String file;
    private FileWriter fwriter;
    private BufferedWriter bwriter;
    private Map<String, Object> values;
    private ExecutorService executor;
    private long executorTerminationTimeoutDuration;

    @Override
    public void configure(HTraceConfiguration conf) {
        this.executorTerminationTimeoutDuration = 60L;
        int capacity = conf.getInt("local-file-span-receiver.capacity", 5000);
        this.file = conf.get("local-file-span-receiver.path");
        if (this.file == null || this.file.isEmpty()) {
            throw new IllegalArgumentException("must configure " + this.file);
        }
        this.executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(capacity));
        try {
            this.fwriter = new FileWriter(this.file, true);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.bwriter = new BufferedWriter(this.fwriter);
        this.values = new HashMap<String, Object>();
    }

    @Override
    public void receiveSpan(Span span) {
        this.executor.submit(new WriteSpanRunnable(span));
    }

    @Override
    public void close() throws IOException {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(this.executorTerminationTimeoutDuration, TimeUnit.SECONDS)) {
                LOG.warn((Object)("Was not able to process all remaining spans to write upon closing in: " + this.executorTerminationTimeoutDuration + "s"));
            }
        }
        catch (InterruptedException e1) {
            LOG.warn((Object)"Thread interrupted when terminating executor.", (Throwable)e1);
        }
        try {
            this.fwriter.close();
        }
        catch (IOException e) {
            LOG.error((Object)("Error closing filewriter for file: " + this.file), (Throwable)e);
        }
        try {
            this.bwriter.close();
        }
        catch (IOException e) {
            LOG.error((Object)("Error closing bufferedwriter for file: " + this.file), (Throwable)e);
        }
    }

    private class WriteSpanRunnable
    implements Runnable {
        public final Span span;

        public WriteSpanRunnable(Span span) {
            this.span = span;
        }

        @Override
        public void run() {
            try {
                LocalFileSpanReceiver.this.values.put("SpanID", this.span.getSpanId());
                LocalFileSpanReceiver.this.values.put("TraceID", this.span.getTraceId());
                LocalFileSpanReceiver.this.values.put("ParentID", this.span.getParentId());
                LocalFileSpanReceiver.this.values.put("Start", this.span.getStartTimeMillis());
                LocalFileSpanReceiver.this.values.put("Stop", this.span.getStopTimeMillis());
                LocalFileSpanReceiver.this.values.put("Description", this.span.getDescription());
                LocalFileSpanReceiver.this.values.put("Annotations", this.span.getKVAnnotations());
                LocalFileSpanReceiver.this.bwriter.write(JSON.toString((Map)LocalFileSpanReceiver.this.values));
                LocalFileSpanReceiver.this.bwriter.flush();
                LocalFileSpanReceiver.this.values.clear();
            }
            catch (IOException e) {
                LOG.error((Object)("Error when writing to file: " + LocalFileSpanReceiver.this.file), (Throwable)e);
            }
        }
    }
}

