/*
 * Decompiled with CFR 0.152.
 */
package org.htrace.zipkin;

import com.twitter.zipkin.gen.Annotation;
import com.twitter.zipkin.gen.AnnotationType;
import com.twitter.zipkin.gen.BinaryAnnotation;
import com.twitter.zipkin.gen.Endpoint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.htrace.Span;
import org.htrace.TimelineAnnotation;

public class HTraceToZipkinConverter {
    private final int ipv4Address;
    private final short port;
    private static final Map<String, Integer> DEFAULT_PORTS = new HashMap<String, Integer>();

    public HTraceToZipkinConverter(int ipv4Address, short port) {
        this.ipv4Address = ipv4Address;
        this.port = port;
    }

    public com.twitter.zipkin.gen.Span convert(Span hTraceSpan) {
        com.twitter.zipkin.gen.Span zipkinSpan = new com.twitter.zipkin.gen.Span();
        String serviceName = hTraceSpan.getProcessId().toLowerCase();
        Endpoint ep = new Endpoint(this.ipv4Address, (short)this.getPort(serviceName), serviceName);
        List<Annotation> annotationList = this.createZipkinAnnotations(hTraceSpan, ep);
        List<BinaryAnnotation> binaryAnnotationList = this.createZipkinBinaryAnnotations(hTraceSpan, ep);
        zipkinSpan.setTrace_id(hTraceSpan.getTraceId());
        if (hTraceSpan.getParentId() != 477902L) {
            zipkinSpan.setParent_id(hTraceSpan.getParentId());
        }
        zipkinSpan.setId(hTraceSpan.getSpanId());
        zipkinSpan.setName(hTraceSpan.getDescription());
        zipkinSpan.setAnnotations(annotationList);
        zipkinSpan.setBinary_annotations(binaryAnnotationList);
        return zipkinSpan;
    }

    private List<Annotation> createZipkinAnnotations(Span hTraceSpan, Endpoint ep) {
        ArrayList<Annotation> annotationList = new ArrayList<Annotation>();
        annotationList.add(HTraceToZipkinConverter.createZipkinAnnotation("cs", hTraceSpan.getStartTimeMillis(), ep, true));
        annotationList.add(HTraceToZipkinConverter.createZipkinAnnotation("sr", hTraceSpan.getStartTimeMillis(), ep, true));
        for (TimelineAnnotation ta : hTraceSpan.getTimelineAnnotations()) {
            annotationList.add(HTraceToZipkinConverter.createZipkinAnnotation(ta.getMessage(), ta.getTime(), ep, true));
        }
        annotationList.add(HTraceToZipkinConverter.createZipkinAnnotation("ss", hTraceSpan.getStopTimeMillis(), ep, false));
        annotationList.add(HTraceToZipkinConverter.createZipkinAnnotation("cr", hTraceSpan.getStopTimeMillis(), ep, false));
        return annotationList;
    }

    private List<BinaryAnnotation> createZipkinBinaryAnnotations(Span span, Endpoint ep) {
        ArrayList<BinaryAnnotation> l = new ArrayList<BinaryAnnotation>();
        for (Map.Entry e : span.getKVAnnotations().entrySet()) {
            BinaryAnnotation binaryAnn = new BinaryAnnotation();
            binaryAnn.setAnnotation_type(AnnotationType.BYTES);
            binaryAnn.setKey(new String((byte[])e.getKey()));
            binaryAnn.setValue((byte[])e.getValue());
            binaryAnn.setHost(ep);
            l.add(binaryAnn);
        }
        return l;
    }

    private static Annotation createZipkinAnnotation(String value, long time, Endpoint ep, boolean sendRequest) {
        Annotation annotation = new Annotation();
        annotation.setHost(ep);
        if (sendRequest) {
            annotation.setTimestamp(time * 1000L);
        } else {
            annotation.setTimestamp(time * 1000L);
        }
        annotation.setDuration(1);
        annotation.setValue(value);
        return annotation;
    }

    private int getPort(String serviceName) {
        if (this.port != -1) {
            return this.port;
        }
        Integer p = DEFAULT_PORTS.get(serviceName);
        if (p != null) {
            return p;
        }
        return 80;
    }

    static {
        DEFAULT_PORTS.put("hmaster", 60000);
        DEFAULT_PORTS.put("hregionserver", 60020);
        DEFAULT_PORTS.put("namenode", 8020);
        DEFAULT_PORTS.put("datanode", 50010);
    }
}

