/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.ai.llm.model;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.ai.llm.model.Message;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import se.ansman.kotshi.InternalKotshiApi;
import se.ansman.kotshi.NamedJsonAdapter;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0016"}, d2={"Lorg/http4k/ai/llm/model/KotshiMessageJsonAdapter;", "Lse/ansman/kotshi/NamedJsonAdapter;", "Lorg/http4k/ai/llm/model/Message;", "moshi", "Lcom/squareup/moshi/Moshi;", "<init>", "(Lcom/squareup/moshi/Moshi;)V", "labelKeyOptions", "Lcom/squareup/moshi/JsonReader$Options;", "options", "adapters", "", "Lcom/squareup/moshi/JsonAdapter;", "[Lcom/squareup/moshi/JsonAdapter;", "toJson", "", "writer", "Lcom/squareup/moshi/JsonWriter;", "value", "fromJson", "reader", "Lcom/squareup/moshi/JsonReader;", "http4k-ai-llm-core"})
@InternalKotshiApi
public final class KotshiMessageJsonAdapter
extends NamedJsonAdapter<Message> {
    @NotNull
    private final JsonReader.Options labelKeyOptions;
    @NotNull
    private final JsonReader.Options options;
    @NotNull
    private final JsonAdapter<Message>[] adapters;

    public KotshiMessageJsonAdapter(@NotNull Moshi moshi) {
        Intrinsics.checkNotNullParameter((Object)moshi, (String)"moshi");
        super("KotshiJsonAdapter(Message)");
        String[] stringArray = new String[]{"type"};
        JsonReader.Options options = JsonReader.Options.of((String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)options, (String)"of(...)");
        this.labelKeyOptions = options;
        stringArray = new String[]{"assistant", "custom", "system", "tool", "user"};
        JsonReader.Options options2 = JsonReader.Options.of((String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)options2, (String)"of(...)");
        this.options = options2;
        JsonAdapter[] jsonAdapterArray = new JsonAdapter[5];
        Intrinsics.checkNotNullExpressionValue((Object)moshi.adapter((Type)((Object)Message.Assistant.class)), (String)"adapter(...)");
        Intrinsics.checkNotNullExpressionValue((Object)moshi.adapter((Type)((Object)Message.Custom.class)), (String)"adapter(...)");
        Intrinsics.checkNotNullExpressionValue((Object)moshi.adapter((Type)((Object)Message.System.class)), (String)"adapter(...)");
        Intrinsics.checkNotNullExpressionValue((Object)moshi.adapter((Type)((Object)Message.ToolResult.class)), (String)"adapter(...)");
        Intrinsics.checkNotNullExpressionValue((Object)moshi.adapter((Type)((Object)Message.User.class)), (String)"adapter(...)");
        this.adapters = jsonAdapterArray;
    }

    public void toJson(@NotNull JsonWriter writer, @Nullable Message value) throws IOException {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        if (value == null) {
            writer.nullValue();
        } else {
            JsonAdapter<Message> jsonAdapter;
            Message message = value;
            if (message instanceof Message.Assistant) {
                jsonAdapter = this.adapters[0];
            } else if (message instanceof Message.Custom) {
                jsonAdapter = this.adapters[1];
            } else if (message instanceof Message.System) {
                jsonAdapter = this.adapters[2];
            } else if (message instanceof Message.ToolResult) {
                jsonAdapter = this.adapters[3];
            } else if (message instanceof Message.User) {
                jsonAdapter = this.adapters[4];
            } else {
                throw new NoWhenBranchMatchedException();
            }
            JsonAdapter<Message> adapter = jsonAdapter;
            adapter.toJson(writer, (Object)value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Message fromJson(@NotNull JsonReader reader) throws IOException {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        if (reader.peek() == JsonReader.Token.NULL) {
            return (Message)reader.nextNull();
        }
        Closeable closeable = (Closeable)reader.peekJson();
        Throwable throwable = null;
        try {
            JsonReader peek = (JsonReader)closeable;
            boolean bl = false;
            peek.setFailOnUnknown(false);
            peek.beginObject();
            while (peek.hasNext()) {
                if (peek.selectName(this.labelKeyOptions) == -1) {
                    peek.skipName();
                    peek.skipValue();
                    continue;
                }
                int labelIndex = peek.selectString(this.options);
                if (labelIndex == -1) {
                    throw new JsonDataException("Expected one of [assistant, custom, system, tool, user] for key 'type' but found " + peek.nextString());
                }
                JsonAdapter<Message> adapter = this.adapters[labelIndex];
                Message message = (Message)adapter.fromJson(reader);
                return message;
            }
            try {
                throw new JsonDataException("Missing label for type");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

