/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.ai.llm.memory;

import dev.forkhandles.result4k.Failure;
import dev.forkhandles.result4k.Result;
import dev.forkhandles.result4k.Success;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.ai.llm.LLMError;
import org.http4k.ai.llm.memory.LLMMemory;
import org.http4k.ai.llm.memory.LLMMemoryId;
import org.http4k.ai.llm.model.Message;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u00a8\u0006\u0003"}, d2={"InMemory", "Lorg/http4k/ai/llm/memory/LLMMemory;", "Lorg/http4k/ai/llm/memory/LLMMemory$Companion;", "http4k-ai-llm-core"})
public final class InMemoryLLMMemoryKt {
    @NotNull
    public static final LLMMemory InMemory(@NotNull LLMMemory.Companion $this$InMemory) {
        Intrinsics.checkNotNullParameter((Object)$this$InMemory, (String)"<this>");
        return new LLMMemory(){
            private final Map<LLMMemoryId, List<Message>> memoryStore;
            {
                this.memoryStore = new LinkedHashMap<K, V>();
            }

            public Result<LLMMemoryId, LLMError> create(List<? extends Message> messages) {
                Intrinsics.checkNotNullParameter(messages, (String)"messages");
                return this.update((LLMMemoryId)LLMMemoryId.Companion.of(new UUID(0L, this.memoryStore.size())), messages);
            }

            public Result<List<Message>, LLMError.NotFound> read(LLMMemoryId memoryId) {
                Result result;
                Intrinsics.checkNotNullParameter((Object)((Object)memoryId), (String)"memoryId");
                List<Message> list = this.memoryStore.get((Object)((Object)memoryId));
                if (list != null) {
                    List<Message> it = list;
                    boolean bl = false;
                    result = (Result)new Success(it);
                } else {
                    result = (Result)new Failure((Object)LLMError.NotFound.INSTANCE);
                }
                return result;
            }

            public Result<LLMMemoryId, LLMError.NotFound> add(LLMMemoryId memoryId, List<? extends Message> messages) {
                Result result;
                Intrinsics.checkNotNullParameter((Object)((Object)memoryId), (String)"memoryId");
                Intrinsics.checkNotNullParameter(messages, (String)"messages");
                List<Message> list = this.memoryStore.get((Object)((Object)memoryId));
                if (list != null) {
                    List<Message> it = list;
                    boolean bl = false;
                    it.addAll((Collection<Message>)messages);
                    result = (Result)new Success((Object)((Object)memoryId));
                } else {
                    result = (Result)new Failure((Object)LLMError.NotFound.INSTANCE);
                }
                return result;
            }

            public Result<LLMMemoryId, LLMError> update(LLMMemoryId memoryId, List<? extends Message> messages) {
                Intrinsics.checkNotNullParameter((Object)((Object)memoryId), (String)"memoryId");
                Intrinsics.checkNotNullParameter(messages, (String)"messages");
                this.memoryStore.put(memoryId, CollectionsKt.toMutableList((Collection)messages));
                return (Result)new Success((Object)((Object)memoryId));
            }

            public Result<LLMMemoryId, LLMError.NotFound> delete(LLMMemoryId memoryId) {
                Result result;
                Intrinsics.checkNotNullParameter((Object)((Object)memoryId), (String)"memoryId");
                List<Message> list = this.memoryStore.get((Object)((Object)memoryId));
                if (list != null) {
                    List<Message> it = list;
                    boolean bl = false;
                    this.memoryStore.remove((Object)((Object)memoryId));
                    result = (Result)new Success((Object)((Object)memoryId));
                } else {
                    result = (Result)new Failure((Object)LLMError.NotFound.INSTANCE);
                }
                return result;
            }
        };
    }
}

