/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.ai.mcp.client.sse;

import dev.forkhandles.result4k.Failure;
import dev.forkhandles.result4k.NullablesKt;
import dev.forkhandles.result4k.Result;
import dev.forkhandles.result4k.Success;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.sequences.Sequence;
import org.http4k.ai.mcp.McpError;
import org.http4k.ai.mcp.client.AbstractMcpClient;
import org.http4k.ai.mcp.client.UtilKt;
import org.http4k.ai.mcp.model.McpEntity;
import org.http4k.ai.mcp.model.McpMessageId;
import org.http4k.ai.mcp.protocol.ClientCapabilities;
import org.http4k.ai.mcp.protocol.ProtocolVersion;
import org.http4k.ai.mcp.protocol.Version;
import org.http4k.ai.mcp.protocol.VersionedMcpEntity;
import org.http4k.ai.mcp.protocol.messages.ClientMessage;
import org.http4k.ai.mcp.protocol.messages.McpRpc;
import org.http4k.client.Http4kSseClient;
import org.http4k.client.JavaHttpClient;
import org.http4k.core.BodyMode;
import org.http4k.core.Filter;
import org.http4k.core.Http4kKt;
import org.http4k.core.HttpKt;
import org.http4k.core.HttpMessage;
import org.http4k.core.Request;
import org.http4k.core.Response;
import org.http4k.core.Uri;
import org.http4k.filter.ClientFilters;
import org.http4k.format.MoshiNode;
import org.http4k.lens.Header;
import org.http4k.lens.McpExtensionsKt;
import org.http4k.sse.SseMessage;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001Bp\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012'\b\u0002\u0010\b\u001a!\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\n\u0012\b\b\u0002\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\tj\u0002`\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0014J\u0010\u0010\u0018\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0014J.\u0010#\u001a\u0018\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020%0$j\b\u0012\u0004\u0012\u00020 `&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0014JV\u0010+\u001a\u0018\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020%0$j\b\u0012\u0004\u0012\u00020,`&2\u0006\u0010'\u001a\u00020(2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00132\u0006\u00100\u001a\u00020,2\u0016\u00101\u001a\u0012\u0012\b\u0012\u000602j\u0002`3\u0012\u0004\u0012\u0002040\tH\u0014J\b\u00105\u001a\u00020 H\u0016R-\u0010\b\u001a!\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\n\u0012\b\b\u0002\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\tj\u0002`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/http4k/ai/mcp/client/sse/SseMcpClient;", "Lorg/http4k/ai/mcp/client/AbstractMcpClient;", "name", "Lorg/http4k/ai/mcp/model/McpEntity;", "version", "Lorg/http4k/ai/mcp/protocol/Version;", "sseRequest", "Lorg/http4k/core/Request;", "http", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "request", "Lorg/http4k/core/Response;", "Lorg/http4k/core/HttpHandler;", "capabilities", "Lorg/http4k/ai/mcp/protocol/ClientCapabilities;", "protocolVersion", "Lorg/http4k/ai/mcp/protocol/ProtocolVersion;", "defaultTimeout", "Ljava/time/Duration;", "random", "Lkotlin/random/Random;", "<init>", "(Lorg/http4k/ai/mcp/model/McpEntity;Lorg/http4k/ai/mcp/protocol/Version;Lorg/http4k/core/Request;Lkotlin/jvm/functions/Function1;Lorg/http4k/ai/mcp/protocol/ClientCapabilities;Lorg/http4k/ai/mcp/protocol/ProtocolVersion;Ljava/time/Duration;Lkotlin/random/Random;)V", "endpoint", "Ljava/util/concurrent/atomic/AtomicReference;", "", "sseClient", "Lorg/http4k/client/Http4kSseClient;", "received", "Lkotlin/sequences/Sequence;", "Lorg/http4k/sse/SseMessage;", "", "it", "Lorg/http4k/sse/SseMessage$Event;", "notify", "Ldev/forkhandles/result4k/Result;", "Lorg/http4k/ai/mcp/McpError;", "Lorg/http4k/ai/mcp/McpResult;", "rpc", "Lorg/http4k/ai/mcp/protocol/messages/McpRpc;", "mcp", "Lorg/http4k/ai/mcp/protocol/messages/ClientMessage$Notification;", "sendMessage", "Lorg/http4k/ai/mcp/model/McpMessageId;", "message", "Lorg/http4k/ai/mcp/protocol/messages/ClientMessage;", "timeout", "messageId", "isComplete", "Lorg/http4k/format/MoshiNode;", "Lorg/http4k/ai/mcp/util/McpNodeType;", "", "close", "http4k-ai-mcp-client"})
@SourceDebugExtension(value={"SMAP\nSseMcpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SseMcpClient.kt\norg/http4k/ai/mcp/client/sse/SseMcpClient\n+ 2 result.kt\ndev/forkhandles/result4k/ResultKt\n*L\n1#1,105:1\n22#2,5:106\n*S KotlinDebug\n*F\n+ 1 SseMcpClient.kt\norg/http4k/ai/mcp/client/sse/SseMcpClient\n*L\n91#1:106,5\n*E\n"})
public final class SseMcpClient
extends AbstractMcpClient {
    @NotNull
    private final Function1<Request, Response> http;
    @NotNull
    private final AtomicReference<String> endpoint;
    @NotNull
    private final Http4kSseClient sseClient;

    public SseMcpClient(@NotNull McpEntity name, @NotNull Version version, @NotNull Request sseRequest, @NotNull Function1<? super Request, ? extends Response> http, @NotNull ClientCapabilities capabilities, @NotNull ProtocolVersion protocolVersion, @NotNull Duration defaultTimeout, @NotNull Random random) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)sseRequest, (String)"sseRequest");
        Intrinsics.checkNotNullParameter(http, (String)"http");
        Intrinsics.checkNotNullParameter((Object)capabilities, (String)"capabilities");
        Intrinsics.checkNotNullParameter((Object)protocolVersion, (String)"protocolVersion");
        Intrinsics.checkNotNullParameter((Object)defaultTimeout, (String)"defaultTimeout");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        super(new VersionedMcpEntity(name, version, null, 4, null), capabilities, protocolVersion, defaultTimeout, random);
        this.http = Http4kKt.then((Filter)ClientFilters.INSTANCE.SetHostFrom(sseRequest.getUri()), http);
        this.endpoint = new AtomicReference();
        Function1[] function1Array = new Function1[]{McpExtensionsKt.getMCP_PROTOCOL_VERSION((Header)Header.INSTANCE).of((Object)protocolVersion)};
        this.sseClient = new Http4kSseClient((Request)HttpKt.with((HttpMessage)((HttpMessage)sseRequest), (Function1[])function1Array), http, null, null, 12, null);
    }

    public /* synthetic */ SseMcpClient(McpEntity mcpEntity, Version version, Request request2, Function1 function1, ClientCapabilities clientCapabilities, ProtocolVersion protocolVersion, Duration duration, Random random, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            function1 = JavaHttpClient.create$default(null, null, (BodyMode)((BodyMode)BodyMode.Stream.INSTANCE), null, (int)11, null);
        }
        if ((n & 0x10) != 0) {
            clientCapabilities = ClientCapabilities.Companion.getAll();
        }
        if ((n & 0x20) != 0) {
            protocolVersion = ProtocolVersion.Companion.getLATEST_VERSION();
        }
        if ((n & 0x40) != 0) {
            Duration duration2 = Duration.ofSeconds(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            duration = duration2;
        }
        if ((n & 0x80) != 0) {
            random = (Random)Random.Default;
        }
        this(mcpEntity, version, request2, (Function1<? super Request, ? extends Response>)function1, clientCapabilities, protocolVersion, duration, random);
    }

    @Override
    @NotNull
    protected Sequence<SseMessage> received() {
        return this.sseClient.received();
    }

    @Override
    protected void endpoint(@NotNull SseMessage.Event it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this.endpoint.set(it.getData());
    }

    @Override
    @NotNull
    protected Result<Unit, McpError> notify(@NotNull McpRpc rpc, @NotNull ClientMessage.Notification mcp) {
        Intrinsics.checkNotNullParameter((Object)rpc, (String)"rpc");
        Intrinsics.checkNotNullParameter((Object)mcp, (String)"mcp");
        ClientMessage clientMessage = (ClientMessage)mcp;
        ProtocolVersion protocolVersion = this.getProtocolVersion();
        String string = this.endpoint.get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
        Response response = (Response)this.http.invoke((Object)UtilKt.toHttpRequest$default(clientMessage, protocolVersion, Uri.Companion.of(string), rpc, null, 8, null));
        return response.getStatus().getSuccessful() ? (Result)new Success((Object)Unit.INSTANCE) : (Result)new Failure((Object)new McpError.Http(response));
    }

    @Override
    @NotNull
    protected Result<McpMessageId, McpError> sendMessage(@NotNull McpRpc rpc, @NotNull ClientMessage message, @NotNull Duration timeout, @NotNull McpMessageId messageId, @NotNull Function1<? super MoshiNode, Boolean> isComplete) {
        Result result;
        Intrinsics.checkNotNullParameter((Object)rpc, (String)"rpc");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter(isComplete, (String)"isComplete");
        CountDownLatch latch = new CountDownLatch(message instanceof ClientMessage.Notification ? 0 : 1);
        ((Map)this.getRequests()).put(messageId, latch);
        if (this.getMessageQueues().get(messageId) == null) {
            ((Map)this.getMessageQueues()).put(messageId, new LinkedBlockingQueue());
        }
        ProtocolVersion protocolVersion = this.getProtocolVersion();
        String string = this.endpoint.get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
        Response response = (Response)this.http.invoke((Object)UtilKt.toHttpRequest(message, protocolVersion, Uri.Companion.of(string), rpc, messageId));
        if (response.getStatus().getSuccessful()) {
            Result result2;
            boolean $i$f$resultFrom = false;
            try {
                boolean bl = false;
                if (!latch.await(timeout.toMillis(), TimeUnit.MILLISECONDS)) {
                    throw new IllegalStateException("Timeout waiting for init".toString());
                }
                Success success = new Success((Object)messageId);
                result2 = (Result)new Success((Object)success);
            }
            catch (Exception x$iv) {
                result2 = (Result)new Failure((Object)x$iv);
            }
            Success success = (Success)NullablesKt.valueOrNull((Result)result2);
            result = success != null ? (Result)success : this.failWith((McpError)McpError.Timeout.INSTANCE, messageId);
        } else {
            result = this.failWith((McpError)new McpError.Http(response), messageId);
        }
        return result;
    }

    @Override
    public void close() {
        super.close();
        this.sseClient.close();
    }
}

