/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.ai.mcp.client.websocket;

import dev.forkhandles.result4k.Failure;
import dev.forkhandles.result4k.Result;
import dev.forkhandles.result4k.Success;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.http4k.ai.mcp.McpError;
import org.http4k.ai.mcp.client.AbstractMcpClient;
import org.http4k.ai.mcp.model.McpEntity;
import org.http4k.ai.mcp.model.McpMessageId;
import org.http4k.ai.mcp.protocol.ClientCapabilities;
import org.http4k.ai.mcp.protocol.ProtocolVersion;
import org.http4k.ai.mcp.protocol.Version;
import org.http4k.ai.mcp.protocol.VersionedMcpEntity;
import org.http4k.ai.mcp.protocol.messages.ClientMessage;
import org.http4k.ai.mcp.protocol.messages.McpRpc;
import org.http4k.ai.mcp.util.McpJson;
import org.http4k.core.HttpKt;
import org.http4k.core.HttpMessage;
import org.http4k.core.Request;
import org.http4k.format.Json;
import org.http4k.format.JsonRpcExtensionsKt;
import org.http4k.format.MoshiNode;
import org.http4k.lens.Header;
import org.http4k.lens.McpExtensionsKt;
import org.http4k.sse.SseMessage;
import org.http4k.websocket.WebsocketFactory;
import org.http4k.websocket.WsClient;
import org.http4k.websocket.WsMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B[\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0014J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0014J\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020 0$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0014JL\u0010)\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020,0*2\u0006\u0010%\u001a\u00020&2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00112\u0006\u00100\u001a\u00020+2\u0016\u00101\u001a\u0012\u0012\b\u0012\u000603j\u0002`4\u0012\u0004\u0012\u00020502H\u0014J\b\u00106\u001a\u00020 H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00067"}, d2={"Lorg/http4k/ai/mcp/client/websocket/WebsocketMcpClient;", "Lorg/http4k/ai/mcp/client/AbstractMcpClient;", "name", "Lorg/http4k/ai/mcp/model/McpEntity;", "version", "Lorg/http4k/ai/mcp/protocol/Version;", "wsRequest", "Lorg/http4k/core/Request;", "websocketFactory", "Lorg/http4k/websocket/WebsocketFactory;", "capabilities", "Lorg/http4k/ai/mcp/protocol/ClientCapabilities;", "protocolVersion", "Lorg/http4k/ai/mcp/protocol/ProtocolVersion;", "title", "", "defaultTimeout", "Ljava/time/Duration;", "random", "Lkotlin/random/Random;", "<init>", "(Lorg/http4k/ai/mcp/model/McpEntity;Lorg/http4k/ai/mcp/protocol/Version;Lorg/http4k/core/Request;Lorg/http4k/websocket/WebsocketFactory;Lorg/http4k/ai/mcp/protocol/ClientCapabilities;Lorg/http4k/ai/mcp/protocol/ProtocolVersion;Ljava/lang/String;Ljava/time/Duration;Lkotlin/random/Random;)V", "wsClient", "Lorg/http4k/websocket/WsClient;", "getWsClient", "()Lorg/http4k/websocket/WsClient;", "wsClient$delegate", "Lkotlin/Lazy;", "received", "Lkotlin/sequences/Sequence;", "Lorg/http4k/sse/SseMessage;", "endpoint", "", "it", "Lorg/http4k/sse/SseMessage$Event;", "notify", "Ldev/forkhandles/result4k/Success;", "rpc", "Lorg/http4k/ai/mcp/protocol/messages/McpRpc;", "mcp", "Lorg/http4k/ai/mcp/protocol/messages/ClientMessage$Notification;", "sendMessage", "Ldev/forkhandles/result4k/Result;", "Lorg/http4k/ai/mcp/model/McpMessageId;", "Lorg/http4k/ai/mcp/McpError;", "message", "Lorg/http4k/ai/mcp/protocol/messages/ClientMessage;", "timeout", "messageId", "isComplete", "Lkotlin/Function1;", "Lorg/http4k/format/MoshiNode;", "Lorg/http4k/ai/mcp/util/McpNodeType;", "", "close", "http4k-ai-mcp-client"})
@SourceDebugExtension(value={"SMAP\nWebsocketMcpClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebsocketMcpClient.kt\norg/http4k/ai/mcp/client/websocket/WebsocketMcpClient\n+ 2 result.kt\ndev/forkhandles/result4k/ResultKt\n*L\n1#1,119:1\n22#2,5:120\n77#2,4:125\n48#2,2:129\n22#2,5:131\n77#2,4:136\n42#2,10:140\n50#2,2:150\n*S KotlinDebug\n*F\n+ 1 WebsocketMcpClient.kt\norg/http4k/ai/mcp/client/websocket/WebsocketMcpClient\n*L\n84#1:120,5\n105#1:125,4\n106#1:129,2\n107#1:131,5\n109#1:136,4\n110#1:140,10\n106#1:150,2\n*E\n"})
public final class WebsocketMcpClient
extends AbstractMcpClient {
    @NotNull
    private final Request wsRequest;
    @NotNull
    private final WebsocketFactory websocketFactory;
    @NotNull
    private final Lazy wsClient$delegate;

    public WebsocketMcpClient(@NotNull McpEntity name, @NotNull Version version, @NotNull Request wsRequest, @NotNull WebsocketFactory websocketFactory, @NotNull ClientCapabilities capabilities, @NotNull ProtocolVersion protocolVersion, @Nullable String title, @NotNull Duration defaultTimeout, @NotNull Random random) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)wsRequest, (String)"wsRequest");
        Intrinsics.checkNotNullParameter((Object)websocketFactory, (String)"websocketFactory");
        Intrinsics.checkNotNullParameter((Object)capabilities, (String)"capabilities");
        Intrinsics.checkNotNullParameter((Object)protocolVersion, (String)"protocolVersion");
        Intrinsics.checkNotNullParameter((Object)defaultTimeout, (String)"defaultTimeout");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        super(new VersionedMcpEntity(name, version, title), capabilities, protocolVersion, defaultTimeout, random);
        this.wsRequest = wsRequest;
        this.websocketFactory = websocketFactory;
        this.wsClient$delegate = LazyKt.lazy(() -> WebsocketMcpClient.wsClient_delegate$lambda$0(this, protocolVersion));
    }

    public /* synthetic */ WebsocketMcpClient(McpEntity mcpEntity, Version version, Request request2, WebsocketFactory websocketFactory, ClientCapabilities clientCapabilities, ProtocolVersion protocolVersion, String string, Duration duration, Random random, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            clientCapabilities = ClientCapabilities.Companion.getAll();
        }
        if ((n & 0x20) != 0) {
            protocolVersion = ProtocolVersion.Companion.getLATEST_VERSION();
        }
        if ((n & 0x40) != 0) {
            string = null;
        }
        if ((n & 0x80) != 0) {
            Duration duration2 = Duration.ofSeconds(1L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            duration = duration2;
        }
        if ((n & 0x100) != 0) {
            random = (Random)Random.Default;
        }
        this(mcpEntity, version, request2, websocketFactory, clientCapabilities, protocolVersion, string, duration, random);
    }

    private final WsClient getWsClient() {
        Lazy lazy = this.wsClient$delegate;
        return (WsClient)lazy.getValue();
    }

    @Override
    @NotNull
    protected Sequence<SseMessage> received() {
        return SequencesKt.map((Sequence)this.getWsClient().received(), WebsocketMcpClient::received$lambda$1);
    }

    @Override
    protected void endpoint(@NotNull SseMessage.Event it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    @NotNull
    protected Success<Unit> notify(@NotNull McpRpc rpc, @NotNull ClientMessage.Notification mcp) {
        Intrinsics.checkNotNullParameter((Object)rpc, (String)"rpc");
        Intrinsics.checkNotNullParameter((Object)mcp, (String)"mcp");
        McpJson $this$notify_u24lambda_u242 = McpJson.INSTANCE;
        boolean bl = false;
        this.getWsClient().send(new WsMessage($this$notify_u24lambda_u242.compact(JsonRpcExtensionsKt.renderRequest((Json)((Json)$this$notify_u24lambda_u242), (String)((String)rpc.getMethod().getValue()), (Object)$this$notify_u24lambda_u242.asJsonObject((Object)mcp), (Object)$this$notify_u24lambda_u242.nullNode())), null, 2, null));
        return new Success((Object)Unit.INSTANCE);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    protected Result<McpMessageId, McpError> sendMessage(@NotNull McpRpc rpc, @NotNull ClientMessage message, @NotNull Duration timeout, @NotNull McpMessageId messageId, @NotNull Function1<? super MoshiNode, Boolean> isComplete) {
        Result result;
        void $this$flatMap$iv;
        Result result2;
        void $this$flatMapFailure$iv;
        Result result3;
        Intrinsics.checkNotNullParameter((Object)rpc, (String)"rpc");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter(isComplete, (String)"isComplete");
        CountDownLatch latch = new CountDownLatch(message instanceof ClientMessage.Notification ? 0 : 1);
        boolean $i$f$resultFrom22 = false;
        try {
            boolean bl = false;
            ((Map)this.getRequests()).put(messageId, latch);
            ((Map)this.getMessageQueues()).put(messageId, new LinkedBlockingQueue());
            McpJson $this$sendMessage_u24lambda_u244_u24lambda_u243 = McpJson.INSTANCE;
            boolean bl2 = false;
            MoshiNode payload = $this$sendMessage_u24lambda_u244_u24lambda_u243.asJsonObject((Object)message);
            this.getWsClient().send(new WsMessage($this$sendMessage_u24lambda_u244_u24lambda_u243.compact((Object)(message instanceof ClientMessage.Response ? (MoshiNode)JsonRpcExtensionsKt.renderResult((Json)((Json)$this$sendMessage_u24lambda_u244_u24lambda_u243), (Object)payload, (Object)$this$sendMessage_u24lambda_u244_u24lambda_u243.asJsonObject((Object)messageId)) : (MoshiNode)JsonRpcExtensionsKt.renderRequest((Json)((Json)$this$sendMessage_u24lambda_u244_u24lambda_u243), (String)((String)rpc.getMethod().getValue()), (Object)payload, (Object)$this$sendMessage_u24lambda_u244_u24lambda_u243.asJsonObject((Object)messageId)))), null, 2, null));
            McpMessageId mcpMessageId = messageId;
            result3 = (Result)new Success((Object)mcpMessageId);
        }
        catch (Exception x$iv) {
            result3 = (Result)new Failure((Object)x$iv);
        }
        Result $i$f$resultFrom22 = result3;
        boolean $i$f$flatMapFailure = false;
        void var9_10 = $this$flatMapFailure$iv;
        if (var9_10 instanceof Success) {
            result2 = $this$flatMapFailure$iv;
        } else {
            if (!(var9_10 instanceof Failure)) throw new NoWhenBranchMatchedException();
            Exception it = (Exception)((Failure)$this$flatMapFailure$iv).getReason();
            boolean bl = false;
            result2 = (Result)new Failure((Object)new McpError.Internal(it));
        }
        $this$flatMapFailure$iv = result2;
        boolean $i$f$flatMap = false;
        var9_10 = $this$flatMap$iv;
        if (var9_10 instanceof Success) {
            void $this$map$iv;
            Result result4;
            void $this$flatMapFailure$iv2;
            Result result5;
            McpMessageId reqId = (McpMessageId)((Success)$this$flatMap$iv).getValue();
            boolean bl = false;
            boolean $i$f$resultFrom32 = false;
            try {
                boolean bl3 = false;
                if (!latch.await(timeout.toMillis(), TimeUnit.MILLISECONDS)) {
                    throw new IllegalStateException("Timeout waiting for init".toString());
                }
                Unit unit = Unit.INSTANCE;
                result5 = (Result)new Success((Object)unit);
            }
            catch (Exception x$iv) {
                result5 = (Result)new Failure((Object)x$iv);
            }
            Result $i$f$resultFrom32 = result5;
            boolean $i$f$flatMapFailure2 = false;
            result5 = $this$flatMapFailure$iv2;
            if (result5 instanceof Success) {
                result4 = $this$flatMapFailure$iv2;
            } else {
                if (!(result5 instanceof Failure)) throw new NoWhenBranchMatchedException();
                Exception it = (Exception)((Failure)$this$flatMapFailure$iv2).getReason();
                boolean bl4 = false;
                result4 = this.failWith((McpError)McpError.Timeout.INSTANCE, messageId);
            }
            $this$flatMapFailure$iv2 = result4;
            boolean $i$f$map = false;
            void $this$flatMap$iv$iv = $this$map$iv;
            boolean $i$f$flatMap2 = false;
            void var17_29 = $this$flatMap$iv$iv;
            if (var17_29 instanceof Success) {
                Object value$iv = ((Success)$this$flatMap$iv$iv).getValue();
                boolean bl5 = false;
                Unit it = (Unit)value$iv;
                boolean bl6 = false;
                McpMessageId mcpMessageId = reqId;
                result = (Result)new Success((Object)mcpMessageId);
                return result;
            } else {
                if (!(var17_29 instanceof Failure)) throw new NoWhenBranchMatchedException();
                result = $this$flatMap$iv$iv;
            }
            return result;
        }
        if (!(var9_10 instanceof Failure)) throw new NoWhenBranchMatchedException();
        result = $this$flatMap$iv;
        return result;
    }

    @Override
    public void close() {
        super.close();
        this.getWsClient().close();
    }

    private static final WsClient wsClient_delegate$lambda$0(WebsocketMcpClient this$0, ProtocolVersion $protocolVersion) {
        Function1[] function1Array = new Function1[]{McpExtensionsKt.getMCP_PROTOCOL_VERSION((Header)Header.INSTANCE).of((Object)$protocolVersion)};
        return this$0.websocketFactory.blocking(this$0.wsRequest.getUri(), ((Request)HttpKt.with((HttpMessage)((HttpMessage)this$0.wsRequest), (Function1[])function1Array)).getHeaders());
    }

    private static final SseMessage received$lambda$1(WsMessage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SseMessage.Companion.parse(it.bodyString());
    }
}

