/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.ai.mcp.util;

import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.http4k.ai.mcp.model.ResourceUriTemplate;
import org.http4k.core.Uri;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0010\f\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\fH\u0002J$\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u000fH\u0002J$\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u000fH\u0002J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0002J\f\u0010\u0017\u001a\u00020\u0007*\u00020\u0018H\u0002J\f\u0010\u0019\u001a\u00020\u0007*\u00020\u0018H\u0002J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/http4k/ai/mcp/util/Rfc6570UriTemplateMatcher;", "", "<init>", "()V", "templateExpressionRegex", "Lkotlin/text/Regex;", "matches", "", "Lorg/http4k/ai/mcp/model/ResourceUriTemplate;", "testUri", "Lorg/http4k/core/Uri;", "expand", "", "template", "variables", "", "convertTemplateToPattern", "expandSimple", "variableList", "expandReserved", "percentEncode", "value", "percentEncodeReserved", "isUnreservedChar", "", "isReservedChar", "escapeRegex", "input", "http4k-ai-mcp-core"})
@SourceDebugExtension(value={"SMAP\nRfc6570UriTemplateMatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Rfc6570UriTemplateMatcher.kt\norg/http4k/ai/mcp/util/Rfc6570UriTemplateMatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,244:1\n1617#2,9:245\n1869#2:254\n1870#2:256\n1626#2:257\n1617#2,9:258\n1869#2:267\n1870#2:269\n1626#2:270\n1#3:255\n1#3:268\n13479#4,2:271\n975#5:273\n1046#5,3:274\n*S KotlinDebug\n*F\n+ 1 Rfc6570UriTemplateMatcher.kt\norg/http4k/ai/mcp/util/Rfc6570UriTemplateMatcher\n*L\n147#1:245,9\n147#1:254\n147#1:256\n147#1:257\n172#1:258,9\n172#1:267\n172#1:269\n172#1:270\n147#1:255\n172#1:268\n213#1:271,2\n239#1:273\n239#1:274,3\n*E\n"})
public final class Rfc6570UriTemplateMatcher {
    @NotNull
    public static final Rfc6570UriTemplateMatcher INSTANCE = new Rfc6570UriTemplateMatcher();
    @NotNull
    private static final Regex templateExpressionRegex = new Regex("\\{([+#]?)([^}]+)\\}");

    private Rfc6570UriTemplateMatcher() {
    }

    public final boolean matches(@NotNull ResourceUriTemplate $this$matches, @NotNull Uri testUri) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$matches), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)testUri, (String)"testUri");
        String template = (String)$this$matches.getValue();
        String uri = testUri.toString();
        if (Intrinsics.areEqual((Object)uri, (Object)template)) {
            return true;
        }
        Regex pattern = this.convertTemplateToPattern(template);
        try {
            bl = pattern.matches((CharSequence)uri);
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final String expand(@NotNull String template, @NotNull Map<String, ? extends Object> variables) {
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter(variables, (String)"variables");
        StringBuilder result = new StringBuilder();
        int pos = 0;
        for (MatchResult match : Regex.findAll$default((Regex)templateExpressionRegex, (CharSequence)template, (int)0, (int)2, null)) {
            String string2 = template.substring(pos, match.getRange().getFirst());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            result.append(string2);
            String operator = (String)match.getGroupValues().get(1);
            String variableList = (String)match.getGroupValues().get(2);
            String string3 = operator;
            if (Intrinsics.areEqual((Object)string3, (Object)"+")) {
                v1 = result.append(this.expandReserved(variableList, variables));
            } else if (Intrinsics.areEqual((Object)string3, (Object)"#")) {
                String expanded = this.expandReserved(variableList, variables);
                if (((CharSequence)expanded).length() > 0) {
                    result.append("#").append(expanded);
                }
                v1 = Unit.INSTANCE;
            } else {
                v1 = result.append(this.expandSimple(variableList, variables));
            }
            pos = match.getRange().getLast() + 1;
        }
        if (pos < template.length()) {
            String string4 = template.substring(pos);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            result.append(string4);
        }
        String string5 = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toString(...)");
        return string5;
    }

    private final Regex convertTemplateToPattern(String template) {
        StringBuilder patternBuilder = new StringBuilder("^");
        int pos = 0;
        for (MatchResult match : Regex.findAll$default((Regex)templateExpressionRegex, (CharSequence)template, (int)0, (int)2, null)) {
            String literal;
            Intrinsics.checkNotNullExpressionValue((Object)template.substring(pos, match.getRange().getFirst()), (String)"substring(...)");
            patternBuilder.append(this.escapeRegex(literal));
            String operator = (String)match.getGroupValues().get(1);
            String variableSpec = (String)match.getGroupValues().get(2);
            String string2 = operator;
            String variablePattern = Intrinsics.areEqual((Object)string2, (Object)"+") ? (Intrinsics.areEqual((Object)variableSpec, (Object)"path") ? "([^/]+(?:/[^/]+)*|/[^/]*(?:/[^/]*)*|)" : "([^/]*)") : (Intrinsics.areEqual((Object)string2, (Object)"#") ? "(.*)" : (Intrinsics.areEqual((Object)variableSpec, (Object)"empty") ? "()" : "([^/]*)"));
            patternBuilder.append(variablePattern);
            pos = match.getRange().getLast() + 1;
        }
        if (pos < template.length()) {
            String string3 = template.substring(pos);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            patternBuilder.append(this.escapeRegex(string3));
        }
        patternBuilder.append("$");
        String string4 = patternBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        String string5 = string4;
        RegexOption regexOption = RegexOption.IGNORE_CASE;
        return new Regex(string5, regexOption);
    }

    /*
     * WARNING - void declaration
     */
    private final String expandSimple(String variableList, Map<String, ? extends Object> variables) {
        void $this$mapNotNullTo$iv$iv;
        String[] stringArray = new String[]{","};
        List varSpecs = StringsKt.split$default((CharSequence)variableList, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        Iterable $this$mapNotNull$iv = varSpecs;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String varSpec = (String)element$iv$iv;
            boolean bl2 = false;
            String varName = ((Object)StringsKt.trim((CharSequence)varSpec)).toString();
            Object value2 = variables.get(varName);
            if ((value2 != null ? (value2 instanceof String && ((CharSequence)value2).length() == 0 ? "" : INSTANCE.percentEncode(value2.toString())) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List expanded = (List)destination$iv$iv;
        return CollectionsKt.joinToString$default((Iterable)expanded, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String expandReserved(String variableList, Map<String, ? extends Object> variables) {
        void $this$mapNotNullTo$iv$iv;
        String[] stringArray = new String[]{","};
        List varSpecs = StringsKt.split$default((CharSequence)variableList, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        Iterable $this$mapNotNull$iv = varSpecs;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String varSpec = (String)element$iv$iv;
            boolean bl2 = false;
            String varName = ((Object)StringsKt.trim((CharSequence)varSpec)).toString();
            Object value2 = variables.get(varName);
            if ((value2 != null ? (value2 instanceof String && ((CharSequence)value2).length() == 0 ? "" : INSTANCE.percentEncodeReserved(value2.toString())) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List expanded = (List)destination$iv$iv;
        return CollectionsKt.joinToString$default((Iterable)expanded, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
    }

    private final String percentEncode(String value2) {
        String string2 = URLEncoder.encode(value2, StandardCharsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encode(...)");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)string2, (String)"+", (String)"%20", (boolean)false, (int)4, null), (String)"%7E", (String)"~", (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String percentEncodeReserved(String value2) {
        StringBuilder result = new StringBuilder();
        int n = value2.length();
        for (int i = 0; i < n; ++i) {
            void $this$forEach$iv;
            StringBuilder stringBuilder;
            char c = value2.charAt(i);
            if (this.isUnreservedChar(c)) {
                stringBuilder = result.append(c);
                continue;
            }
            if (this.isReservedChar(c)) {
                stringBuilder = result.append(c);
                continue;
            }
            Object object = String.valueOf(c);
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = ((String)object).getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            object = byArray;
            boolean $i$f$forEach = false;
            int n2 = ((void)$this$forEach$iv).length;
            for (int j = 0; j < n2; ++j) {
                void element$iv;
                void byteVal = element$iv = $this$forEach$iv[j];
                boolean bl = false;
                String string2 = "%%%02X";
                Object[] objectArray = new Object[]{(byte)byteVal};
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                result.append(string3);
            }
            stringBuilder = Unit.INSTANCE;
        }
        String string4 = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        return string4;
    }

    private final boolean isUnreservedChar(char $this$isUnreservedChar) {
        return Character.isLetterOrDigit($this$isUnreservedChar) || $this$isUnreservedChar == '-' || $this$isUnreservedChar == '.' || $this$isUnreservedChar == '_' || $this$isUnreservedChar == '~';
    }

    private final boolean isReservedChar(char $this$isReservedChar) {
        return StringsKt.contains$default((CharSequence)"/:?#[]@!$&'()*+,;=", (char)$this$isReservedChar, (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String escapeRegex(String input) {
        void $this$mapTo$iv$iv;
        String specialChars = ".^$*+?()[]{}|\\/";
        CharSequence $this$map$iv = input;
        boolean $i$f$map = false;
        CharSequence charSequence = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length());
        boolean $i$f$mapTo = false;
        for (int i = 0; i < $this$mapTo$iv$iv.length(); ++i) {
            void char_;
            char item$iv$iv;
            char c = item$iv$iv = $this$mapTo$iv$iv.charAt(i);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringsKt.contains$default((CharSequence)specialChars, (char)char_, (boolean)false, (int)2, null) ? "\\" + (char)char_ : String.valueOf((char)char_));
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }
}

