/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.ai.mcp.server.capability;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.http4k.ai.mcp.Client;
import org.http4k.ai.mcp.model.Meta;
import org.http4k.ai.mcp.model.Resource;
import org.http4k.ai.mcp.model.ResourceName;
import org.http4k.ai.mcp.model.ResourceUriTemplate;
import org.http4k.ai.mcp.protocol.McpException;
import org.http4k.ai.mcp.protocol.messages.McpResource;
import org.http4k.ai.mcp.server.capability.RecursionMode;
import org.http4k.ai.mcp.server.protocol.Resources;
import org.http4k.connect.model.Base64Blob;
import org.http4k.connect.model.MimeType;
import org.http4k.core.ContentType;
import org.http4k.core.MimeTypes;
import org.http4k.core.Request;
import org.http4k.core.Uri;
import org.http4k.jsonrpc.ErrorMessage;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0004\b\f\u0010\rJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\f\u0010\u001c\u001a\u00020\u001d*\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/http4k/ai/mcp/server/capability/DirectoryResources;", "Lorg/http4k/ai/mcp/server/protocol/Resources;", "dir", "Ljava/io/File;", "recursive", "Lorg/http4k/ai/mcp/server/capability/RecursionMode;", "mimeTypes", "Lorg/http4k/core/MimeTypes;", "isText", "Lkotlin/Function1;", "Lorg/http4k/core/ContentType;", "", "<init>", "(Ljava/io/File;Lorg/http4k/ai/mcp/server/capability/RecursionMode;Lorg/http4k/core/MimeTypes;Lkotlin/jvm/functions/Function1;)V", "listResources", "Lorg/http4k/ai/mcp/protocol/messages/McpResource$List$Response;", "req", "Lorg/http4k/ai/mcp/protocol/messages/McpResource$List$Request;", "client", "Lorg/http4k/ai/mcp/Client;", "http", "Lorg/http4k/core/Request;", "listTemplates", "Lorg/http4k/ai/mcp/protocol/messages/McpResource$ListTemplates$Response;", "Lorg/http4k/ai/mcp/protocol/messages/McpResource$ListTemplates$Request;", "read", "Lorg/http4k/ai/mcp/protocol/messages/McpResource$Read$Response;", "Lorg/http4k/ai/mcp/protocol/messages/McpResource$Read$Request;", "toResource", "Lorg/http4k/ai/mcp/protocol/messages/McpResource;", "Companion", "http4k-ai-mcp-sdk"})
@SourceDebugExtension(value={"SMAP\nDirectoryResources.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectoryResources.kt\norg/http4k/ai/mcp/server/capability/DirectoryResources\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n3829#2:125\n4344#2,2:126\n1563#3:128\n1634#3,3:129\n1563#3:132\n1634#3,3:133\n*S KotlinDebug\n*F\n+ 1 DirectoryResources.kt\norg/http4k/ai/mcp/server/capability/DirectoryResources\n*L\n42#1:125\n42#1:126,2\n42#1:128\n42#1:129,3\n115#1:132\n115#1:133,3\n*E\n"})
public final class DirectoryResources
implements Resources {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final File dir;
    @NotNull
    private final RecursionMode recursive;
    @NotNull
    private final MimeTypes mimeTypes;
    @NotNull
    private final Function1<ContentType, Boolean> isText;
    @NotNull
    private static final Function1<ContentType, Boolean> DEFAULT_TEXT_TYPES = DirectoryResources::DEFAULT_TEXT_TYPES$lambda$5;

    public DirectoryResources(@NotNull File dir, @NotNull RecursionMode recursive, @NotNull MimeTypes mimeTypes, @NotNull Function1<? super ContentType, Boolean> isText) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)((Object)recursive), (String)"recursive");
        Intrinsics.checkNotNullParameter((Object)mimeTypes, (String)"mimeTypes");
        Intrinsics.checkNotNullParameter(isText, (String)"isText");
        this.dir = dir;
        this.recursive = recursive;
        this.mimeTypes = mimeTypes;
        this.isText = isText;
    }

    public /* synthetic */ DirectoryResources(File file, RecursionMode recursionMode, MimeTypes mimeTypes, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            mimeTypes = MimeTypes.Companion.invoke$default((MimeTypes.Companion)MimeTypes.Companion, null, (int)1, null);
        }
        if ((n & 8) != 0) {
            function1 = DEFAULT_TEXT_TYPES;
        }
        this(file, recursionMode, mimeTypes, function1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public McpResource.List.Response listResources(@NotNull McpResource.List.Request req, @NotNull Client client, @NotNull Request http) {
        Sequence sequence;
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        switch (WhenMappings.$EnumSwitchMapping$0[this.recursive.ordinal()]) {
            case 1: {
                sequence = this.dir.listFiles();
                if (sequence != null) {
                    void $this$mapTo$iv$iv;
                    File it;
                    void $this$filterTo$iv$iv;
                    Sequence $this$filter$iv = sequence;
                    boolean $i$f$filter = false;
                    Sequence sequence2 = $this$filter$iv;
                    Iterable<void> destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (void element$iv$iv : $this$filterTo$iv$iv) {
                        it = element$iv$iv;
                        boolean bl = false;
                        if (!it.isFile()) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$map = false;
                    destination$iv$iv = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        it = (File)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it);
                        collection.add(this.toResource(it));
                    }
                    sequence = CollectionsKt.asSequence((Iterable)((List)destination$iv$iv2));
                    if (sequence != null) break;
                }
                sequence = SequencesKt.emptySequence();
                break;
            }
            case 2: {
                sequence = SequencesKt.map((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)this.dir)), DirectoryResources::listResources$lambda$2), arg_0 -> DirectoryResources.listResources$lambda$3(this, arg_0));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 6;
        Meta meta = null;
        String string = null;
        List list = SequencesKt.toList((Sequence)sequence);
        return new McpResource.List.Response(list, string, meta, n, defaultConstructorMarker);
    }

    @Override
    @NotNull
    public McpResource.ListTemplates.Response listTemplates(@NotNull McpResource.ListTemplates.Request req, @NotNull Client client, @NotNull Request http) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        ResourceUriTemplate resourceUriTemplate = (ResourceUriTemplate)ResourceUriTemplate.Companion.of((Object)(switch (WhenMappings.$EnumSwitchMapping$0[this.recursive.ordinal()]) {
            case 1 -> "file://{filename}";
            case 2 -> "file://{+path}";
            default -> throw new NoWhenBranchMatchedException();
        }));
        String string = this.dir.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return new McpResource.ListTemplates.Response(CollectionsKt.listOf((Object)new McpResource(resourceUriTemplate, (ResourceName)ResourceName.Companion.of((Object)string), "Files in " + this.dir.getName() + ", recursively: " + this.recursive, null, null, null, null, 120, null)), null, null, 6, null);
    }

    @Override
    @NotNull
    public McpResource.Read.Response read(@NotNull McpResource.Read.Request req, @NotNull Client client, @NotNull Request http) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)http, (String)"http");
        String path = StringsKt.substringAfter$default((String)req.getUri().toString(), (String)"file://", null, (int)2, null);
        if (StringsKt.contains$default((CharSequence)path, (char)File.separatorChar, (boolean)false, (int)2, null) && this.recursive == RecursionMode.Flat) {
            throw new McpException(ErrorMessage.Companion.getInvalidParams(), null, 2, null);
        }
        File file = new File(this.dir, path);
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        ContentType contentType = this.mimeTypes.forFile(string);
        if (!file.isFile() || !file.exists()) {
            throw new McpException(ErrorMessage.Companion.getInvalidParams(), null, 2, null);
        }
        return new McpResource.Read.Response(CollectionsKt.listOf((Object)((Boolean)this.isText.invoke((Object)contentType.withNoDirectives()) != false ? (Resource.Content)new Resource.Content.Text(FilesKt.readText$default((File)file, null, (int)1, null), req.getUri(), MimeType.Companion.of(contentType)) : (Resource.Content)new Resource.Content.Blob(Base64Blob.Companion.encode(FilesKt.readBytes((File)file)), req.getUri(), MimeType.Companion.of(contentType)))), null, 2, null);
    }

    private final McpResource toResource(File $this$toResource) {
        Uri uri = Uri.Companion.of("file://" + FilesKt.relativeTo((File)$this$toResource, (File)this.dir));
        String string = $this$toResource.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        ResourceName resourceName = (ResourceName)ResourceName.Companion.of((Object)string);
        String string2 = $this$toResource.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        return new McpResource(uri, resourceName, null, MimeType.Companion.of(this.mimeTypes.forFile(string2)), null, null, null, 68, null);
    }

    private static final boolean listResources$lambda$2(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isFile();
    }

    private static final McpResource listResources$lambda$3(DirectoryResources this$0, File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.toResource(it);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean DEFAULT_TEXT_TYPES$lambda$5(ContentType element) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Object[] objectArray = new ContentType[]{ContentType.Companion.getAPPLICATION_JSON(), ContentType.Companion.getAPPLICATION_XML(), ContentType.Companion.getTEXT_HTML(), ContentType.Companion.getTEXT_PLAIN(), ContentType.Companion.getAPPLICATION_YAML()};
        Iterable $this$map$iv = SetsKt.setOf((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ContentType contentType = (ContentType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.withNoDirectives());
        }
        return ((List)destination$iv$iv).contains(element);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/http4k/ai/mcp/server/capability/DirectoryResources$Companion;", "", "<init>", "()V", "DEFAULT_TEXT_TYPES", "Lkotlin/Function1;", "Lorg/http4k/core/ContentType;", "", "getDEFAULT_TEXT_TYPES", "()Lkotlin/jvm/functions/Function1;", "http4k-ai-mcp-sdk"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function1<ContentType, Boolean> getDEFAULT_TEXT_TYPES() {
            return DEFAULT_TEXT_TYPES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RecursionMode.values().length];
            try {
                nArray[RecursionMode.Flat.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecursionMode.Recursive.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

