/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.ai.mcp.server.http;

import dev.forkhandles.result4k.Result;
import dev.forkhandles.result4k.Success;
import dev.forkhandles.time.executors.SimpleScheduler;
import dev.forkhandles.time.executors.SimpleSchedulerService;
import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.sequences.Sequence;
import org.http4k.ai.mcp.protocol.SessionId;
import org.http4k.ai.mcp.server.protocol.ClientRequestContext;
import org.http4k.ai.mcp.server.protocol.Session;
import org.http4k.ai.mcp.server.protocol.SessionState;
import org.http4k.ai.mcp.server.protocol.Sessions;
import org.http4k.ai.mcp.server.sessions.SessionEventStore;
import org.http4k.ai.mcp.server.sessions.SessionEventTracking;
import org.http4k.ai.mcp.server.sessions.SessionProvider;
import org.http4k.ai.mcp.util.McpJson;
import org.http4k.core.Request;
import org.http4k.format.MoshiNode;
import org.http4k.lens.Header;
import org.http4k.lens.McpExtensionsKt;
import org.http4k.lens.SseLensesKt;
import org.http4k.sse.Sse;
import org.http4k.sse.SseEventId;
import org.http4k.sse.SseMessage;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001c\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015H\u0016JP\u0010\u0016\u001a.\u0012\b\u0012\u00060\u0014j\u0002`\u0015\u0012\b\u0012\u00060\u0014j\u0002`\u00150\u0017j\u0016\u0012\b\u0012\u00060\u0014j\u0002`\u0015\u0012\b\u0012\u00060\u0014j\u0002`\u0015`\u00182\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u001b2\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015H\u0016J \u0010\u001c\u001a\u00020\u0011*\u00020\u00022\n\u0010\u0013\u001a\u00060\u0014j\u0002`\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001e\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00110\u001fH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\u0010\u0010%\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J \u0010&\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020#H\u0016J\u0014\u0010'\u001a\u0006\u0012\u0002\b\u00030(2\b\b\u0002\u0010)\u001a\u00020*J\b\u0010+\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/http4k/ai/mcp/server/http/HttpStreamingSessions;", "Lorg/http4k/ai/mcp/server/protocol/Sessions;", "Lorg/http4k/sse/Sse;", "sessionProvider", "Lorg/http4k/ai/mcp/server/sessions/SessionProvider;", "sessionEventTracking", "Lorg/http4k/ai/mcp/server/sessions/SessionEventTracking;", "eventStore", "Lorg/http4k/ai/mcp/server/sessions/SessionEventStore;", "keepAliveDelay", "Ljava/time/Duration;", "<init>", "(Lorg/http4k/ai/mcp/server/sessions/SessionProvider;Lorg/http4k/ai/mcp/server/sessions/SessionEventTracking;Lorg/http4k/ai/mcp/server/sessions/SessionEventStore;Ljava/time/Duration;)V", "clientConnections", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/http4k/ai/mcp/server/protocol/ClientRequestContext;", "request", "", "context", "message", "Lorg/http4k/format/MoshiNode;", "Lorg/http4k/ai/mcp/util/McpNodeType;", "respond", "Ldev/forkhandles/result4k/Result;", "Ldev/forkhandles/result4k/Result4k;", "transport", "session", "Lorg/http4k/ai/mcp/server/protocol/Session;", "sendAndStore", "onClose", "fn", "Lkotlin/Function0;", "retrieveSession", "Lorg/http4k/ai/mcp/server/protocol/SessionState;", "connectRequest", "Lorg/http4k/core/Request;", "transportFor", "end", "assign", "start", "Ljava/util/concurrent/ScheduledFuture;", "executor", "Ldev/forkhandles/time/executors/SimpleScheduler;", "pruneDeadConnections", "http4k-ai-mcp-sdk"})
@SourceDebugExtension(value={"SMAP\nHttpStreamingSessions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpStreamingSessions.kt\norg/http4k/ai/mcp/server/http/HttpStreamingSessions\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,103:1\n1#2:104\n1321#3,2:105\n488#4,7:107\n1869#5,2:114\n*S KotlinDebug\n*F\n+ 1 HttpStreamingSessions.kt\norg/http4k/ai/mcp/server/http/HttpStreamingSessions\n*L\n83#1:105,2\n92#1:107,7\n94#1:114,2\n*E\n"})
public final class HttpStreamingSessions
implements Sessions<Sse> {
    @NotNull
    private final SessionProvider sessionProvider;
    @NotNull
    private final SessionEventTracking sessionEventTracking;
    @NotNull
    private final SessionEventStore eventStore;
    @NotNull
    private final Duration keepAliveDelay;
    @NotNull
    private final ConcurrentHashMap<ClientRequestContext, Sse> clientConnections;

    public HttpStreamingSessions(@NotNull SessionProvider sessionProvider, @NotNull SessionEventTracking sessionEventTracking, @NotNull SessionEventStore eventStore, @NotNull Duration keepAliveDelay) {
        Intrinsics.checkNotNullParameter((Object)sessionProvider, (String)"sessionProvider");
        Intrinsics.checkNotNullParameter((Object)sessionEventTracking, (String)"sessionEventTracking");
        Intrinsics.checkNotNullParameter((Object)eventStore, (String)"eventStore");
        Intrinsics.checkNotNullParameter((Object)keepAliveDelay, (String)"keepAliveDelay");
        this.sessionProvider = sessionProvider;
        this.sessionEventTracking = sessionEventTracking;
        this.eventStore = eventStore;
        this.keepAliveDelay = keepAliveDelay;
        this.clientConnections = new ConcurrentHashMap();
    }

    public /* synthetic */ HttpStreamingSessions(SessionProvider sessionProvider, SessionEventTracking sessionEventTracking, SessionEventStore sessionEventStore, Duration duration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            sessionProvider = SessionProvider.Companion.Random((Random)Random.Default);
        }
        if ((n & 2) != 0) {
            sessionEventTracking = SessionEventTracking.Companion.InMemory();
        }
        if ((n & 4) != 0) {
            sessionEventStore = SessionEventStore.Companion.InMemory(100);
        }
        if ((n & 8) != 0) {
            Duration duration2 = Duration.ofSeconds(2L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            duration = duration2;
        }
        this(sessionProvider, sessionEventTracking, sessionEventStore, duration);
    }

    @Override
    public void request(@NotNull ClientRequestContext context, @NotNull MoshiNode message) {
        Sse sse;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        ClientRequestContext clientRequestContext = context;
        if (clientRequestContext instanceof ClientRequestContext.ClientCall) {
            sse = this.clientConnections.get(context);
        } else if (clientRequestContext instanceof ClientRequestContext.Subscription) {
            sse = this.clientConnections.get(context);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Sse sse2 = sse;
        if (sse2 != null) {
            this.sendAndStore(sse2, message, context.getSession());
        }
    }

    @Override
    @NotNull
    public Result<MoshiNode, MoshiNode> respond(@NotNull Sse transport, @NotNull Session session, @NotNull MoshiNode message) {
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.sendAndStore(transport, message, session);
        return (Result)new Success((Object)message);
    }

    private final void sendAndStore(Sse $this$sendAndStore, MoshiNode message, Session session) {
        SseMessage.Event event;
        SseMessage.Event it = event = new SseMessage.Event("message", McpJson.INSTANCE.compact((Object)message), this.sessionEventTracking.next-YJLXm0Y(session), null);
        boolean bl = false;
        $this$sendAndStore.send((SseMessage)it);
        this.eventStore.write(session, it);
    }

    @Override
    public void onClose(@NotNull ClientRequestContext context, @NotNull Function0<Unit> fn) {
        block0: {
            Sse sse;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(fn, (String)"fn");
            Sse sse2 = this.clientConnections.get(context);
            if (sse2 == null) break block0;
            Sse it = sse = sse2;
            boolean bl = false;
            it.onClose(fn);
        }
    }

    @Override
    @NotNull
    public SessionState retrieveSession(@NotNull Request connectRequest) {
        Intrinsics.checkNotNullParameter((Object)connectRequest, (String)"connectRequest");
        return this.sessionProvider.validate(connectRequest, (SessionId)McpExtensionsKt.getMCP_SESSION_ID((Header)Header.INSTANCE).invoke((Object)connectRequest));
    }

    @Override
    @NotNull
    public Sse transportFor(@NotNull ClientRequestContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Sse sse = this.clientConnections.get(context);
        if (sse == null) {
            throw new IllegalStateException("Session not found".toString());
        }
        return sse;
    }

    @Override
    public void end(@NotNull ClientRequestContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ClientRequestContext clientRequestContext = context;
        if (clientRequestContext instanceof ClientRequestContext.ClientCall) {
            this.clientConnections.remove(context);
        } else if (clientRequestContext instanceof ClientRequestContext.Subscription) {
            Sse sse = this.clientConnections.remove(context);
            if (sse != null) {
                sse.close();
            }
            this.sessionEventTracking.remove(((ClientRequestContext.Subscription)context).getSession());
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @Override
    public void assign(@NotNull ClientRequestContext context, @NotNull Sse transport, @NotNull Request connectRequest) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        Intrinsics.checkNotNullParameter((Object)connectRequest, (String)"connectRequest");
        ((Map)this.clientConnections).put(context, transport);
        if (context instanceof ClientRequestContext.Subscription) {
            SseEventId sseEventId = (SseEventId)SseLensesKt.getLAST_EVENT_ID((Header)Header.INSTANCE).invoke((Object)connectRequest);
            Sequence<SseMessage.Event> $this$forEach$iv = this.eventStore.read-TdJEMS8(((ClientRequestContext.Subscription)context).getSession(), sseEventId != null ? sseEventId.unbox-impl() : null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SseMessage p0 = (SseMessage)element$iv;
                boolean bl = false;
                transport.send(p0);
            }
        }
    }

    @NotNull
    public final ScheduledFuture<?> start(@NotNull SimpleScheduler executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        return executor.scheduleWithFixedDelay(this::pruneDeadConnections, this.keepAliveDelay, this.keepAliveDelay);
    }

    public static /* synthetic */ ScheduledFuture start$default(HttpStreamingSessions httpStreamingSessions, SimpleScheduler simpleScheduler, int n, Object object) {
        if ((n & 1) != 0) {
            simpleScheduler = (SimpleScheduler)new SimpleSchedulerService(1);
        }
        return httpStreamingSessions.start(simpleScheduler);
    }

    private final void pruneDeadConnections() {
        Map $this$filterKeys$iv = this.clientConnections;
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            ClientRequestContext it = (ClientRequestContext)entry$iv.getKey();
            boolean bl = false;
            if (!(it instanceof ClientRequestContext.Subscription)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Iterable $this$forEach$iv = MapsKt.toList((Map)result$iv);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            ClientRequestContext session = (ClientRequestContext)pair.component1();
            Sse sse = (Sse)pair.component2();
            try {
                sse.send((SseMessage)new SseMessage.Event("ping", "", null, 4, null));
            }
            catch (Exception e) {
                this.clientConnections.remove(session);
                sse.close();
            }
        }
    }

    public HttpStreamingSessions() {
        this(null, null, null, null, 15, null);
    }
}

