/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.ai.mcp.server.protocol;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.ai.mcp.model.CompletionStatus;
import org.http4k.ai.mcp.model.McpMessageId;
import org.http4k.ai.mcp.protocol.ClientCapabilities;
import org.http4k.ai.mcp.protocol.messages.McpInitialize;
import org.http4k.format.MoshiNode;
import org.http4k.jsonrpc.JsonRpcResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J,\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00102\u001c\u0010\u0019\u001a\u0018\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0013j\u0002`\u00140\u0012\u0012\u0004\u0012\u00020\u00150\u0011J\u001c\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00102\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR0\u0010\u000e\u001a$\u0012\u0004\u0012\u00020\u0010\u0012\u001a\u0012\u0018\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0013j\u0002`\u00140\u0012\u0012\u0004\u0012\u00020\u00150\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/http4k/ai/mcp/server/protocol/ClientTracking;", "", "initialize", "Lorg/http4k/ai/mcp/protocol/messages/McpInitialize$Request;", "<init>", "(Lorg/http4k/ai/mcp/protocol/messages/McpInitialize$Request;)V", "supportsSampling", "", "getSupportsSampling", "()Z", "supportsRoots", "getSupportsRoots", "supportsElicitations", "getSupportsElicitations", "calls", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/http4k/ai/mcp/model/McpMessageId;", "Lkotlin/Function1;", "Lorg/http4k/jsonrpc/JsonRpcResult;", "Lorg/http4k/format/MoshiNode;", "Lorg/http4k/ai/mcp/util/McpNodeType;", "Lorg/http4k/ai/mcp/model/CompletionStatus;", "trackRequest", "", "id", "callback", "processResult", "result", "http4k-ai-mcp-sdk"})
public final class ClientTracking {
    private final boolean supportsSampling;
    private final boolean supportsRoots;
    private final boolean supportsElicitations;
    @NotNull
    private final ConcurrentHashMap<McpMessageId, Function1<JsonRpcResult<MoshiNode>, CompletionStatus>> calls;

    public ClientTracking(@NotNull McpInitialize.Request initialize) {
        Intrinsics.checkNotNullParameter((Object)initialize, (String)"initialize");
        this.supportsSampling = initialize.getCapabilities().getSampling() != null;
        ClientCapabilities.Companion.Roots roots = initialize.getCapabilities().getRoots();
        this.supportsRoots = roots != null ? Intrinsics.areEqual((Object)roots.getListChanged(), (Object)true) : false;
        this.supportsElicitations = initialize.getCapabilities().getElicitation() != null;
        this.calls = new ConcurrentHashMap();
    }

    public final boolean getSupportsSampling() {
        return this.supportsSampling;
    }

    public final boolean getSupportsRoots() {
        return this.supportsRoots;
    }

    public final boolean getSupportsElicitations() {
        return this.supportsElicitations;
    }

    public final void trackRequest(@NotNull McpMessageId id, @NotNull Function1<? super JsonRpcResult<MoshiNode>, ? extends CompletionStatus> callback) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        ((Map)this.calls).put(id, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processResult(@NotNull McpMessageId id, @NotNull JsonRpcResult<MoshiNode> result) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        McpMessageId mcpMessageId = id;
        synchronized (mcpMessageId) {
            CompletionStatus done;
            boolean bl = false;
            CompletionStatus completionStatus = this.calls.get(id);
            if (completionStatus == null || (completionStatus = (CompletionStatus)completionStatus.invoke(result)) == null) {
                completionStatus = CompletionStatus.Finished;
            }
            if ((done = completionStatus) == CompletionStatus.Finished) {
                this.calls.remove(id);
            }
            Unit unit = Unit.INSTANCE;
        }
    }
}

