/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.ai.mcp.server.protocol;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.ai.mcp.model.LogLevel;
import org.http4k.ai.mcp.server.protocol.LogFunction;
import org.http4k.ai.mcp.server.protocol.Logger;
import org.http4k.ai.mcp.server.protocol.Session;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\tH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0016J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\bH\u0016J4\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00170\u0016H\u0016R&\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/http4k/ai/mcp/server/protocol/ServerLogger;", "Lorg/http4k/ai/mcp/server/protocol/Logger;", "<init>", "()V", "subscriptions", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/http4k/ai/mcp/server/protocol/Session;", "Lkotlin/Pair;", "Lorg/http4k/ai/mcp/model/LogLevel;", "Lorg/http4k/ai/mcp/server/protocol/LogFunction;", "subscribe", "", "session", "level", "onLog", "unsubscribe", "setLevel", "newLevel", "log", "logger", "", "data", "", "", "http4k-ai-mcp-sdk"})
public final class ServerLogger
implements Logger {
    @NotNull
    private final ConcurrentHashMap<Session, Pair<LogLevel, LogFunction>> subscriptions = new ConcurrentHashMap();

    @Override
    public void subscribe(@NotNull Session session, @NotNull LogLevel level, @NotNull LogFunction onLog) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)onLog, (String)"onLog");
        ((Map)this.subscriptions).put(session, TuplesKt.to((Object)level, (Object)onLog));
    }

    @Override
    public void unsubscribe(@NotNull Session session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.subscriptions.remove(session);
    }

    @Override
    public void setLevel(@NotNull Session session, @NotNull LogLevel newLevel) {
        block0: {
            Pair<LogLevel, LogFunction> pair;
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)newLevel, (String)"newLevel");
            Pair<LogLevel, LogFunction> pair2 = this.subscriptions.get(session);
            if (pair2 == null) break block0;
            Pair<LogLevel, LogFunction> pair3 = pair = pair2;
            boolean bl = false;
            LogFunction logFunction = (LogFunction)pair3.component2();
            ((Map)this.subscriptions).put(session, TuplesKt.to((Object)newLevel, (Object)logFunction));
        }
    }

    @Override
    public void log(@NotNull Session session, @NotNull LogLevel level, @NotNull String logger, @NotNull Map<String, ? extends Object> data) {
        block1: {
            Pair<LogLevel, LogFunction> pair;
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            Pair<LogLevel, LogFunction> pair2 = this.subscriptions.get(session);
            if (pair2 == null) break block1;
            Pair<LogLevel, LogFunction> pair3 = pair = pair2;
            boolean bl = false;
            LogLevel actualLevel = (LogLevel)pair3.component1();
            LogFunction logFunction = (LogFunction)pair3.component2();
            if (level.compareTo((Enum)actualLevel) >= 0) {
                logFunction.invoke(level, logger, data);
            }
        }
    }
}

