/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.ai.mcp.server.sse;

import dev.forkhandles.result4k.Result;
import dev.forkhandles.result4k.Success;
import dev.forkhandles.time.executors.SimpleScheduler;
import dev.forkhandles.time.executors.SimpleSchedulerService;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import org.http4k.ai.mcp.protocol.SessionId;
import org.http4k.ai.mcp.server.protocol.ClientRequestContext;
import org.http4k.ai.mcp.server.protocol.Session;
import org.http4k.ai.mcp.server.protocol.SessionState;
import org.http4k.ai.mcp.server.protocol.Sessions;
import org.http4k.ai.mcp.server.sessions.SessionEventTracking;
import org.http4k.ai.mcp.server.sessions.SessionProvider;
import org.http4k.ai.mcp.server.sse.SharedKt;
import org.http4k.ai.mcp.util.McpJson;
import org.http4k.core.Request;
import org.http4k.format.MoshiNode;
import org.http4k.sse.Sse;
import org.http4k.sse.SseMessage;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJP\u0010\u000e\u001a.\u0012\b\u0012\u00060\u0010j\u0002`\u0011\u0012\b\u0012\u00060\u0010j\u0002`\u00110\u000fj\u0016\u0012\b\u0012\u00060\u0010j\u0002`\u0011\u0012\b\u0012\u00060\u0010j\u0002`\u0011`\u00122\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\r2\n\u0010\u0015\u001a\u00060\u0010j\u0002`\u0011H\u0016J\u001c\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\n\u0010\u0015\u001a\u00060\u0010j\u0002`\u0011H\u0016J\u001e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00170\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010#\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!H\u0016J\u0014\u0010$\u001a\u0006\u0012\u0002\b\u00030%2\b\b\u0002\u0010&\u001a\u00020'J\b\u0010(\u001a\u00020\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/http4k/ai/mcp/server/sse/SseSessions;", "Lorg/http4k/ai/mcp/server/protocol/Sessions;", "Lorg/http4k/sse/Sse;", "sessionProvider", "Lorg/http4k/ai/mcp/server/sessions/SessionProvider;", "sessionEventTracking", "Lorg/http4k/ai/mcp/server/sessions/SessionEventTracking;", "keepAliveDelay", "Ljava/time/Duration;", "<init>", "(Lorg/http4k/ai/mcp/server/sessions/SessionProvider;Lorg/http4k/ai/mcp/server/sessions/SessionEventTracking;Ljava/time/Duration;)V", "sessions", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/http4k/ai/mcp/server/protocol/Session;", "respond", "Ldev/forkhandles/result4k/Result;", "Lorg/http4k/format/MoshiNode;", "Lorg/http4k/ai/mcp/util/McpNodeType;", "Ldev/forkhandles/result4k/Result4k;", "transport", "session", "message", "request", "", "context", "Lorg/http4k/ai/mcp/server/protocol/ClientRequestContext;", "onClose", "fn", "Lkotlin/Function0;", "end", "retrieveSession", "Lorg/http4k/ai/mcp/server/protocol/SessionState;", "connectRequest", "Lorg/http4k/core/Request;", "transportFor", "assign", "start", "Ljava/util/concurrent/ScheduledFuture;", "executor", "Ldev/forkhandles/time/executors/SimpleScheduler;", "pruneDeadConnections", "http4k-ai-mcp-sdk"})
@SourceDebugExtension(value={"SMAP\nSseSessions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SseSessions.kt\norg/http4k/ai/mcp/server/sse/SseSessions\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1#2:83\n1869#3,2:84\n*S KotlinDebug\n*F\n+ 1 SseSessions.kt\norg/http4k/ai/mcp/server/sse/SseSessions\n*L\n72#1:84,2\n*E\n"})
public final class SseSessions
implements Sessions<Sse> {
    @NotNull
    private final SessionProvider sessionProvider;
    @NotNull
    private final SessionEventTracking sessionEventTracking;
    @NotNull
    private final Duration keepAliveDelay;
    @NotNull
    private final ConcurrentHashMap<Session, Sse> sessions;

    public SseSessions(@NotNull SessionProvider sessionProvider, @NotNull SessionEventTracking sessionEventTracking, @NotNull Duration keepAliveDelay) {
        Intrinsics.checkNotNullParameter((Object)sessionProvider, (String)"sessionProvider");
        Intrinsics.checkNotNullParameter((Object)sessionEventTracking, (String)"sessionEventTracking");
        Intrinsics.checkNotNullParameter((Object)keepAliveDelay, (String)"keepAliveDelay");
        this.sessionProvider = sessionProvider;
        this.sessionEventTracking = sessionEventTracking;
        this.keepAliveDelay = keepAliveDelay;
        this.sessions = new ConcurrentHashMap();
    }

    public /* synthetic */ SseSessions(SessionProvider sessionProvider, SessionEventTracking sessionEventTracking, Duration duration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            sessionProvider = SessionProvider.Companion.Random((Random)Random.Default);
        }
        if ((n & 2) != 0) {
            sessionEventTracking = SessionEventTracking.Companion.InMemory();
        }
        if ((n & 4) != 0) {
            Duration duration2 = Duration.ofSeconds(2L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            duration = duration2;
        }
        this(sessionProvider, sessionEventTracking, duration);
    }

    @Override
    @NotNull
    public Result<MoshiNode, MoshiNode> respond(@NotNull Sse transport, @NotNull Session session, @NotNull MoshiNode message) {
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        transport.send((SseMessage)new SseMessage.Event("message", McpJson.INSTANCE.compact((Object)message), this.sessionEventTracking.next-YJLXm0Y(session), null));
        return (Result)new Success((Object)message);
    }

    @Override
    public void request(@NotNull ClientRequestContext context, @NotNull MoshiNode message) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Sse sse = this.sessions.get(context.getSession());
        if (sse != null) {
            sse.send((SseMessage)new SseMessage.Event("message", McpJson.INSTANCE.compact((Object)message), this.sessionEventTracking.next-YJLXm0Y(context.getSession()), null));
        }
    }

    @Override
    public void onClose(@NotNull ClientRequestContext context, @NotNull Function0<Unit> fn) {
        block0: {
            Sse sse;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(fn, (String)"fn");
            Sse sse2 = this.sessions.get(context.getSession());
            if (sse2 == null) break block0;
            Sse it = sse = sse2;
            boolean bl = false;
            it.onClose(fn);
        }
    }

    @Override
    public void end(@NotNull ClientRequestContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context instanceof ClientRequestContext.Subscription) {
            Sse sse = this.sessions.remove(((ClientRequestContext.Subscription)context).getSession());
            if (sse != null) {
                sse.close();
            }
            this.sessionEventTracking.remove(((ClientRequestContext.Subscription)context).getSession());
        }
    }

    @Override
    @NotNull
    public SessionState retrieveSession(@NotNull Request connectRequest) {
        Intrinsics.checkNotNullParameter((Object)connectRequest, (String)"connectRequest");
        return this.sessionProvider.validate(connectRequest, (SessionId)SharedKt.getSessionId().invoke((Object)connectRequest));
    }

    @Override
    @NotNull
    public Sse transportFor(@NotNull ClientRequestContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Sse sse = this.sessions.get(context.getSession());
        if (sse == null) {
            throw new IllegalStateException("No session".toString());
        }
        return sse;
    }

    @Override
    public void assign(@NotNull ClientRequestContext context, @NotNull Sse transport, @NotNull Request connectRequest) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        Intrinsics.checkNotNullParameter((Object)connectRequest, (String)"connectRequest");
        if (context instanceof ClientRequestContext.Subscription) {
            ((Map)this.sessions).put(((ClientRequestContext.Subscription)context).getSession(), transport);
        }
    }

    @NotNull
    public final ScheduledFuture<?> start(@NotNull SimpleScheduler executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        return executor.scheduleWithFixedDelay(this::pruneDeadConnections, this.keepAliveDelay, this.keepAliveDelay);
    }

    public static /* synthetic */ ScheduledFuture start$default(SseSessions sseSessions, SimpleScheduler simpleScheduler, int n, Object object) {
        if ((n & 1) != 0) {
            simpleScheduler = (SimpleScheduler)new SimpleSchedulerService(1);
        }
        return sseSessions.start(simpleScheduler);
    }

    private final void pruneDeadConnections() {
        Iterable $this$forEach$iv = MapsKt.toList((Map)this.sessions);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            Session session = (Session)pair.component1();
            Sse sse = (Sse)pair.component2();
            try {
                sse.send((SseMessage)new SseMessage.Event("ping", "", null, 4, null));
            }
            catch (Exception e) {
                this.sessions.remove(session);
                sse.close();
            }
        }
    }

    public SseSessions() {
        this(null, null, null, 7, null);
    }
}

